% Script for finding sheetpile depth with LHS/RHS

% Approaches:
% 1) manual
%    - user enters an interval
%    - user picks tolerance
%    - search inside that interval for a root that "works"
%    - if doesn't work, ask for new interval and tolerance
% 2) smarter
%    - user enters interval
%    - program tries increasingly tighter toleranances
%    - good if interval known to contain root
% 3) even better
%    - user enters a known starting point and "direction"
%    - program marches "forward" until sign changes
%    - program remembers interval surrounding sign change
%    - program tries tighter tolerances until finding solution
%------------------------------------------------------------------------------
% I picked #3
% I think I could be handling the boundaries a bit better.
% Also, if the root "hits" zero that's bad! (can't have negative sheet pile)
% Maybe the program could alter the initial interval?
%------------------------------------------------------------------------------
% Refresh the workspace
  clear
  clc
  disp(['Starting LHS/RHS...']);
  
%------------------------------------------------------------------------------
% get Params
  [Gamma, phi, L, P, eps, max_iterations] = getParams;
  
%------------------------------------------------------------------------------
% Guess range for piledepth d (m)
%------------------------------------------------------------------------------
% Get initial guess and direction

% User must enter a positive number
  d = input('Enter your initial guess for pile depth [positive]: ');
  while( ~isnumeric(d) | d < 0 )
     d = input('No! You must enter a positive number: ');
  end

% Get initial direction
  neg=-1;pos=1;
  dir = input('What direction do wish to iterate? [pos,neg] ');
  while( ~(dir==1 | dir==-1) )
     dir = input('No! You must choose either pos or neg: ');
  end

% Should also get boundaries or outer limits.
% i.e., is there some outer interval not to exceed?
%------------------------------------------------------------------------------
% Initialize more variables
  eqn = evalPileDepthEqn(phi,Gamma,P,L,d);  % get initial value of equation
  oldsign = sign(eqn);               % store sign of equation
  target = 0;                        % stopping value
  iterations = 0;                    % count of iterations to reach root
  inc = 0.01;                       % value to increment $d$ in each step
  refine = 10;
  
%------------------------------------------------------------------------------
% Iterate starting at $d$ and use $dir$ for direction
% Want root of equation, so check $eqn-target$
% Stop iterating when "close" (near eps)
  while ( abs(eqn-target) > eps && iterations <= max_iterations)

     % Need to guess next value
     % increment $d$ by $inc$ (could do this more granular?)
 
     d = d + dir*inc;
     eqn = evalPileDepthEqn(phi,Gamma,P,L,d);
     newsign = sign(eqn);
 
     % If sign changes, root was missed
     if newsign ~= oldsign
	    dir = -1*dir;      % change direciton
        inc = inc/refine;  % refine increment
        oldsign = newsign; % store the new sign of eqn
     end

     % Need boundary condition -- what happens if hit zero?
     % (user might have gone in the wrong direction!)
     % Need to "swap" (change) direction of iteration
     if d <= eps
        disp(['Holy crap! We went too far...hitting reverse...']);
        d = eps; % don't want zero, because that's a solution!
	    eqn = evalPileDepthEqn(phi,Gamma,P,L,d);
        oldsign = sign(eqn);
        newsign = oldsign;
	    dir = pos;
        inc = 0.01; % pick "large" inc to "get back" quicker
     end

     iterations = iterations + 1;
     
  end
  
%=============================================================================%
% Report or repeat                                                            %
%=============================================================================%

 if iterations > max_iterations
     n=0;y=1; % so user can actually enter the letters n and y
     choice = input('taking too long -- try another starting value and search direction? [y,n]: ');
     while( ~(choice==0 | choice==1) )
        choice = input('I asked, "Do you want to try another starting value and search direction? [y,n]:"! ');
     end
     if (choice == y)
         clear
         lhsrhsmethod
         return 
     end
 else
    iterations 
    d
    eqn
 end
 

%------------------------------------------------------------------------------
% Flag user when done
  disp('Finished LHS/RHS method! press any key to continue...')
  clear
  pause
 