%------------------------------------------------------------------------------
% Script for guessing method


% Refresh the workspace
  clear
  clc
  disp(['Starting Guessing Method...']);
  
%------------------------------------------------------------------------------
% get Params
  [Gamma, phi, L, P, eps, max_iterations] = getParams;
  
%------------------------------------------------------------------------------
% Initialize more variables
  target = 0;                        % stopping value
  
% Get user guess
% User must enter a positive number
  d = input('Enter your guess for pile depth [positive]: ');
  while( ~isnumeric(d) | d < 0 )
      d = input('No! You must enter a positive number: ');
  end
 
  eqn = evalPileDepthEqn(phi,Gamma,P,L,d);  % get initial value of equation
  if(abs(eqn-target) > eps)
      fprintf('bad guessing!\n\t equation produces value %0.2f of depth %0.2f\n', eqn, d);
  else 
      fprintf('good guessing!\n\t equation produces value %0.2f of depth %0.2f\n', eqn, d);
  end
   
%------------------------------------------------------------------------------
% Flag user when done
  disp('Finished with guess method! press any key to continue...')
  clear
  pause

