%-----------------------------------------------------------------------------
% exactmethod								      
%-----------------------------------------------------------------------------
% exact methods: builtin root using symbolic toolbox
%-----------------------------------------------------------------------------
clear
clc
disp(['Starting exact method...']);
%-----------------------------------------------------------------------------
% Important variables

% Use symbolic toolbox!
  syms phi g p l x
% x            % pile depth

%------------------------------------------------------------------------------
% get Params
  [g, phi, l, p, eps, max_iterations] = getParams;

% More variables -- these "condense" the appearance of the equation
  ka = tan(pi/4 - phi/2)^2;
  kp = tan(pi/4 + phi/2)^2;
  a4 = 1;
  a3 = 0;
  a2 = -8*p/(g*(kp-ka));
  a1 = -12*p*l/(g*(kp-ka));
  a0 = -(2*p/(g*(kp-ka)))^2;
  
%-----------------------------------------------------------------------------
% Sheet pile equation
% Put in polynomial form
  pd = a4*x^4 + a3*x^3 + a2*x^2 + a1*x + a0;
  
%-----------------------------------------------------------------------------
% Solve polynomial
  s1 = solve(pd);
% s2 = pretty(s1); % to get "pretty" output -- do this in separate script
  solutions = eval(s1);
  
%-----------------------------------------------------------------------------
% Sort out the real, positive roots
% There's probably a better way to vectorize the following,
  disp(['MATLAB found the following potential candidates as solutions:'])
  solutions
  disp(['Throwing out negative and imaginary solutions....'])
  for ii=1:length(solutions)
     if( isreal(solutions(ii)) & solutions(ii)>=0 )
     x = solutions(ii); 
     y = eval(pd);
     fprintf('When depth is %f, the equation is %f.\n',x,y);
     end
  end
%-----------------------------------------------------------------------------
% Continue with program
  disp('Finished with exact method! press any key to continue...');
  clear
  pause
%-----------------------------------------------------------------------------
