function ps = evalPileDepthEqnDeriv(phi,Gamma,P,L,D)
    %PILESLOPE Calculate slope of sheet pile equation
    % PILESLOPE(PHI,GAMMA,P,L,D)
    %   PHI      = soil friction
    %   GAMMA    = unit weight of soil
    %   P        = force from ground
    %   L        = height above ground
    %   D        = depth of pile below ground
    % Returns pd = results of substituting values into the sheetpile equationx

    Ka = tan(pi/4 - phi/2).^2;
    Kp = tan(pi/4 + phi/2).^2;

    a4 = 1;
    a3 = 0;
    a2 = -8*P./(Gamma.*(Kp-Ka));
    a1 = -12*P.*L./(Gamma.*(Kp-Ka));
    a0 = -(2*P./(Gamma.*(Kp-Ka))).^2;

    % pd = pile depth
    % ps = pile slope

    pd =   a4.*D.^4 +   a3.*D.^3 +   a2.*D.^2 +   a1.*D^1 +   a0.*D^0;
    ps = 4*a4.*D.^3 + 3*a3.*D.^2 + 2*a2.*D.^1 + 1*a1.*D^0 + 0*a0.*D^0;
