%------------------------------------------------------------------------------
% Bisection Method
% Approach:
% ....
%------------------------------------------------------------------------------
% Refresh the workspace
% =====================
  clear
  clc
  disp('Starting bisection...');


%------------------------------------------------------------------------------
% get Params
  [Gamma, phi, L, P, eps, max_iterations] = getParams;
  
%------------------------------------------------------------------------------
% Initial guesses
% ===============
% Get initial guess of dL
% User must enter a positive number
  dL = input('Enter your "left" guess for pile depth [positive]: ');
  while( ~isnumeric(dL) | dL < 0 )
     dL = input('No! You must enter a positive number: ');
  end
% Get initial guess of dR
% User must enter a positive number
  dR = input('Enter your "right" guess for pile depth [positive]: ');
  while( ~isnumeric(dR) | dR < dL )
     dR = input('No! You must enter a positive number greater than "left": ');
  end
  
%------------------------------------------------------------------------------
% Initial values
% ==============
% Initial function value
  %eqnM = evalPileDepthEqn(phi,Gamma,P,L,(dL+dR)/2);
  eqnM = 100;       % make sure it enters the loop..
  target = 0;
  iterations = 0;
  
%------------------------------------------------------------------------------
% Iterate for pile depth
% ======================
  % If eqnM is within tolerance or iterations > max-iteration,  stop the iteration....
  while ( abs(eqnM-target) > eps && iterations <= max_iterations )

     % Get left, right and mid values
       dM = (dL + dR)/2.0;
       eqnL  = evalPileDepthEqn(phi,Gamma,P,L,dL);
       eqnR  = evalPileDepthEqn(phi,Gamma,P,L,dR);
       eqnM  = evalPileDepthEqn(phi,Gamma,P,L,dM);

     % Xm is to the left of root
       if eqnM * eqnR <= 0
          dL = dM;
       end

     % probably should use elseif...
     % Xm is to the right of the root
       if eqnM * eqnL < 0
          dR = dM;
       end

     % increment count of iterations
       iterations = iterations + 1;
       
   end
   
%------------------------------------------------------------------------------
% Done iterating
% ==============
% Report output or repeat if too many iterations
  if iterations > max_iterations
     n=0;y=1; % so user can actually enter the letters n and y
     choice = input('taking too long -- try a different interval [y,n]: ');
     while( ~(choice==0 | choice==1) )
        choice = input('I asked, "Do you want to try a different interval? [y,n]:"! ');
     end
     if (choice == y)
         clear
         bisectionmethod
         return 
     end
 else
    iterations 
    dM
    eqnM
 end

%------------------------------------------------------------------------------
% Flag user when done
  disp('Finished bisection method! press any key to continue...')
  clear
  pause
