function test_listbox()
% This function creates a list box, a button, and 
% a text field.  Clicking the button will cause
% the option selected in the list box to be displayed
% in the text field.  Also, double-clicking a line
% on the list box will cause the selected option to
% be displayed immediately.

% First, create a cell array of options
options{1} = 'Option 1';
options{2} = 'Option 2';
options{3} = 'Option 3';
options{4} = 'Option 4';
options{5} = 'Option 5';
options{6} = 'Option 6';
options{7} = 'Option 7';
options{8} = 'Option 8';

h0 = figure('Color',[0.8 0.8 0.8], ...
   'Name','Test List Box', ...
   'NumberTitle','off', ...
   'Position',[300 300 257 136], ...
   'Tag','Fig1');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[0.8 0.8 0.8], ...
   'Position',[45 65 70 17], ...
   'String','Option 1', ...
   'Style','text', ...
   'Tag','Label1');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'Callback','test_listbox_callback list', ...
   'Position',[45 25 70 45], ...
   'String',options, ...
   'Style','listbox', ...
   'Value',1, ...
   'Tag','Listbox1');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'Callback','test_listbox_callback button', ...
   'Position',[45 5 70 15], ...
   'String','Select', ...
   'Style','pushbutton', ...
   'Tag','Button1');
