function fig = HistGUI()
%
%  Function file: HistGUI.m
%
%  Purpose: 
%    To perform calculate and display a histogram of an 
%    an input data set, together with the mean, median,
%    and standard deviation of the data.  The user can
%    independently control the number of bins in the
%    histogram and the color of the bars in the histogram.
%
%  Record of revisions:
%      Date       Programmer          Description of change
%      ====       ==========          =====================
%    06/20/99    S. J. Chapman        Original code 
%
%  Declare data:
%     nbins       -- Number of bins in histogram (global)
%     x           -- Input data values (global)

% Load MAT file
load HistGUI

% Declare global data
global nbins            % Number of bins in histogram
global x                % Input data values

% Initialize global data
nbins = 11;
x = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Select the figure background color
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure_color = [0.6 1.0 1.0];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define figure.  This figure was originally created 
% using "guide", and then modified manually.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h0 = figure('Color',figure_color, ...
   'Colormap',mat0, ...
   'FileName','HistGUI.m', ...
   'MenuBar','none', ...
   'Name','Histogram GUI', ...
   'NumberTitle','off', ...
   'PaperPosition',[18 180 576 512], ...
   'PaperType','A4', ...
   'PaperUnits','points', ...
   'Position',[319 175 672 524], ...
   'Tag','Fig1', ...
   'ToolBar','none');
   
% Create title for figure
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',figure_color, ...
   'FontName','MS Sans serif', ...
   'FontSize',14, ...
   'FontWeight','bold', ...
   'ListboxTop',0, ...
   'Position',[126.6 293 162 17.4], ...
   'String','Histogram', ...
   'Style','text', ...
   'Tag','TitleString');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create axes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h1 = axes('Parent',h0, ...
   'Units','pixels', ...
   'CameraUpVector',[0 1 0], ...
   'Color',[1 1 1], ...
   'ColorOrder',mat1, ...
   'Position',[71 118 553 346], ...
   'Tag','Axes1', ...
   'XColor',[0 0 0], ...
   'YColor',[0 0 0], ...
   'ZColor',[0 0 0]);
h2 = text('Parent',h1, ...
   'Color',[0 0 0], ...
   'HandleVisibility','off', ...
   'HorizontalAlignment','center', ...
   'Position',[0.4981884057971015 -0.0811594202898549 9.160254037844386], ...
   'Tag','Axes1Text4', ...
   'VerticalAlignment','cap');
set(get(h2,'Parent'),'XLabel',h2);
h2 = text('Parent',h1, ...
   'Color',[0 0 0], ...
   'HandleVisibility','off', ...
   'HorizontalAlignment','center', ...
   'Position',[-0.06340579710144929 0.4956521739130435 9.160254037844386], ...
   'Rotation',90, ...
   'Tag','Axes1Text3', ...
   'VerticalAlignment','baseline');
set(get(h2,'Parent'),'YLabel',h2);
h2 = text('Parent',h1, ...
   'Color',[0 0 0], ...
   'HandleVisibility','off', ...
   'HorizontalAlignment','right', ...
   'Position',[-0.1286231884057971 1.173913043478261 9.160254037844386], ...
   'Tag','Axes1Text2', ...
   'Visible','off');
set(get(h2,'Parent'),'ZLabel',h2);
h2 = text('Parent',h1, ...
   'Color',[0 0 0], ...
   'HandleVisibility','off', ...
   'HorizontalAlignment','center', ...
   'Position',mat2, ...
   'Tag','Axes1Text1', ...
   'VerticalAlignment','bottom');
set(get(h2,'Parent'),'Title',h2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create the GUI elements.  This includes three 
% text fields to display labels, three text fields
% to display the statistics, and a 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Label for mean 
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
   'Units','points', ...
   'ListboxTop',0, ...
   'Position',[42.8 28 44.1 13.5], ...
   'String','Mean', ...
   'Style','text', ...
   'Tag','StaticText1');

% Value of mean
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'ListboxTop',0, ...
   'Position',[92.5 28 50.9 15.5], ...
   'Style','text', ...
   'ToolTip','Arithmetic mean of data set', ...
   'Tag','MeanData');

% Label for median
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
   'Units','points', ...
   'ListboxTop',0, ...
   'Position',[156.4 28 50.9 13.5], ...
   'String','Median', ...
   'Style','text', ...
   'Tag','StaticText1');

% Value of median
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'ListboxTop',0, ...
   'Position',[206.1 28 50.9 15.5], ...
   'Style','text', ...
   'ToolTip','Median value of data set', ...
   'Tag','MedianData');

% Label for standard deviation
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
   'Units','points', ...
   'ListboxTop',0, ...
   'Position',[272.5 28 50.9 13.5], ...
   'String','Std Dev', ...
   'Style','text', ...
   'Tag','StaticText1');

% Value for standard deviation
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'ListboxTop',0, ...
   'Position',[320.3 28 50.9 15.5], ...
   'Style','text', ...
   'ToolTip','Standard deviation of data set', ...
   'Tag','StdDevData');

% Label for number of bins
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
   'Units','points', ...
   'ListboxTop',0, ...
   'Position',[156.4 8 50.9 13.5], ...
   'String','No. of bins', ...
   'Style','text', ...
   'ToolTip','Number of bins in histogram', ...
   'Tag','StaticText1');

% Value for number of bins
h1 = uicontrol('Parent',h0, ...
   'Callback','HistGUI_callback nbins', ...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'ListboxTop',0, ...
   'Position',[206.1 8 50.9 15.5], ...
   'Style','edit', ...
   'String',int2str(nbins), ...
   'ToolTip','Number of bins in histogram', ...
   'Tag','NBins');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create Menu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h1 = uimenu('Parent',h0, ...
   'Label','&File', ...
   'Tag','File');

h2 = uimenu('Parent',h1, ...
   'Callback','HistGUI_callback open', ...
   'Separator','off', ...
   'Label','&Open', ...
   'Tag','Open');

h2 = uimenu('Parent',h1, ...
   'Callback','HistGUI_callback exit', ...
   'Separator','on', ...
   'Label','E&xit', ...
   'Tag','Exit');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Return figure number if necessary
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargout > 0
   fig = h0; 
end
