/** An instance represents a CMYK value */
public class CMYK {
    /** Color cyan. 0  c  1. */
    public double c;
    
    /** Color magenta. 0  m  1. */
    public double m;
    
    /** Color yellow. 0  y  1. */
    public double y;
    
    /** Color black. 0  c  1. */
    public double k;
    
    /** Constructor: the CMYK value (c, m, y, k).
        Precondition: All components c, m, y, and k are 
         0 and  1.*/
    public CMYK(double c, double m, double y, double k) {
        this.c= c;
        this.m= m;
        this.y= y;
        this.k= k;
    }
    
    /** = String s truncated (if necessary) to its first 5 characters. */
    public static String truncate(String s) {
        if (s.length() <= 5)
            return s;
        return s.substring(0,5);
    }
    
    /** = string representation of this instance */
    public String toString() {
        return "(" + truncate("" + c) + ", " + 
                     truncate("" + m) + ", " +
                     truncate("" + y) + ", " +
                     truncate("" + k) + ")";
    }
}
