import junit.framework.TestCase;
import java.awt.*;
/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class A4Tester extends TestCase {
    
    /** Test methods complement, truncateTo5, toString(Color rgb),
        toString(HSV hsv), and toString(CMYK cmyk)
     */
    public void testStrings() {
        assertEquals(new Color(5, 255, 255-71), A4Methods.complementRGB(new Color(250, 0, 71)));
        assertEquals("",  A4Methods.truncateTo5(""));
        assertEquals("A",  A4Methods.truncateTo5("A"));
        assertEquals("ABCDE",  A4Methods.truncateTo5("ABCDE"));
        assertEquals("ABCDE",  A4Methods.truncateTo5("ABCDEF"));
        assertEquals("ABCDE",  A4Methods.truncateTo5("ABCDEFGHI"));
        
        assertEquals("[30, 240, 230]",  A4Methods.toString(new Color(30, 240, 230)));
       
    }
    
    /** Test the translation functions */
    public void testTranslations() {
        Color rgb= new Color(255, 255, 255);
        CMYK cmyk= A4Methods.RGBtoCMYK(rgb);
        assertEquals(0.0, cmyk.c);
        assertEquals(0.0, cmyk.m);
        assertEquals(0.0, cmyk.y);
        assertEquals(0.0, cmyk.k);
        
        rgb= new Color(0, 0, 0);
        cmyk= A4Methods.RGBtoCMYK(rgb);
        assertEquals(0.0, cmyk.c);
        assertEquals(0.0, cmyk.m);
        assertEquals(0.0, cmyk.y);
        assertEquals(1.0, cmyk.k);
        
        rgb= new Color(217, 43, 164);
        cmyk= A4Methods.RGBtoCMYK(rgb);
        assertEquals("0.0", A4Methods.truncateTo5("" + cmyk.c));
        assertEquals("0.801", A4Methods.truncateTo5("" + cmyk.m));
        assertEquals("0.244", A4Methods.truncateTo5("" + cmyk.y));
        assertEquals("0.149", A4Methods.truncateTo5("" + cmyk.k));
    


    }
    
   
}
