/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import junit.framework.TestCase;

public class A4Tester
extends TestCase {
    public void testStrings() {
        A4Tester.assertEquals((Object)new Color(5, 255, 184), (Object)A4Methods.complementRGB(new Color(250, 0, 71)));
        A4Tester.assertEquals((String)"", (String)A4Methods.truncateTo5(""));
        A4Tester.assertEquals((String)"A", (String)A4Methods.truncateTo5("A"));
        A4Tester.assertEquals((String)"ABCDE", (String)A4Methods.truncateTo5("ABCDE"));
        A4Tester.assertEquals((String)"ABCDE", (String)A4Methods.truncateTo5("ABCDEF"));
        A4Tester.assertEquals((String)"ABCDE", (String)A4Methods.truncateTo5("ABCDEFGHI"));
        A4Tester.assertEquals((String)"[30, 240, 230]", (String)A4Methods.toString(new Color(30, 240, 230)));
        A4Tester.assertEquals((String)"[1.0, 0.5, 0.3]", (String)A4Methods.toString(new HSV(1.0, 0.5, 0.3)));
        A4Tester.assertEquals((String)"[1.0, 0.546, 0.3]", (String)A4Methods.toString(new HSV(1.0, 0.54623, 0.3)));
        A4Tester.assertEquals((String)"[1.0, 0.5, 0.3, 0.0]", (String)A4Methods.toString(new CMYK(1.0, 0.5, 0.3, 0.0)));
    }

    public void testTranslations() {
        Color rgb = new Color(255, 255, 255);
        CMYK cmyk = A4Methods.RGBtoCMYK(rgb);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.c);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.m);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.y);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.k);
        rgb = new Color(0, 0, 0);
        cmyk = A4Methods.RGBtoCMYK(rgb);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.c);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.m);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.y);
        A4Tester.assertEquals((Object)1.0, (Object)cmyk.k);
        rgb = new Color(217, 43, 164);
        cmyk = A4Methods.RGBtoCMYK(rgb);
        A4Tester.assertEquals((String)"0.0", (String)A4Methods.truncateTo5("" + cmyk.c));
        A4Tester.assertEquals((String)"0.801", (String)A4Methods.truncateTo5("" + cmyk.m));
        A4Tester.assertEquals((String)"0.244", (String)A4Methods.truncateTo5("" + cmyk.y));
        A4Tester.assertEquals((String)"0.149", (String)A4Methods.truncateTo5("" + cmyk.k));
        rgb = new Color(0, 0, 0);
        HSV hsv1 = A4Methods.RGBtoHSV(rgb);
        A4Tester.assertEquals((String)"0.0", (String)A4Methods.truncateTo5("" + hsv1.h));
        A4Tester.assertEquals((String)"0.0", (String)A4Methods.truncateTo5("" + hsv1.v));
        CMYK cmyk2 = new CMYK(1.0, 1.0, 1.0, 1.0);
        rgb = A4Methods.CMYKtoRGB(cmyk2);
        A4Tester.assertEquals((int)0, (int)rgb.getRed());
        A4Tester.assertEquals((int)0, (int)rgb.getGreen());
        A4Tester.assertEquals((int)0, (int)rgb.getBlue());
        CMYK cmyk3 = new CMYK(0.35, 0.38, 0.65, 0.0);
        rgb = A4Methods.CMYKtoRGB(cmyk3);
        A4Tester.assertEquals((int)166, (int)rgb.getRed());
        A4Tester.assertEquals((int)158, (int)rgb.getGreen());
        A4Tester.assertEquals((int)89, (int)rgb.getBlue());
        Color rgb4 = new Color(201, 201, 201);
        HSV hsv5 = A4Methods.RGBtoHSV(rgb4);
        A4Tester.assertEquals((String)"0.0", (String)A4Methods.truncateTo5("" + hsv5.h));
        A4Tester.assertEquals((String)"0.0", (String)A4Methods.truncateTo5("" + hsv5.s));
        A4Tester.assertEquals((String)"0.788", (String)A4Methods.truncateTo5("" + hsv5.v));
        rgb4 = new Color(255, 201, 121);
        HSV hsv6 = A4Methods.RGBtoHSV(rgb4);
        A4Tester.assertEquals((String)"35.82", (String)A4Methods.truncateTo5("" + hsv6.h));
        A4Tester.assertEquals((String)"0.525", (String)A4Methods.truncateTo5("" + hsv6.s));
        A4Tester.assertEquals((String)"1.0", (String)A4Methods.truncateTo5("" + hsv6.v));
        rgb4 = new Color(255, 25, 121);
        HSV hsv7 = A4Methods.RGBtoHSV(rgb4);
        A4Tester.assertEquals((String)"334.9", (String)A4Methods.truncateTo5("" + hsv7.h));
        A4Tester.assertEquals((String)"0.901", (String)A4Methods.truncateTo5("" + hsv7.s));
        A4Tester.assertEquals((String)"1.0", (String)A4Methods.truncateTo5("" + hsv7.v));
        rgb4 = new Color(146, 255, 146);
        HSV hsv8 = A4Methods.RGBtoHSV(rgb4);
        A4Tester.assertEquals((String)"120.0", (String)A4Methods.truncateTo5("" + hsv8.h));
        A4Tester.assertEquals((String)"0.427", (String)A4Methods.truncateTo5("" + hsv8.s));
        A4Tester.assertEquals((String)"1.0", (String)A4Methods.truncateTo5("" + hsv8.v));
        rgb4 = new Color(146, 20, 214);
        HSV hsv9 = A4Methods.RGBtoHSV(rgb4);
        A4Tester.assertEquals((String)"278.9", (String)A4Methods.truncateTo5("" + hsv9.h));
        A4Tester.assertEquals((String)"0.906", (String)A4Methods.truncateTo5("" + hsv9.s));
        A4Tester.assertEquals((String)"0.839", (String)A4Methods.truncateTo5("" + hsv9.v));
        HSV hsv3 = new HSV(40.0, 0.72, 0.78);
        rgb = A4Methods.HSVtoRGB(hsv3);
        A4Tester.assertEquals((int)199, (int)rgb.getRed());
        A4Tester.assertEquals((int)151, (int)rgb.getGreen());
        A4Tester.assertEquals((int)56, (int)rgb.getBlue());
        hsv3 = new HSV(70.9, 0.718, 0.78);
        rgb = A4Methods.HSVtoRGB(hsv3);
        A4Tester.assertEquals((int)173, (int)rgb.getRed());
        A4Tester.assertEquals((int)199, (int)rgb.getGreen());
        A4Tester.assertEquals((int)56, (int)rgb.getBlue());
        hsv3 = new HSV(120.0, 0.42, 1.0);
        rgb = A4Methods.HSVtoRGB(hsv3);
        A4Tester.assertEquals((int)148, (int)rgb.getRed());
        A4Tester.assertEquals((int)255, (int)rgb.getGreen());
        A4Tester.assertEquals((int)148, (int)rgb.getBlue());
        hsv3 = new HSV(195.5, 0.42, 0.89);
        rgb = A4Methods.HSVtoRGB(hsv3);
        A4Tester.assertEquals((int)132, (int)rgb.getRed());
        A4Tester.assertEquals((int)202, (int)rgb.getGreen());
        A4Tester.assertEquals((int)227, (int)rgb.getBlue());
        hsv3 = new HSV(262.2, 0.9, 0.36);
        rgb = A4Methods.HSVtoRGB(hsv3);
        A4Tester.assertEquals((int)40, (int)rgb.getRed());
        A4Tester.assertEquals((int)9, (int)rgb.getGreen());
        A4Tester.assertEquals((int)92, (int)rgb.getBlue());
        hsv3 = new HSV(339.9, 0.9, 1.0);
        rgb = A4Methods.HSVtoRGB(hsv3);
        A4Tester.assertEquals((int)255, (int)rgb.getRed());
        A4Tester.assertEquals((int)25, (int)rgb.getGreen());
        A4Tester.assertEquals((int)102, (int)rgb.getBlue());
    }
}

