/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class A4Methods {
    public static Color complementRGB(Color rgb) {
        return new Color(255 - rgb.getRed(), 255 - rgb.getGreen(), 255 - rgb.getBlue());
    }

    public static String truncateTo5(String s) {
        if (s.length() <= 5) {
            return s;
        }
        return s.substring(0, 5);
    }

    public static String toString(Color rgb) {
        return "[" + rgb.getRed() + ", " + rgb.getGreen() + ", " + rgb.getBlue() + "]";
    }

    public static String toString(CMYK cmyk) {
        return "[" + A4Methods.truncateTo5(cmyk.c + "") + ", " + A4Methods.truncateTo5(cmyk.m + "") + ", " + A4Methods.truncateTo5(cmyk.y + "") + ", " + A4Methods.truncateTo5(cmyk.k + "") + "]";
    }

    public static String toString(HSV hsv) {
        return "[" + A4Methods.truncateTo5(hsv.h + "") + ", " + A4Methods.truncateTo5(hsv.s + "") + ", " + A4Methods.truncateTo5(hsv.v + "") + "]";
    }

    public static CMYK RGBtoCMYK(Color rgb) {
        double R = (double)rgb.getRed() / 255.0;
        double G = (double)rgb.getGreen() / 255.0;
        double B = (double)rgb.getBlue() / 255.0;
        double Cprime = 1.0 - R;
        double Mprime = 1.0 - G;
        double Yprime = 1.0 - B;
        if (Cprime >= 1.0 && Mprime >= 1.0 && Yprime >= 1.0) {
            return new CMYK(0.0, 0.0, 0.0, 1.0);
        }
        double K = Math.min(Math.min(Cprime, Mprime), Yprime);
        double C = (Cprime - K) / (1.0 - K);
        double M = (Mprime - K) / (1.0 - K);
        double Y = (Yprime - K) / (1.0 - K);
        return new CMYK(C, M, Y, K);
    }

    public static Color CMYKtoRGB(CMYK cmyk) {
        double C = cmyk.c;
        double M = cmyk.m;
        double Y = cmyk.y;
        double K = cmyk.k;
        double oneMinusK = 1.0 - K;
        double R = (1.0 - C) * oneMinusK;
        double G = (1.0 - M) * oneMinusK;
        double B = (1.0 - Y) * oneMinusK;
        return new Color((int)Math.round(R * 255.0), (int)Math.round(G * 255.0), (int)Math.round(B * 255.0));
    }

    public static HSV RGBtoHSV(Color rgb) {
        double MIN;
        double B;
        double G;
        double R = (double)rgb.getRed() / 255.0;
        double MAX = Math.max(R, Math.max(G = (double)rgb.getGreen() / 255.0, B = (double)rgb.getBlue() / 255.0));
        double H = MAX == (MIN = Math.min(R, Math.min(G, B))) ? 0.0 : (MAX == R && G >= B ? 60.0 * (G - B) / (MAX - MIN) + 0.0 : (MAX == R && G < B ? 60.0 * (G - B) / (MAX - MIN) + 360.0 : (MAX == G ? 60.0 * (B - R) / (MAX - MIN) + 120.0 : 60.0 * (R - G) / (MAX - MIN) + 240.0)));
        double S = MAX == 0.0 ? 0.0 : 1.0 - MIN / MAX;
        double V = MAX;
        return new HSV(H, S, V);
    }

    public static Color HSVtoRGB(HSV HSV2) {
        double B;
        double G;
        double R;
        double H = HSV2.h;
        double S = HSV2.s;
        double V = HSV2.v;
        int Hi = (int)Math.floor(H / 60.0) % 6;
        double f = H / 60.0 - (double)Hi;
        double p = V * (1.0 - S);
        double q = V * (1.0 - f * S);
        double t = V * (1.0 - (1.0 - f) * S);
        if (Hi == 0) {
            R = V;
            G = t;
            B = p;
        } else if (Hi == 1) {
            R = q;
            G = V;
            B = p;
        } else if (Hi == 2) {
            R = p;
            G = V;
            B = t;
        } else if (Hi == 3) {
            R = p;
            G = q;
            B = V;
        } else if (Hi == 4) {
            R = t;
            G = p;
            B = V;
        } else {
            R = V;
            G = p;
            B = q;
        }
        return new Color((int)Math.round(R * 255.0), (int)Math.round(G * 255.0), (int)Math.round(B * 255.0));
    }
}

