import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.imageio.*;
import java.net.*;
import java.io.*;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import javax.imageio.*;
import java.io.*;




/** An instance contains 
 (1) an original image map (class ImageMap) and
 (2) a possibly altered (by methods in this instance) version of the original image map.
 */
public class ImageMaintainer {
    
    /** DM provides methods for extracting components of an rgb pixel. */
    public static final DirectColorModel DM= (DirectColorModel) ColorModel.getRGBdefault();
    
    /** The following four constants of this class indicate a color.*/
    /** Color gray */
    public static final int GRAY= 0;
    
    /** Color red */
    public static final int RED= 1;
    
    /** Color green */
    public static final int GREEN= 2;
    
    /** Color blue */
    public static final int BLUE= 3;
    
    private ImageMap originalMap; // The original image map, for restoration purposes
    private ImageMap currentMap;  // The altered map
    
    /** Constructor: an instance for im.
        Precondition: im != null. */
    public ImageMaintainer(ImageMap im) {
        originalMap= im;
        currentMap= originalMap.copy();
    }
    
    /** = the current image map. */
    public ImageMap getCurrentMap() {
        return currentMap;
    }
    
    /** = the original image map */
    public ImageMap getOriginalMap() {
        return originalMap;
    }
    
    /** Invert the image, replacing each element with its color complement. */
    public void invert() {
        
        int len= currentMap.getRows() * currentMap.getCols();
        // invert all pixels (leave alpha/transparency value alone)
        for (int p= 0; p < len; p= p+1) {
                int rgb= currentMap.getPixel(p);
                int red= 255 - DM.getRed(rgb);
                int blue= 255 - DM.getBlue(rgb);
                int green= 255 - DM.getGreen(rgb);
                int alpha= DM.getAlpha(rgb);
                currentMap.setPixel(p,
                              (alpha << 24) | (red << 16) | (green << 8) | blue);
        }
    }
    
    /** Transpose the image that is in variable currentMap.  */
    public void transpose() {
        // WRITE THE BODY OF THE PROCEDURE AND THEN REMOVE THIS COMMENT.
        // Follow this plan: 
        // (1) Create a new ImageMap b (say), storing in it a copy of currentMap;
        // (2) In b, swap the numbers of rows and columns (i.e. the two fields);
        // (2) Store the transpose of currentMap.map in b.map; and
        // (3) assign b to currentMap.
    }
    
    /** Reflect the image in currentMap) around the horizontal middle. */
    public void hreflect() {
        int rows= currentMap.getRows();
        int cols= currentMap.getCols();
        int h= 0;
        int k= rows-1;
        //invariant: rows 0..h-1 and k+1.. have been inverted
        while (h < k) {
            // Swap row h with row k
            for (int c= 0; c != cols; c= c+1) {
                currentMap.swapPixels(h,c,k,c);
            }
            
            h= h+1; k= k-1;
        }
    }
    
    /** Reflect the image in currentMap) around the vertical middle. */
    public void vreflect() {
        // WRITE THE BODY OF THIS PROCEDURE AND THEN REMOVE THIS COMMENT!!!
    }
    
    /* Filter the image to be only a single color, which is given by
     parameter color.<br><br>
     
     Precondition: color is one of the four color constants GRAY,
     RED, GREEN, BLUE of this class.<br><br>
     
     Gray is achieved by making all three color components equal to the
     average of the red, green, and blue components. For the other three
     colors, make the non-used components 0. The alpha component should
     not be changed.
     */
    public void filter(int color) {
        // WRITE THE BODY OF THIS PROCEDURE AND THEN REMOVE THIS COMMENT!!
    }
    
    /** Hide message m in this image, using the ascii representation of each character in m.
        Return true if this is possible and false if not.
        If m has more than 999 characters or the picture doesn't have at least 2*m + 2 pixels,
        no message is stored (and false is returned).
     */
    public boolean hide(String m) {
        // YOU DO NOT HAVE TO WRITE THIS FUNCTION
        return false;
    }
    
    /** Extract and return the message hidden in this image.
        Return null if no image detected. */
    public String reveal() {
        // YOU DO NOT HAVE TO WRITE THIS FUNCTION
        
        return null;
    }
    
    /** Restore the original image in the current one */
    public void restore() {
        currentMap= originalMap.copy();
    }
    
}
