/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import koala.dynamicjava.gui.MessageHandler;
import koala.dynamicjava.gui.resource.ResourceManager;

public class StatusBar
extends JPanel
implements MessageHandler {
    protected JLabel line;
    protected JLabel message;
    protected ResourceManager resources;
    protected String mainMessage;
    protected String lineSymbol;

    public StatusBar(ResourceManager rm) {
        super(new BorderLayout(0, 0));
        this.resources = rm;
        this.lineSymbol = rm.getString("Status.lineSymbol");
        this.line = new JLabel(this.lineSymbol + 1);
        this.line.setBorder(BorderFactory.createBevelBorder(1));
        this.line.setPreferredSize(new Dimension(70, 18));
        this.add("West", this.line);
        JPanel p = new JPanel(new BorderLayout(0, 0));
        this.message = new JLabel();
        this.message.setBorder(BorderFactory.createBevelBorder(1));
        p.add(this.message);
        this.add(p);
    }

    public void setLine(int n) {
        this.line.setText(this.lineSymbol + n);
    }

    public void setMessage(String s) {
        this.message.setText(this.resources.getString(s));
        new DisplayThread().start();
    }

    public void setMessage(String s, String s2) {
        this.message.setText(this.resources.getString(s) + " " + s2);
        new DisplayThread().start();
    }

    public void setMainMessage(String s) {
        this.mainMessage = this.resources.getString(s);
        this.message.setText(this.mainMessage);
    }

    public void setMainMessage(String s, String s2) {
        this.mainMessage = this.resources.getString(s) + " " + s2;
        this.message.setText(this.mainMessage);
    }

    protected class DisplayThread
    extends Thread {
        public DisplayThread() {
            this.setPriority(1);
        }

        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            StatusBar.this.message.setText(StatusBar.this.mainMessage);
        }
    }
}

