/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.UnexpectedException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightManager {
    private Vector<Stack<HighlightInfo>> _highlights;
    private JTextComponent _component;

    public HighlightManager(JTextComponent jtc) {
        this._component = jtc;
        this._highlights = new Vector();
    }

    public String toString() {
        return new StringBuffer().append("HighLightManager(").append(this._highlights).append(")").toString();
    }

    public int size() {
        return this._highlights.size();
    }

    public HighlightInfo addHighlight(int startOffset, int endOffset, Highlighter.HighlightPainter p) {
        HighlightInfo newLite = new HighlightInfo(startOffset, endOffset, p);
        Stack<HighlightInfo> lineStack = this._getStackAt(newLite);
        if (lineStack != null) {
            int searchResult = lineStack.search(newLite);
            if (searchResult == 1) {
                return lineStack.peek();
            }
            if (searchResult > 1) {
                lineStack.remove(newLite);
            }
        } else {
            lineStack = new Stack();
            this._highlights.add(lineStack);
        }
        try {
            Object highlightTag = this._component.getHighlighter().addHighlight(startOffset, endOffset, p);
            newLite.setHighlightTag(highlightTag);
            lineStack.push(newLite);
            return newLite;
        }
        catch (BadLocationException ble) {
            if (lineStack.isEmpty()) {
                this._highlights.remove(lineStack);
            }
            throw new UnexpectedException(ble);
        }
    }

    private Stack<HighlightInfo> _getStackAt(HighlightInfo h) {
        for (Stack<HighlightInfo> stack : this._highlights) {
            if (!((HighlightInfo)stack.get(0)).matchesRegion(h)) continue;
            return stack;
        }
        return null;
    }

    public void removeHighlight(int startOffset, int endOffset, Highlighter.HighlightPainter p) {
        HighlightInfo newLite = new HighlightInfo(startOffset, endOffset, p);
        this.removeHighlight(newLite);
    }

    public void removeHighlight(HighlightInfo newLite) {
        Stack<HighlightInfo> lineStack = this._getStackAt(newLite);
        if (lineStack == null) {
            return;
        }
        int searchResult = lineStack.search(newLite);
        if (searchResult == 1) {
            HighlightInfo liteToRemove = lineStack.pop();
            this._component.getHighlighter().removeHighlight(liteToRemove.getHighlightTag());
        } else if (searchResult > 1) {
            lineStack.remove(newLite);
            this._component.getHighlighter().removeHighlight(newLite.getHighlightTag());
        }
        if (lineStack.isEmpty()) {
            this._highlights.remove(lineStack);
        }
    }

    static JTextComponent access$000(HighlightManager x0) {
        return x0._component;
    }

    public class HighlightInfo {
        private Object _highlightTag = null;
        private Position _startPos;
        private Position _endPos;
        private Highlighter.HighlightPainter _painter;

        public HighlightInfo(int from, int to, Highlighter.HighlightPainter p) {
            try {
                this._startPos = HighlightManager.access$000(HighlightManager.this).getDocument().createPosition(from);
                this._endPos = HighlightManager.access$000(HighlightManager.this).getDocument().createPosition(to);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            this._painter = p;
        }

        public void setHighlightTag(Object highlightTag) {
            this._highlightTag = highlightTag;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof HighlightInfo) {
                HighlightInfo obj = (HighlightInfo)o;
                boolean result = this.getStartOffset() == obj.getStartOffset() && this.getEndOffset() == obj.getEndOffset() && this.getPainter() == obj.getPainter();
                return result;
            }
            return false;
        }

        public int hashCode() {
            return this.getPainter().hashCode() ^ this.getStartOffset() ^ this.getEndOffset();
        }

        public void remove() {
            HighlightManager.this.removeHighlight(this);
        }

        public Object getHighlightTag() {
            return this._highlightTag;
        }

        public Highlighter.HighlightPainter getPainter() {
            return this._painter;
        }

        public int getStartOffset() {
            return this._startPos.getOffset();
        }

        public int getEndOffset() {
            return this._endPos.getOffset();
        }

        public boolean matchesRegion(HighlightInfo h) {
            return this.getStartOffset() == h.getStartOffset() && this.getEndOffset() == h.getEndOffset();
        }

        public void refresh(Highlighter.HighlightPainter p) {
            this.remove();
            HighlightInfo newHighlight = HighlightManager.this.addHighlight(this.getStartOffset(), this.getEndOffset(), p);
            this._painter = p;
            this._highlightTag = newHighlight.getHighlightTag();
        }
    }
}

