/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.sexp;

import edu.rice.cs.util.sexp.LexingException;
import edu.rice.cs.util.sexp.Tokens;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;

class Lexer
extends StreamTokenizer {
    public HashMap<String, Tokens.SExpToken> wordTable = new HashMap();
    private Tokens.SExpToken buffer;

    public Lexer(File file) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(file)));
    }

    public Lexer(Reader reader) {
        super(new BufferedReader(reader));
        this.initLexer();
    }

    private void initLexer() {
        this.resetSyntax();
        this.parseNumbers();
        this.slashSlashComments(true);
        this.wordChars(33, 39);
        this.wordChars(42, 126);
        this.quoteChar(34);
        this.ordinaryChars(40, 41);
        this.whitespaceChars(0, 32);
        this.commentChar(59);
        this.initWordTable();
        this.buffer = null;
    }

    public void flush() throws IOException {
        this.eolIsSignificant(true);
        while (this.nextToken() != 10) {
        }
        this.eolIsSignificant(false);
    }

    private int getToken() {
        try {
            int tokenType = this.nextToken();
            return tokenType;
        }
        catch (IOException e) {
            throw new LexingException("Unable to read the data from the given input");
        }
    }

    public Tokens.SExpToken peek() {
        if (this.buffer == null) {
            this.buffer = this.readToken();
        }
        return this.buffer;
    }

    public Tokens.SExpToken readToken() {
        if (this.buffer != null) {
            Tokens.SExpToken token = this.buffer;
            this.buffer = null;
            return token;
        }
        int tokenType = this.getToken();
        switch (tokenType) {
            case -2: {
                return new Tokens.NumberToken(this.nval);
            }
            case -3: {
                String s = this.sval.toLowerCase();
                Tokens.SExpToken regToken = this.wordTable.get(s);
                if (regToken == null) {
                    return new Tokens.WordToken(this.sval);
                }
                return regToken;
            }
            case -1: {
                return null;
            }
            case 40: {
                return Tokens.LeftParenToken.ONLY;
            }
            case 41: {
                return Tokens.RightParenToken.ONLY;
            }
            case 34: {
                return new Tokens.QuotedTextToken(this.sval);
            }
            case 92: {
                return Tokens.BackSlashToken.ONLY;
            }
        }
        return new Tokens.WordToken("" + (char)tokenType);
    }

    private void initWordTable() {
        this.wordTable.put("true", Tokens.BooleanToken.TRUE);
        this.wordTable.put("false", Tokens.BooleanToken.FALSE);
    }
}

