/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.swing.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Locale;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecJVM {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);

    private ExecJVM() {
    }

    public static Process runJVM(String mainClass, String[] classParams, String[] classPath, String[] jvmParams, File workDir) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < classPath.length; ++i) {
            if (i != 0) {
                buf.append(PATH_SEPARATOR);
            }
            buf.append(classPath[i]);
        }
        return ExecJVM.runJVM(mainClass, classParams, buf.toString(), jvmParams, workDir);
    }

    public static Process runJVM(String mainClass, String[] classParams, String classPath, String[] jvmParams, File workDir) throws IOException {
        LinkedList<String> args = new LinkedList<String>();
        args.add("-classpath");
        args.add(FileOps.convertToAbsolutePathEntries(classPath));
        ExecJVM._addArray(args, jvmParams);
        String[] jvmWithCP = args.toArray(new String[args.size()]);
        return ExecJVM._runJVM(mainClass, classParams, jvmWithCP, workDir);
    }

    public static Process runJVMPropagateClassPath(String mainClass, String[] classParams, String[] jvmParams, File workDir) throws IOException {
        String cp = System.getProperty("java.class.path");
        return ExecJVM.runJVM(mainClass, classParams, cp, jvmParams, workDir);
    }

    public static Process runJVMPropagateClassPath(String mainClass, String[] classParams, File workDir) throws IOException {
        return ExecJVM.runJVMPropagateClassPath(mainClass, classParams, new String[0], workDir);
    }

    private static Process _runJVM(String mainClass, String[] classParams, String[] jvmParams, File workDir) throws IOException {
        Process p;
        LinkedList<String> args = new LinkedList<String>();
        args.add(ExecJVM._getExecutable());
        ExecJVM._addArray(args, jvmParams);
        args.add(mainClass);
        ExecJVM._addArray(args, classParams);
        String[] argArray = args.toArray(new String[args.size()]);
        if (workDir != null && workDir != FileOption.NULL_FILE) {
            if (workDir.exists()) {
                p = Runtime.getRuntime().exec(argArray, null, workDir);
            } else {
                Utilities.showMessageBox(new StringBuffer().append("Working directory does not exist:\n").append(workDir).append("\nThe setting will be ignored. Press OK to continue.").toString(), "Configuration Error");
                p = Runtime.getRuntime().exec(argArray);
            }
        } else {
            p = Runtime.getRuntime().exec(argArray);
        }
        return p;
    }

    public static void ventBuffers(Process theProc, LinkedList<String> outLines, LinkedList<String> errLines) throws IOException {
        String output;
        BufferedReader outBuf = new BufferedReader(new InputStreamReader(theProc.getInputStream()));
        BufferedReader errBuf = new BufferedReader(new InputStreamReader(theProc.getErrorStream()));
        if (outBuf.ready()) {
            output = outBuf.readLine();
            while (output != null) {
                outLines.add(output);
                if (outBuf.ready()) {
                    output = outBuf.readLine();
                    continue;
                }
                output = null;
            }
        }
        outBuf.close();
        if (errBuf.ready()) {
            output = errBuf.readLine();
            while (output != null) {
                errLines.add(output);
                if (errBuf.ready()) {
                    output = errBuf.readLine();
                    continue;
                }
                output = null;
            }
        }
        errBuf.close();
    }

    public static void printOutput(Process theProc, String msg, String sourceName) throws IOException {
        System.out.println(msg);
        LinkedList<String> outLines = new LinkedList<String>();
        LinkedList<String> errLines = new LinkedList<String>();
        ExecJVM.ventBuffers(theProc, outLines, errLines);
        for (String output : outLines) {
            System.out.println(new StringBuffer().append("    [").append(sourceName).append(" stdout]: ").append(output).toString());
        }
        for (String output : errLines) {
            System.out.println(new StringBuffer().append("    [").append(sourceName).append(" stderr]: ").append(output).toString());
        }
    }

    private static void _addArray(LinkedList<String> list, String[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
        }
    }

    private static boolean _isDOS() {
        return PATH_SEPARATOR.equals(";");
    }

    private static boolean _isNetware() {
        return OS_NAME.indexOf("netware") != -1;
    }

    private static String _getExecutable() {
        if (ExecJVM._isNetware()) {
            return "java";
        }
        String java_home = new StringBuffer().append(System.getProperty("java.home")).append("/").toString();
        String[] candidates = new String[]{new StringBuffer().append(java_home).append("../bin/java").toString(), new StringBuffer().append(java_home).append("bin/java").toString(), new StringBuffer().append(java_home).append("java").toString()};
        for (int i = 0; i < candidates.length; ++i) {
            File executable;
            String current = candidates[i];
            if (ExecJVM._isDOS()) {
                executable = new File(new StringBuffer().append(current).append("w.exe").toString());
                if (!executable.exists()) {
                    executable = new File(new StringBuffer().append(current).append(".exe").toString());
                }
            } else {
                executable = new File(current);
            }
            if (!executable.exists()) continue;
            return executable.getAbsolutePath();
        }
        return "java";
    }
}

