/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.newjvm.ExecJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import javax.swing.JOptionPane;

public abstract class AbstractMasterJVM
implements MasterRemote {
    public static final Log _log;
    protected volatile String _waitForQuitThreadName = "Wait for SlaveJVM Exit Thread";
    protected final Object _masterJVMLock = new Object();
    private static final String RUNNER;
    private volatile SlaveRemote _slave;
    private volatile boolean _startupInProgress = false;
    private volatile boolean _quitOnStartup = false;
    private volatile MasterRemote _masterStub = null;
    private volatile File _masterStubFile;
    private final String _slaveClassName;
    private volatile Thread _monitorThread;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$util$newjvm$AbstractMasterJVM;
    private static final /* synthetic */ Class class$edu$rice$cs$util$newjvm$SlaveJVMRunner;

    protected AbstractMasterJVM(String slaveClassName) {
        this._slaveClassName = slaveClassName;
        this._slave = null;
        this._monitorThread = null;
        _log.log(this + " CREATED");
        System.setProperty("java.rmi.server.hostname", "127.0.0.1");
    }

    protected abstract void handleSlaveConnected();

    protected abstract void handleSlaveQuit(int var1);

    protected final void invokeSlave() throws IOException, RemoteException {
        this.invokeSlave(new String[0], FileOption.NULL_FILE);
    }

    protected final void invokeSlave(String[] jvmArgs, File workDir) throws IOException, RemoteException {
        this.invokeSlave(jvmArgs, System.getProperty("java.class.path"), workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invokeSlave(final String[] jvmArgs, final String cp, final File workDir) throws IOException, RemoteException {
        Object object = this._masterJVMLock;
        synchronized (object) {
            try {
                while (this._startupInProgress || this._monitorThread != null) {
                    this._masterJVMLock.wait();
                }
            }
            catch (InterruptedException e) {
                throw new UnexpectedException(e);
            }
            this._startupInProgress = true;
        }
        _log.log(this + ".invokeSlave(...) called");
        if (!$assertionsDisabled && this._slave == null) {
            throw new AssertionError();
        }
        if (this._masterStub == null) {
            try {
                this._masterStub = (MasterRemote)((Object)UnicastRemoteObject.exportObject(this));
            }
            catch (RemoteException re) {
                JOptionPane.showMessageDialog(null, StringOps.getStackTrace(re));
                _log.log(this + " threw " + re);
                throw new UnexpectedException(re);
            }
            _log.log(this + " EXPORTed Master JVM");
            this._masterStubFile = File.createTempFile("DrJava-remote-stub", ".tmp");
            this._masterStubFile.deleteOnExit();
            FileOutputStream fstream = new FileOutputStream(this._masterStubFile);
            ObjectOutputStream ostream = new ObjectOutputStream(fstream);
            ostream.writeObject(this._masterStub);
            ostream.flush();
            fstream.close();
            ostream.close();
        }
        final String[] args = new String[]{this._masterStubFile.getAbsolutePath(), this._slaveClassName};
        this._monitorThread = new Thread(this._waitForQuitThreadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    _log.log(AbstractMasterJVM.this + " is STARTING a Slave JVM with args " + Arrays.asList(args));
                    Process process = ExecJVM.runJVM(AbstractMasterJVM.access$000(), args, cp, jvmArgs, workDir);
                    _log.log(AbstractMasterJVM.this + " CREATED Slave JVM process " + process + " with " + this.asString());
                    int status = process.waitFor();
                    _log.log(process + " DIED under control of " + this.asString() + " with status " + status);
                    Object object = AbstractMasterJVM.this._masterJVMLock;
                    synchronized (object) {
                        if (AbstractMasterJVM.access$100(AbstractMasterJVM.this)) {
                            _log.log("Process " + process + " died while starting up");
                            AbstractMasterJVM.this.slaveQuitDuringStartup(status);
                        }
                        if (AbstractMasterJVM.access$200(AbstractMasterJVM.this) != null) {
                            AbstractMasterJVM.access$202(AbstractMasterJVM.this, null);
                        }
                        AbstractMasterJVM.access$302(AbstractMasterJVM.this, null);
                        AbstractMasterJVM.this._masterJVMLock.notifyAll();
                    }
                    AbstractMasterJVM.this.handleSlaveQuit(status);
                }
                catch (NoSuchObjectException e) {
                    throw new UnexpectedException(e);
                }
                catch (InterruptedException e) {
                    throw new UnexpectedException(e);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e);
                }
            }

            private String asString() {
                return "MonitorThread@" + Integer.toHexString(this.hashCode());
            }
        };
        this._monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSlaveDone() {
        try {
            Object object = this._masterJVMLock;
            synchronized (object) {
                while (this._monitorThread != null) {
                    this._masterJVMLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new UnexpectedException(e);
        }
    }

    protected void slaveQuitDuringStartup(int status) {
        this._startupInProgress = false;
        this._quitOnStartup = false;
        this._monitorThread = null;
    }

    public abstract void errorStartingSlave(Throwable var1) throws RemoteException;

    public void checkStillAlive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSlave(SlaveRemote slave) throws RemoteException {
        boolean quitSlavePending;
        _log.log(this + " registering Slave " + slave);
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._slave = slave;
            this._startupInProgress = false;
            _log.log(this + " calling handleSlaveConnected()");
            this.handleSlaveConnected();
            quitSlavePending = this._quitOnStartup;
            if (this._quitOnStartup) {
                this._quitOnStartup = false;
            }
        }
        if (quitSlavePending) {
            _log.log(this + " Executing deferred quitSlave() that was called during startup");
            this.quitSlave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws RemoteException {
        SlaveRemote dyingSlave;
        _log.log(this + ".dispose() called; slaveRemote is " + this._slave);
        if (this._startupInProgress) {
            _log.log(this + ".dispose() is KILLing startup in process; dying slave reference does not yet exist");
        }
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._masterStub = null;
            if (this._monitorThread != null) {
                this._monitorThread = null;
            }
            dyingSlave = this._slave;
            this._slave = null;
            _log.log(this + ".dispose() UNEXPORTing " + this);
            UnicastRemoteObject.unexportObject(this, true);
        }
        if (dyingSlave != null) {
            _log.log(this + ".dispose() QUITing " + dyingSlave);
            dyingSlave.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void quitSlave() throws RemoteException {
        SlaveRemote dyingSlave;
        Object object = this._masterJVMLock;
        synchronized (object) {
            if (this.isStartupInProgress()) {
                this._quitOnStartup = true;
                return;
            }
            if (this._slave == null) {
                _log.log(this + " called quitSlave() when no slave was running");
                return;
            }
            dyingSlave = this._slave;
            this._slave = null;
        }
        dyingSlave.quit();
    }

    protected final SlaveRemote getSlave() {
        return this._slave;
    }

    protected boolean isStartupInProgress() {
        return this._startupInProgress;
    }

    static String access$000() {
        return RUNNER;
    }

    static boolean access$100(AbstractMasterJVM x0) {
        return x0._startupInProgress;
    }

    static SlaveRemote access$200(AbstractMasterJVM x0) {
        return x0._slave;
    }

    static SlaveRemote access$202(AbstractMasterJVM x0, SlaveRemote x1) {
        x0._slave = x1;
        return x0._slave;
    }

    static Thread access$302(AbstractMasterJVM x0, Thread x1) {
        x0._monitorThread = x1;
        return x0._monitorThread;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$util$newjvm$AbstractMasterJVM == null ? (class$edu$rice$cs$util$newjvm$AbstractMasterJVM = AbstractMasterJVM.class$("edu.rice.cs.util.newjvm.AbstractMasterJVM")) : class$edu$rice$cs$util$newjvm$AbstractMasterJVM).desiredAssertionStatus();
        _log = new Log("MasterSlave.txt", false);
        RUNNER = (class$edu$rice$cs$util$newjvm$SlaveJVMRunner == null ? (class$edu$rice$cs$util$newjvm$SlaveJVMRunner = AbstractMasterJVM.class$("edu.rice.cs.util.newjvm.SlaveJVMRunner")) : class$edu$rice$cs$util$newjvm$SlaveJVMRunner).getName();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

