/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.util.BidirectionalHashMap;
import edu.rice.cs.util.docnavigation.FileNode;
import edu.rice.cs.util.docnavigation.GroupNode;
import edu.rice.cs.util.docnavigation.GroupNotSelectedException;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorAlgo;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.InnerNode;
import edu.rice.cs.util.docnavigation.LeafNode;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.docnavigation.RootNode;
import edu.rice.cs.util.swing.DisplayManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeSortNavigator<ItemT extends INavigatorItem>
extends JTree
implements IDocumentNavigator<ItemT>,
TreeSelectionListener,
TreeExpansionListener {
    private DefaultTreeModel _model;
    private NodeData<ItemT> _current;
    private HashMap<ItemT, LeafNode<ItemT>> _doc2node = new HashMap();
    private BidirectionalHashMap<String, InnerNode<?, ItemT>> _path2node = new BidirectionalHashMap();
    private Vector<INavigationListener<? super ItemT>> navListeners = new Vector();
    private CustomTreeCellRenderer _renderer;
    private DisplayManager<? super ItemT> _displayManager;
    private Icon _rootIcon;
    private List<GroupNode<ItemT>> _roots = new LinkedList<GroupNode<ItemT>>();
    private final NodeDataVisitor<ItemT, ItemT> _leafVisitor = new NodeDataVisitor<ItemT, ItemT>(){

        @Override
        public ItemT fileCase(File f, Object ... p) {
            return null;
        }

        @Override
        public ItemT stringCase(String s, Object ... p) {
            return null;
        }

        @Override
        public ItemT itemCase(ItemT ini, Object ... p) {
            return ini;
        }

        @Override
        public Object itemCase(INavigatorItem x0, Object[] x1) {
            return this.itemCase(x0, x1);
        }

        @Override
        public Object stringCase(String x0, Object[] x1) {
            return this.stringCase(x0, x1);
        }

        @Override
        public Object fileCase(File x0, Object[] x1) {
            return this.fileCase(x0, x1);
        }
    };

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this._renderer != null) {
            this._renderer.setTextNonSelectionColor(c);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this._renderer != null) {
            this._renderer.setBackgroundNonSelectionColor(c);
        }
    }

    public JTreeSortNavigator(String projRoot) {
        super(new DefaultTreeModel(new RootNode(projRoot.substring(projRoot.lastIndexOf(File.separator) + 1))));
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this._model = (DefaultTreeModel)this.getModel();
        this._renderer = new CustomTreeCellRenderer(null);
        this._renderer.setOpaque(false);
        this.setCellRenderer(this._renderer);
        this.getSelectionModel().setSelectionMode(1);
        this.setRowHeight(18);
    }

    public JTreeSortNavigator(String projRoot, DisplayManager<? super ItemT> dm) {
        this(projRoot);
        this._displayManager = dm;
    }

    public void setDisplayManager(DisplayManager<? super ItemT> manager) {
        this._displayManager = manager;
    }

    public void setRootIcon(Icon ico) {
        this._rootIcon = ico;
    }

    @Override
    public Container asContainer() {
        return this;
    }

    @Override
    public void addDocument(ItemT doc) {
        this.addDocument(doc, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(ItemT doc, String path) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            GroupNode<ItemT> root = null;
            for (GroupNode<ItemT> r : this._roots) {
                if (!r.getFilter().accept(doc)) continue;
                root = r;
                break;
            }
            if (root == null) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(path, File.separator);
            StringBuffer pathSoFarBuf = new StringBuffer();
            InnerNode lastNode = root;
            while (tok.hasMoreTokens()) {
                InnerNode<?, ItemT> thisNode;
                String element = tok.nextToken();
                pathSoFarBuf.append(element).append('/');
                String pathSoFar = pathSoFarBuf.toString();
                if (!this._path2node.containsKey(pathSoFar)) {
                    thisNode = new FileNode(new File(pathSoFar));
                    this.insertFolderSortedInto(thisNode, lastNode);
                    this.expandPath(new TreePath(lastNode.getPath()));
                    this._path2node.put(pathSoFar, thisNode);
                } else {
                    thisNode = this._path2node.getValue(pathSoFar);
                }
                lastNode = thisNode;
            }
            LeafNode<ItemT> child = new LeafNode<ItemT>(doc);
            this._doc2node.put(doc, child);
            this.insertNodeSortedInto(child, lastNode);
            this.expandPath(new TreePath(lastNode.getPath()));
            child.setUserObject(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTopLevelGroupToRoot(InnerNode<?, ItemT> parent) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreeNode n;
            int i;
            int indexInRoots = this._roots.indexOf(parent);
            int num = this._model.getChildCount(this._model.getRoot());
            for (i = 0; i < num && this._roots.indexOf(n = (TreeNode)this._model.getChild(this._model.getRoot(), i)) <= indexInRoots; ++i) {
            }
            this._model.insertNodeInto(parent, (MutableTreeNode)this._model.getRoot(), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodeSortedInto(LeafNode<ItemT> child, InnerNode<?, ItemT> parent) {
        int numChildren = parent.getChildCount();
        String newName = child.toString();
        String oldName = parent.getUserObject().toString();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            int i;
            if (((DefaultMutableTreeNode)this._model.getRoot()).getIndex(parent) == -1 && this._roots.contains(parent)) {
                this.addTopLevelGroupToRoot(parent);
            }
            for (i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode parentsKid = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (parentsKid instanceof InnerNode) continue;
                if (parentsKid instanceof LeafNode) {
                    oldName = ((LeafNode)parentsKid).getData().getName();
                    if (newName.toUpperCase().compareTo(oldName.toUpperCase()) >= 0) continue;
                    break;
                }
                throw new IllegalStateException("found a node in navigator that is not an InnerNode or LeafNode");
            }
            this._model.insertNodeInto(child, parent, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFolderSortedInto(InnerNode<?, ItemT> child, InnerNode<?, ItemT> parent) {
        int numChildren = parent.getChildCount();
        String newName = child.toString();
        String oldName = parent.getUserObject().toString();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            int i;
            if (((DefaultMutableTreeNode)this._model.getRoot()).getIndex(parent) == -1 && this._roots.contains(parent)) {
                this.addTopLevelGroupToRoot(parent);
            }
            int countFolders = 0;
            for (i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode parentsKid = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (parentsKid instanceof InnerNode) {
                    ++countFolders;
                    oldName = parentsKid.toString();
                    if (newName.toUpperCase().compareTo(oldName.toUpperCase()) >= 0) continue;
                    break;
                }
                if (parentsKid instanceof LeafNode) break;
                throw new IllegalStateException("found a node in navigator that is not an InnerNode or LeafNode");
            }
            this._model.insertNodeInto(child, parent, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT removeDocument(ItemT doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            LeafNode<ItemT> toRemove = this.getNodeForDoc(doc);
            if (toRemove == null) {
                return null;
            }
            return this.removeNode(this.getNodeForDoc(doc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeafNode<ItemT> getNodeForDoc(ItemT doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            return this._doc2node.get(doc);
        }
    }

    private ItemT removeNode(LeafNode<ItemT> toRemove) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)toRemove.getParent();
        this._model.removeNodeFromParent(toRemove);
        this._doc2node.remove(toRemove.getData());
        this.cleanFolderNode(parent);
        return toRemove.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanFolderNode(DefaultMutableTreeNode node) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            if (node instanceof InnerNode && node.getChildCount() == 0) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this._model.removeNodeFromParent(node);
                InnerNode typedNode = (InnerNode)node;
                this._path2node.removeKey(typedNode);
                this.cleanFolderNode(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshDocument(ItemT doc, String path) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            InnerNode<?, ItemT> newParent;
            InnerNode oldParent;
            LeafNode<ItemT> node = this.getNodeForDoc(doc);
            if (node == null) {
                this.addDocument(doc, path);
                oldParent = null;
            } else {
                InnerNode p;
                oldParent = p = (InnerNode)node.getParent();
            }
            String newPath = path;
            if (newPath.length() > 0) {
                if (newPath.substring(0, 1).equals("/")) {
                    newPath = newPath.substring(1);
                }
                if (!newPath.substring(newPath.length() - 1).equals("/")) {
                    newPath = new StringBuffer().append(newPath).append("/").toString();
                }
            }
            if ((newParent = this._path2node.getValue(newPath)) == oldParent) {
                if (!node.toString().equals(doc.getName())) {
                    LeafNode<ItemT> newLeaf = new LeafNode<ItemT>(doc);
                    this._doc2node.put(doc, newLeaf);
                    this.insertNodeSortedInto(newLeaf, newParent);
                    this._model.removeNodeFromParent(node);
                }
            } else {
                this.removeNode(node);
                this.addDocument(doc, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveDoc(ItemT doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode node = this._doc2node.get(doc);
            if (node == this._current) {
                return;
            }
            if (this.contains(doc)) {
                Object[] nodes = node.getPath();
                TreePath path = new TreePath(nodes);
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
            }
        }
    }

    private ItemT getNodeUserObject(DefaultMutableTreeNode n) {
        INavigatorItem result = (INavigatorItem)n.getUserObject();
        return (ItemT)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getNext(ItemT doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode node = this._doc2node.get(doc);
            if (node == null) {
                return doc;
            }
            DefaultMutableTreeNode next = node.getNextLeaf();
            if (next == null || next == this._model.getRoot()) {
                return doc;
            }
            return this.getNodeUserObject(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getPrevious(ItemT doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode node = this._doc2node.get(doc);
            if (node == null) {
                return doc;
            }
            DefaultMutableTreeNode prev = node.getPreviousLeaf();
            if (prev == null || prev == this._model.getRoot()) {
                return doc;
            }
            return this.getNodeUserObject(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getFirst() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._model.getRoot();
            return this.getNodeUserObject(root.getFirstLeaf());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getLast() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._model.getRoot();
            return this.getNodeUserObject(root.getLastLeaf());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(ItemT doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            return this._doc2node.containsKey(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<ItemT> getDocuments() {
        Vector<ItemT> list = new Vector<ItemT>();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this._model.getRoot()).depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (!node.isLeaf() || node == this._model.getRoot()) continue;
                list.add(this.getNodeUserObject(node));
            }
        }
        return list.elements();
    }

    @Override
    public int getDocumentCount() {
        return this._doc2node.size();
    }

    @Override
    public boolean isEmpty() {
        return this._doc2node.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            this._doc2node.clear();
            ((DefaultMutableTreeNode)this._model.getRoot()).removeAllChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(INavigationListener<? super ItemT> listener) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            this.navListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(INavigationListener<? super ItemT> listener) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            this.navListeners.remove(listener);
        }
    }

    @Override
    public Collection<INavigationListener<? super ItemT>> getNavigatorListeners() {
        return this.navListeners;
    }

    @Override
    public <InType, ReturnType> ReturnType execute(IDocumentNavigatorAlgo<ItemT, InType, ReturnType> algo, InType input) {
        return algo.forTree(this, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            Object treeNode = this.getLastSelectedPathComponent();
            if (treeNode == null || !(treeNode instanceof NodeData)) {
                return;
            }
            NodeData newSelection = (NodeData)treeNode;
            if (this._current != newSelection) {
                for (INavigationListener<ItemT> listener : this.navListeners) {
                    listener.lostSelection(this._current, this.isNextChangeModelInitiated());
                    listener.gainedSelection(newSelection, this.isNextChangeModelInitiated());
                }
                this._current = newSelection;
            }
            this.setNextChangeModelInitiated(false);
        }
    }

    @Override
    public Component getRenderer() {
        return this._renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean selectDocumentAt(int x, int y) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath path = this.getPathForLocation(x, y);
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node instanceof LeafNode) {
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
                return true;
            }
            if (node instanceof InnerNode) {
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
                return true;
            }
            if (node instanceof RootNode) {
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGroupSelected() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            return n instanceof InnerNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopLevelGroupSelected() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            return n instanceof GroupNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameOfSelectedTopLevelGroup() throws GroupNotSelectedException {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            if (n == this._model.getRoot()) {
                throw new GroupNotSelectedException("there is no top level group for the root of the tree");
            }
            while (!this._roots.contains(n)) {
                n = n.getParent();
            }
            return ((GroupNode)n).getData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getCurrent() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            if (this._current == null) {
                return null;
            }
            return (ItemT)((INavigatorItem)this._current.execute(this._leafVisitor, new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelectedInGroup(ItemT i) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            TreeNode l = this._doc2node.get(i);
            if (n == this._model.getRoot()) {
                return true;
            }
            while (l.getParent() != this._model.getRoot()) {
                if (l.getParent() == n) {
                    return true;
                }
                l = l.getParent();
            }
            return false;
        }
    }

    @Override
    public synchronized void addTopLevelGroup(String name, INavigatorItemFilter<? super ItemT> f) {
        if (f == null) {
            throw new IllegalArgumentException("parameter 'f' is not allowed to be null");
        }
        GroupNode<? super ItemT> n = new GroupNode<ItemT>(name, f);
        this._roots.add(n);
    }

    @Override
    public synchronized void treeCollapsed(TreeExpansionEvent event) {
        Object o = event.getPath().getLastPathComponent();
        if (o instanceof InnerNode) {
            ((InnerNode)o).setCollapsed(true);
        }
    }

    @Override
    public synchronized void treeExpanded(TreeExpansionEvent event) {
        Object o = event.getPath().getLastPathComponent();
        if (o instanceof InnerNode) {
            ((InnerNode)o).setCollapsed(false);
        }
    }

    public void collapsePaths(String[] paths) {
        HashSet<String> set = new HashSet<String>();
        for (String s : paths) {
            set.add(s);
        }
        this.collapsePaths(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collapsePaths(HashSet<String> paths) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this._model.getRoot();
            Enumeration<TreeNode> nodes = rootNode.depthFirstEnumeration();
            ArrayList list = new ArrayList();
            while (nodes.hasMoreElements()) {
                TreePath tp;
                String s;
                boolean shouldCollapse;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)nodes.nextElement();
                if (!(tn instanceof InnerNode) || !(shouldCollapse = paths.contains(s = this.generatePathString(tp = new TreePath(tn.getPath()))))) continue;
                this.collapsePath(tp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCollapsedPaths() {
        ArrayList<String> list = new ArrayList<String>();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this._model.getRoot();
            Enumeration<TreeNode> nodes = rootNode.depthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)nodes.nextElement();
                if (!(tn instanceof InnerNode) || !((InnerNode)tn).isCollapsed()) continue;
                TreePath tp = new TreePath(tn.getPath());
                list.add(this.generatePathString(tp));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generatePathString(TreePath tp) {
        String path = "";
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreeNode root = (TreeNode)this._model.getRoot();
            while (tp != null) {
                TreeNode curr = (TreeNode)tp.getLastPathComponent();
                path = curr == root ? new StringBuffer().append("./").append(path).toString() : new StringBuffer().append(curr).append("/").append(path).toString();
                tp = tp.getParentPath();
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSelectionUpdate(ItemT ini) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            if (this.getCurrent() == null) {
                this.setActiveDoc(ini);
            }
        }
    }

    @Override
    public void setNextChangeModelInitiated(boolean b) {
        this.putClientProperty("ModelInitiated", b ? Boolean.TRUE : null);
    }

    @Override
    public boolean isNextChangeModelInitiated() {
        return this.getClientProperty("ModelInitiated") != null;
    }

    static Icon access$100(JTreeSortNavigator x0) {
        return x0._rootIcon;
    }

    static INavigatorItem access$200(JTreeSortNavigator x0, DefaultMutableTreeNode x1) {
        return x0.getNodeUserObject(x1);
    }

    static DisplayManager access$300(JTreeSortNavigator x0) {
        return x0._displayManager;
    }

    private class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CustomTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean isExpanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, isExpanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node instanceof RootNode && JTreeSortNavigator.access$100(JTreeSortNavigator.this) != null) {
                this.setIcon(JTreeSortNavigator.access$100(JTreeSortNavigator.this));
            } else if (node instanceof LeafNode) {
                INavigatorItem doc = JTreeSortNavigator.access$200(JTreeSortNavigator.this, node);
                if (leaf && JTreeSortNavigator.access$300(JTreeSortNavigator.this) != null) {
                    this.setIcon(JTreeSortNavigator.access$300(JTreeSortNavigator.this).getIcon(doc));
                    this.setText(JTreeSortNavigator.access$300(JTreeSortNavigator.this).getName(doc));
                }
            }
            return this;
        }

        CustomTreeCellRenderer(1 x1) {
            this();
        }
    }
}

