/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.classloader;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitingClassLoader
extends ClassLoader {
    private List<String> _restrictedList = new LinkedList<String>();

    public LimitingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addToRestrictedList(String name) {
        this._restrictedList.add(name);
    }

    public void clearRestrictedList() {
        this._restrictedList.clear();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ListIterator<String> itor = this._restrictedList.listIterator();
        while (itor.hasNext()) {
            String current = itor.next();
            if (!current.equals(name)) continue;
            throw new ClassNotFoundException(new StringBuffer().append("Class ").append(name).append(" is on the restricted list.").toString());
        }
        Class<?> clazz = this.getParent().loadClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

