/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.Pair;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringOps {
    public static String replace(String fullString, String toReplace, String replacement) {
        int index = 0;
        int fullStringLength = fullString.length();
        int toReplaceLength = toReplace.length();
        if (toReplaceLength > 0) {
            int pos;
            int replacementLength = replacement.length();
            while (index < fullStringLength && (pos = fullString.indexOf(toReplace, index)) >= 0) {
                StringBuffer buff = new StringBuffer(fullString.substring(0, pos));
                buff.append(replacement);
                buff.append(fullString.substring(pos + toReplaceLength, fullStringLength));
                index = pos + replacementLength;
                fullString = buff.toString();
                fullStringLength = fullString.length();
            }
        }
        return fullString;
    }

    public static String convertToLiteral(String s) {
        String output = s;
        output = StringOps.replace(output, "\\", "\\\\");
        output = StringOps.replace(output, "\"", "\\\"");
        output = StringOps.replace(output, "\t", "\\t");
        output = StringOps.replace(output, "\n", "\\n");
        return new StringBuffer().append("\"").append(output).append("\"").toString();
    }

    private static void _ensureStartBeforeEnd(int startRow, int startCol, int endRow, int endCol) {
        if (startRow > endRow) {
            throw new IllegalArgumentException(new StringBuffer().append("end row before start row: ").append(startRow).append(" > ").append(endRow).toString());
        }
        if (startRow == endRow && startCol > endCol) {
            throw new IllegalArgumentException(new StringBuffer().append("end before start: (").append(startRow).append(", ").append(startCol).append(") > (").append(endRow).append(", ").append(endCol).append(")").toString());
        }
    }

    private static void _ensureColInRow(String fullString, int col, int rowStartIndex) {
        int endOfLine = fullString.indexOf("\n", rowStartIndex);
        if (endOfLine == -1) {
            endOfLine = fullString.length();
        }
        if (col > endOfLine - rowStartIndex) {
            throw new IllegalArgumentException("the given column is past the end of its row");
        }
    }

    public static Pair<Integer, Integer> getOffsetAndLength(String fullString, int startRow, int startCol, int endRow, int endCol) {
        int linesSeen;
        StringOps._ensureStartBeforeEnd(startRow, startCol, endRow, endCol);
        int currentChar = 0;
        for (linesSeen = 1; startRow > linesSeen; ++linesSeen) {
            if ((currentChar = fullString.indexOf("\n", currentChar)) == -1) {
                throw new IllegalArgumentException("startRow is beyond the end of the string");
            }
            ++currentChar;
        }
        StringOps._ensureColInRow(fullString, startCol, currentChar);
        int offset = currentChar + startCol - 1;
        while (endRow > linesSeen) {
            if ((currentChar = fullString.indexOf("\n", currentChar)) == -1) {
                throw new IllegalArgumentException("endRow is beyond the end of the string");
            }
            ++currentChar;
            ++linesSeen;
        }
        StringOps._ensureColInRow(fullString, endCol, currentChar);
        int length = currentChar + endCol - offset;
        if (offset + length > fullString.length()) {
            throw new IllegalArgumentException("Given positions beyond the end of the string");
        }
        return new Pair<Integer, Integer>(new Integer(offset), new Integer(length));
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String getStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceElement[] stes = e.getStackTrace();
            int skip = 1;
            for (StackTraceElement ste : stes) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                pw.print("at ");
                pw.println(ste);
            }
            return sw.toString();
        }
    }

    public static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isAnonymousClass(Class c) {
        String simpleName = c.getName();
        int idx = simpleName.lastIndexOf(36);
        if (idx >= 0) {
            for (int pos = idx + 1; pos < simpleName.length(); ++pos) {
                if (StringOps.isAsciiDigit(simpleName.charAt(pos))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMemberClass(Class c) {
        String simpleName = c.getName();
        int idx = simpleName.lastIndexOf(36);
        if (idx == -1) {
            return false;
        }
        return !StringOps.isAnonymousClass(c);
    }

    public static String getSimpleName(Class c) {
        if (c.isArray()) {
            return new StringBuffer().append(StringOps.getSimpleName(c.getComponentType())).append("[]").toString();
        }
        if (StringOps.isAnonymousClass(c)) {
            return "";
        }
        String simpleName = c.getName();
        int idx = Math.max(simpleName.lastIndexOf(46), simpleName.lastIndexOf(36));
        return simpleName.substring(idx + 1);
    }

    public static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(short[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            buf.append(String.valueOf(a[i]));
        }
        buf.append("]");
        return buf.toString();
    }

    public static String encodeHTML(String s) {
        s = StringOps.replace(s, "&", "&amp;");
        s = StringOps.replace(s, "<", "&lt;");
        s = StringOps.replace(s, ">", "&gt;");
        s = StringOps.replace(s, System.getProperty("line.separator"), "<br>");
        s = StringOps.replace(s, "\n", "<br>");
        return s;
    }

    public static String memSizeToString(long l) {
        int i;
        String[] sizes = new String[]{"byte", "kilobyte", "megabyte", "gigabyte"};
        double d = l;
        for (i = 0; d >= 1024.0 && i < sizes.length; ++i, d /= 1024.0) {
        }
        if (i >= sizes.length) {
            i = sizes.length - 1;
        }
        StringBuffer sb = new StringBuffer();
        long whole = (long)d;
        if ((double)whole == d) {
            if (whole == 1L) {
                sb.append(whole);
                sb.append(' ');
                sb.append(sizes[i]);
            } else {
                sb.append(whole);
                sb.append(' ');
                sb.append(sizes[i]);
                sb.append('s');
            }
        } else {
            DecimalFormat df = new DecimalFormat("#.00");
            sb.append(df.format(d));
            sb.append(' ');
            sb.append(sizes[i]);
            sb.append('s');
        }
        return sb.toString();
    }
}

