/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.UnexpectedException;
import java.util.LinkedList;

public class ReaderWriterLock {
    private volatile int _numActiveReaders = 0;
    private volatile int _numActiveWriters = 0;
    private volatile int _numWaitingReaders = 0;
    private volatile int _numWaitingWriters = 0;
    private final LinkedList<ReaderWriterThread> _waitQueue = new LinkedList();
    private final LinkedList<Thread> _runningThreads = new LinkedList();

    public synchronized void startRead() {
        if (!this._alreadyReading()) {
            this._ensureNotAlreadyRunning();
            if (this._numWaitingWriters > 0 || this._numActiveWriters > 0) {
                ++this._numWaitingReaders;
                Reader r = new Reader();
                r.startWaiting();
                --this._numWaitingReaders;
            }
        }
        ++this._numActiveReaders;
        this._runningThreads.add(Thread.currentThread());
    }

    public synchronized void endRead() {
        if (this._numActiveReaders == 0) {
            throw new IllegalStateException("Trying to end a read with no active readers!");
        }
        --this._numActiveReaders;
        this._ensureAlreadyRunning();
        this._runningThreads.remove(Thread.currentThread());
        if (this._numActiveWriters > 0) {
            String msg = "A writer was active during a read!";
            throw new UnexpectedException(new Exception(msg));
        }
        if (this._numActiveReaders == 0) {
            this._wakeFrontGroupOfWaitQueue();
        }
    }

    public synchronized void startWrite() {
        this._ensureNotAlreadyRunning();
        if (this._numActiveReaders > 0 || this._numActiveWriters > 0 || this._numWaitingReaders > 0 || this._numWaitingWriters > 0) {
            ++this._numWaitingWriters;
            Writer w = new Writer();
            w.startWaiting();
            --this._numWaitingWriters;
        }
        ++this._numActiveWriters;
        this._runningThreads.add(Thread.currentThread());
    }

    public synchronized void endWrite() {
        if (this._numActiveWriters != 1) {
            throw new IllegalStateException("Trying to end a write with " + this._numActiveWriters + " active writers!");
        }
        --this._numActiveWriters;
        this._ensureAlreadyRunning();
        this._runningThreads.remove(Thread.currentThread());
        if (this._numActiveWriters > 0 || this._numActiveReaders > 0) {
            String msg = "Multiple readers/writers were active during a write!";
            throw new UnexpectedException(new Exception(msg));
        }
        this._wakeFrontGroupOfWaitQueue();
    }

    private boolean _alreadyReading() {
        return this._numActiveReaders > 0 && this._runningThreads.contains(Thread.currentThread());
    }

    private void _ensureNotAlreadyRunning() {
        if (this._runningThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("Same thread cannot read or write multiple times!  (Would cause deadlock.)");
        }
    }

    private void _ensureAlreadyRunning() {
        if (!this._runningThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("Current thread did not initiate a read or write!");
        }
    }

    private synchronized void _wakeFrontGroupOfWaitQueue() {
        if (!this._waitQueue.isEmpty()) {
            ReaderWriterThread front = this._waitQueue.getFirst();
            front.stopWaiting();
            if (front.isReader()) {
                while (!this._waitQueue.isEmpty() && (front = this._waitQueue.getFirst()).isReader()) {
                    front.stopWaiting();
                }
            }
        }
    }

    static LinkedList access$000(ReaderWriterLock x0) {
        return x0._waitQueue;
    }

    public class Writer
    extends ReaderWriterThread {
        public boolean isReader() {
            return false;
        }

        public boolean isWriter() {
            return true;
        }
    }

    public class Reader
    extends ReaderWriterThread {
        public boolean isReader() {
            return true;
        }

        public boolean isWriter() {
            return false;
        }
    }

    public abstract class ReaderWriterThread {
        private volatile boolean _isWaiting = true;

        public abstract boolean isWriter();

        public abstract boolean isReader();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startWaiting() {
            ReaderWriterLock readerWriterLock = ReaderWriterLock.this;
            synchronized (readerWriterLock) {
                this._isWaiting = true;
                ReaderWriterLock.access$000(ReaderWriterLock.this).addLast(this);
                while (this._isWaiting) {
                    try {
                        ReaderWriterLock.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopWaiting() {
            ReaderWriterLock readerWriterLock = ReaderWriterLock.this;
            synchronized (readerWriterLock) {
                this._isWaiting = false;
                ReaderWriterLock.access$000(ReaderWriterLock.this).remove(this);
                ReaderWriterLock.this.notifyAll();
            }
        }
    }
}

