/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class Log {
    public static final boolean ENABLE_ALL = false;
    protected boolean _isEnabled;
    protected String _name;
    protected PrintWriter _writer;

    public Log(String name, boolean isEnabled) {
        this._name = name;
        this._isEnabled = isEnabled;
        this._init();
    }

    protected void _init() {
        if (this._writer == null && this._isEnabled) {
            try {
                File f = new File(this._name);
                FileWriter w = new FileWriter(f.getAbsolutePath(), true);
                this._writer = new PrintWriter(w);
                this.log("Log '" + this._name + "' opened: " + new Date());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not create log: " + ioe);
            }
        }
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public synchronized void log(String message) {
        if (this.isEnabled()) {
            if (this._writer == null) {
                this._init();
            }
            this._writer.println(new Date() + ": " + message);
            this._writer.flush();
        }
    }

    public static String traceToString(StackTraceElement[] trace) {
        StringBuffer traceImage = new StringBuffer();
        StackTraceElement[] arr$ = trace;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StackTraceElement e = arr$[i$];
            traceImage.append("\n" + e.toString());
        }
        return traceImage.toString();
    }

    public synchronized void log(String s, StackTraceElement[] trace) {
        if (this.isEnabled()) {
            this.log(s + Log.traceToString(trace));
        }
    }

    public synchronized void log(String s, Throwable t) {
        if (this.isEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.log(s + "\n" + sw.toString());
        }
    }
}

