/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileOps {
    private static Log _log = new Log("FileOpsTest.txt", false);
    public static final File NONEXISTENT_FILE = new File(""){

        public String getAbsolutePath() {
            return "";
        }

        public String getName() {
            return "";
        }

        public String toString() {
            return "";
        }

        public boolean exists() {
            return false;
        }
    };
    public static final FileFilter JAVA_FILE_FILTER = new FileFilter(){

        public boolean accept(File f) {
            StringBuffer name = new StringBuffer(f.getAbsolutePath());
            String shortName = f.getName();
            if (shortName.length() < 6) {
                return false;
            }
            name.delete(name.length() - 5, name.length());
            name.append(".java");
            File test = new File(new String(name));
            return test.equals(f);
        }

        public String getDescription() {
            return "Java Source Files (*.java)";
        }
    };

    public static boolean inFileTree(File f, File root) {
        if (root == null || f == null) {
            return false;
        }
        try {
            if (!f.isDirectory()) {
                f = f.getParentFile();
            }
            String filePath = new StringBuffer().append(f.getCanonicalPath()).append(File.separator).toString();
            String projectPath = new StringBuffer().append(root.getCanonicalPath()).append(File.separator).toString();
            return filePath.startsWith(projectPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File makeRelativeTo(File f, File b) throws IOException, SecurityException {
        int i;
        File base = b.getCanonicalFile();
        File abs = f.getCanonicalFile();
        if (!base.isDirectory()) {
            base = base.getParentFile();
        }
        String last = "";
        if (!abs.isDirectory()) {
            String tmp = abs.getPath();
            last = tmp.substring(tmp.lastIndexOf(File.separator) + 1);
            abs = abs.getParentFile();
        }
        String[] basParts = FileOps.splitFile(base);
        String[] absParts = FileOps.splitFile(abs);
        StringBuffer result = new StringBuffer();
        int diffIndex = -1;
        boolean different = false;
        for (i = 0; i < basParts.length; ++i) {
            if (!(different || i < absParts.length && basParts[i].equals(absParts[i]))) {
                different = true;
                diffIndex = i;
            }
            if (!different) continue;
            result.append("..").append(File.separator);
        }
        if (diffIndex < 0) {
            diffIndex = basParts.length;
        }
        for (i = diffIndex; i < absParts.length; ++i) {
            result.append(absParts[i]).append(File.separator);
        }
        result.append(last);
        return new File(result.toString());
    }

    public static String[] splitFile(File fileToSplit) {
        String path = fileToSplit.getPath();
        ArrayList<String> list = new ArrayList<String>();
        while (!path.equals("")) {
            int idx = path.indexOf(File.separator);
            if (idx < 0) {
                list.add(path);
                path = "";
                continue;
            }
            list.add(path.substring(0, idx));
            path = path.substring(idx + 1);
        }
        return list.toArray(new String[list.size()]);
    }

    public static ArrayList<File> getFilesInDir(File d, boolean recur, FileFilter f) {
        ArrayList<File> l = new ArrayList<File>();
        FileOps.getFilesInDir(d, l, recur, f);
        return l;
    }

    private static void getFilesInDir(File d, List<File> acc, boolean recur, FileFilter filter) {
        File[] files;
        if (d.isDirectory() && (files = d.listFiles(filter)) != null) {
            for (File f : files) {
                if (f.isDirectory() && recur) {
                    FileOps.getFilesInDir(f, acc, recur, filter);
                    continue;
                }
                if (!f.isFile()) continue;
                acc.add(f);
            }
        }
    }

    public static File getCanonicalFile(File f) {
        if (f == null) {
            return f;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return f.getAbsoluteFile();
    }

    public static String getCanonicalPath(File f) {
        return FileOps.getCanonicalFile(f).getPath();
    }

    public static File validate(File f) {
        if (f.exists()) {
            return f;
        }
        return FileOption.NULL_FILE;
    }

    public static byte[] readStreamAsBytes(InputStream stream) throws IOException {
        BufferedInputStream buffered = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int readVal = buffered.read();
        while (readVal != -1) {
            out.write(readVal);
            readVal = buffered.read();
        }
        stream.close();
        return out.toByteArray();
    }

    public static String readFileAsString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        StringBuffer buf = new StringBuffer();
        while (reader.ready()) {
            char c = (char)reader.read();
            buf.append(c);
        }
        reader.close();
        return buf.toString();
    }

    public static void copyFile(File source, File dest) throws IOException {
        String text = FileOps.readFileAsString(source);
        FileOps.writeStringToFile(dest, text);
    }

    public static File writeStringToNewTempFile(String prefix, String suffix, String text) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        FileOps.writeStringToFile(file, text);
        return file;
    }

    public static void writeStringToFile(File file, String text) throws IOException {
        FileOps.writeStringToFile(file, text, false);
    }

    public static void writeStringToFile(File file, String text, boolean append) throws IOException {
        FileWriter writer = new FileWriter(file, append);
        writer.write(text);
        writer.close();
    }

    public static boolean writeIfPossible(File file, String text, boolean append) {
        try {
            FileOps.writeStringToFile(file, text, append);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File createTempDirectory(String name) throws IOException {
        return FileOps.createTempDirectory(name, null);
    }

    public static File createTempDirectory(String name, File parent) throws IOException {
        File file = File.createTempFile(name, "", parent);
        file.delete();
        file.mkdir();
        file.deleteOnExit();
        return file;
    }

    public static boolean deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            boolean res = dir.delete();
            return res;
        }
        boolean ret = true;
        File[] childFiles = dir.listFiles();
        if (childFiles != null) {
            for (File f : childFiles) {
                ret = ret && FileOps.deleteDirectory(f);
            }
        }
        ret = ret && dir.delete();
        return ret;
    }

    public static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        _log.log(new StringBuffer().append("Deleting file/directory ").append(dir).append(" on exit").toString());
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                FileOps.deleteDirectoryOnExit(f);
            }
        }
    }

    public static LinkedList<String> packageExplore(String prefix, File root) {
        final HashSet<File> exploredDirectories = new HashSet<File>();
        LinkedList<String> output = new LinkedList<String>();
        Stack<PrefixAndFile> working = new Stack<PrefixAndFile>();
        class PrefixAndFile {
            public String prefix;
            public File root;

            public PrefixAndFile(String prefix, File root) {
                this.root = root;
                this.prefix = prefix;
            }
        }
        working.push(new PrefixAndFile(prefix, root));
        exploredDirectories.add(root);
        FileFilter directoryFilter = new FileFilter(){

            public boolean accept(File f) {
                boolean toReturn = f.isDirectory() && !exploredDirectories.contains(f);
                exploredDirectories.add(f);
                return toReturn;
            }

            public String getDescription() {
                return "All Folders";
            }
        };
        while (!working.empty()) {
            File[] javaFiles;
            PrefixAndFile current = (PrefixAndFile)working.pop();
            File[] subDirectories = current.root.listFiles(directoryFilter);
            if (subDirectories != null) {
                for (File dir : subDirectories) {
                    PrefixAndFile paf = current.prefix.equals("") ? new PrefixAndFile(dir.getName(), dir) : new PrefixAndFile(new StringBuffer().append(current.prefix).append(".").append(dir.getName()).toString(), dir);
                    working.push(paf);
                }
            }
            if ((javaFiles = current.root.listFiles(JAVA_FILE_FILTER)) == null || javaFiles.length == 0 || current.prefix.equals("")) continue;
            output.add(current.prefix);
        }
        return output;
    }

    public static boolean renameFile(File file, File dest) {
        if (dest.exists()) {
            dest.delete();
        }
        return file.renameTo(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(FileSaver fileSaver) throws IOException {
        boolean makeBackup = fileSaver.shouldBackup();
        boolean success = false;
        File file = fileSaver.getTargetFile();
        File backup = null;
        boolean tempFileUsed = true;
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Permission denied");
        }
        if (makeBackup) {
            backup = fileSaver.getBackupFile();
            if (!FileOps.renameFile(file, backup)) {
                throw new IOException(new StringBuffer().append("Save failed. Could not create backup file ").append(backup.getAbsolutePath()).append("\nIt may be possible to save by disabling file backups\n").toString());
            }
            fileSaver.backupDone();
        }
        File parent = file.getParentFile();
        File tempFile = File.createTempFile("drjava", ".temp", parent);
        try {
            FileOutputStream fos;
            try {
                fos = new FileOutputStream(tempFile);
            }
            catch (FileNotFoundException fnfe) {
                if (fileSaver.continueWhenTempFileCreationFails()) {
                    fos = new FileOutputStream(file);
                    tempFileUsed = false;
                }
                throw new IOException(new StringBuffer().append("Could not create temp file ").append(tempFile).append(" in attempt to save ").append(file).toString());
            }
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            fileSaver.saveTo(bos);
            bos.close();
            fos.close();
            if (tempFileUsed && !FileOps.renameFile(tempFile, file)) {
                throw new IOException(new StringBuffer().append("Save failed. Another process may be using ").append(file).append(".").toString());
            }
            success = true;
        }
        finally {
            if (tempFileUsed) {
                tempFile.delete();
            }
            if (makeBackup) {
                if (success) {
                    fileSaver.backupDone();
                } else {
                    FileOps.renameFile(backup, file);
                }
            }
        }
    }

    public static String convertToAbsolutePathEntries(String path) {
        String pathSep = System.getProperty("path.separator");
        path = new StringBuffer().append(path).append(pathSep).append("x").toString();
        String[] pathEntries = path.split(pathSep);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pathEntries.length - 1; ++i) {
            File f = new File(pathEntries[i]);
            sb.append(f.getAbsolutePath());
            sb.append(pathSep);
        }
        String reconstructedPath = sb.toString();
        if (reconstructedPath.length() != 0) {
            reconstructedPath = reconstructedPath.substring(0, reconstructedPath.length() - 1);
        }
        return reconstructedPath;
    }

    public static File getValidDirectory(File file) {
        if (file == FileOption.NULL_FILE) {
            file = new File(System.getProperty("user.home"));
        }
        while (!file.exists()) {
            file = file.getParentFile();
        }
        if (file == null) {
            file = new File(System.getProperty("user.home"));
        }
        if (!file.isDirectory() && file.getParent() != null) {
            file = file.getParentFile();
        }
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        throw new UnexpectedException(new IOException("File's parent file is null"));
    }

    public static URL toURL(File f) throws MalformedURLException {
        return f.toURL();
    }

    public static abstract class DefaultFileSaver
    implements FileSaver {
        private File outputFile = null;
        private static Set<File> filesNotNeedingBackup = new HashSet<File>();
        private static boolean backupsEnabled = true;
        private boolean isCanonical = false;

        public static void setBackupsEnabled(boolean isEnabled) {
            backupsEnabled = isEnabled;
        }

        public DefaultFileSaver(File file) {
            this.outputFile = file.getAbsoluteFile();
        }

        public boolean continueWhenTempFileCreationFails() {
            return true;
        }

        public File getBackupFile() throws IOException {
            return new File(this.getTargetFile().getPath() + "~");
        }

        public boolean shouldBackup() throws IOException {
            if (!backupsEnabled) {
                return false;
            }
            if (!this.getTargetFile().exists()) {
                return false;
            }
            return !filesNotNeedingBackup.contains(this.getTargetFile());
        }

        public void backupDone() {
            try {
                filesNotNeedingBackup.add(this.getTargetFile());
            }
            catch (IOException ioe) {
                throw new UnexpectedException(ioe, "getTargetFile should fail earlier");
            }
        }

        public File getTargetFile() throws IOException {
            if (!this.isCanonical) {
                this.outputFile = this.outputFile.getCanonicalFile();
                this.isCanonical = true;
            }
            return this.outputFile;
        }
    }

    public static interface FileSaver {
        public File getBackupFile() throws IOException;

        public boolean shouldBackup() throws IOException;

        public boolean continueWhenTempFileCreationFails();

        public void backupDone();

        public void saveTo(OutputStream var1) throws IOException;

        public File getTargetFile() throws IOException;
    }
}

