/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Frame;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionComponent<T>
implements Serializable {
    protected final Option<T> _option;
    protected final JLabel _label;
    protected final Frame _parent;
    private ArrayList<ChangeListener> _changeListeners = new ArrayList();

    public OptionComponent(Option<T> option, String labelText, Frame parent) {
        this._option = option;
        this._label = new JLabel(labelText);
        this._label.setHorizontalAlignment(4);
        this._parent = parent;
        if (option != null) {
            DrJava.getConfig().addOptionListener(option, new OptionListener<T>(){

                @Override
                public void optionChanged(OptionEvent<T> oe) {
                    OptionComponent.this.resetToCurrent();
                }
            });
        }
    }

    public OptionComponent(String labelText, Frame parent) {
        this(null, labelText, parent);
    }

    public Option<T> getOption() {
        return this._option;
    }

    public String getLabelText() {
        return this._label.getText();
    }

    public JLabel getLabel() {
        return this._label;
    }

    public abstract JComponent getComponent();

    public abstract void setDescription(String var1);

    public abstract boolean updateConfig();

    public void resetToCurrent() {
        if (this._option != null) {
            this.setValue(DrJava.getConfig().getSetting(this._option));
        }
    }

    public void resetToDefault() {
        if (this._option != null) {
            this.setValue(this._option.getDefault());
            this.notifyChangeListeners();
        }
    }

    public abstract void setValue(T var1);

    public void showErrorMessage(String title, OptionParseException e) {
        this.showErrorMessage(title, e.value, e.message);
    }

    public void showErrorMessage(String title, String value, String message) {
        JOptionPane.showMessageDialog(this._parent, new StringBuffer().append("There was an error in one of the options that you entered.\nOption: '").append(this.getLabelText()).append("'\n").append("Your value: '").append(value).append("'\n").append("Error: ").append(message).toString(), title, 2);
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove(listener);
    }

    protected void notifyChangeListeners() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                ChangeListener[] listeners;
                ChangeListener[] arr$ = listeners = OptionComponent.access$000(OptionComponent.this).toArray(new ChangeListener[OptionComponent.access$000(OptionComponent.this).size()]);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ChangeListener l = arr$[i$];
                    l.apply(this);
                }
            }
        });
    }

    static ArrayList access$000(OptionComponent x0) {
        return x0._changeListeners;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChangeListener
    extends Lambda<Object, Object> {
        @Override
        public Object apply(Object var1);
    }
}

