/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegionsTreePanel<R extends DocumentRegion>
extends TabbedPanel {
    protected JPanel _leftPane;
    protected DefaultMutableTreeNode _regionRootNode;
    protected DefaultTreeModel _regTreeModel;
    protected JTree _regTree;
    protected String _title;
    protected JPopupMenu _regionPopupMenu;
    protected final SingleDisplayModel _model;
    protected final MainFrame _frame;
    protected JPanel _buttonPanel;
    protected DefaultTreeCellRenderer dtcr;

    public RegionsTreePanel(MainFrame frame, String title) {
        super(frame, title);
        this._title = title;
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._model = frame.getModel();
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        this._leftPane = new JPanel(new BorderLayout());
        this._setupRegionTree();
        this.add((Component)this._leftPane, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        this._setupButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this.updateButtons();
        RegionsTreePanel._setColors(this._regTree);
    }

    private static void _setColors(Component c) {
        new ForegroundColorListener(c);
        new BackgroundColorListener(c);
    }

    @Override
    protected void _close() {
        super._close();
        this.updateButtons();
    }

    @Override
    public boolean requestFocusInWindow() {
        Runnable doCommand = new Runnable(){

            public void run() {
                Enumeration<TreeNode> documents = RegionsTreePanel.this._regionRootNode.children();
                boolean found = false;
                while (!found && documents.hasMoreElements()) {
                    DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
                    Enumeration<TreeNode> existingRegions = doc.children();
                    while (existingRegions.hasMoreElements()) {
                        DefaultMutableTreeNode existing = (DefaultMutableTreeNode)existingRegions.nextElement();
                        RegionsTreePanel.this._regTreeModel.nodeChanged(existing);
                    }
                    RegionsTreePanel.this._regTreeModel.nodeChanged(doc);
                }
                RegionsTreePanel.this.updateButtons();
            }
        };
        Utilities.invokeLater(doCommand);
        return super.requestFocusInWindow();
    }

    private void _setupRegionTree() {
        this._regionRootNode = new DefaultMutableTreeNode(this._title);
        this._regTreeModel = new DefaultTreeModel(this._regionRootNode);
        this._regTree = new RegionTree(this._regTreeModel);
        this._regTree.setEditable(false);
        this._regTree.getSelectionModel().setSelectionMode(4);
        this._regTree.setShowsRootHandles(true);
        this._regTree.setRootVisible(false);
        this._regTree.putClientProperty("JTree.lineStyle", "Angled");
        this._regTree.setScrollsOnExpand(true);
        this._regTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                RegionsTreePanel.this.updateButtons();
            }
        });
        this._regTree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RegionsTreePanel.this.performDefaultAction();
                }
            }
        });
        this.dtcr = new RegionRenderer(null);
        this.dtcr.setOpaque(false);
        RegionsTreePanel._setColors(this.dtcr);
        this._regTree.setCellRenderer(this.dtcr);
        this._leftPane.add(new JScrollPane(this._regTree));
        this._initPopup();
        ToolTipManager.sharedInstance().registerComponent(this._regTree);
    }

    protected void updateButtons() {
    }

    protected void performDefaultAction() {
    }

    protected JComponent[] makeButtons() {
        return new JComponent[0];
    }

    private void _setupButtonPanel() {
        JPanel mainButtons = new JPanel();
        JPanel emptyPanel = new JPanel();
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainButtons.setLayout(gbLayout);
        JComponent[] buts = this.makeButtons();
        closeButtonPanel.add((Component)this._closeButton, "North");
        for (JComponent b : buts) {
            mainButtons.add(b);
        }
        mainButtons.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        for (JComponent b : buts) {
            gbLayout.setConstraints(b, c);
        }
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        this._buttonPanel.add((Component)mainButtons, "Center");
        this._buttonPanel.add((Component)closeButtonPanel, "East");
    }

    protected AbstractAction[] makePopupMenuActions() {
        return null;
    }

    private void _initPopup() {
        this._regionPopupMenu = new JPopupMenu(this._title);
        AbstractAction[] acts = this.makePopupMenuActions();
        if (acts != null) {
            for (AbstractAction a : acts) {
                this._regionPopupMenu.add(a);
            }
            this._regTree.addMouseListener(new RegionMouseAdapter());
        }
    }

    protected ArrayList<R> getSelectedRegions() {
        ArrayList regs = new ArrayList();
        TreePath[] paths = this._regTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path == null || path.getPathCount() != 3) continue;
                DefaultMutableTreeNode lineNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object r = ((RegionTreeUserObj)lineNode.getUserObject()).region();
                regs.add(r);
            }
        }
        return regs;
    }

    protected void goToRegion() {
        ArrayList<R> r = this.getSelectedRegions();
        if (r.size() == 1) {
            this._frame.scrollToDocumentAndOffset(((DocumentRegion)r.get(0)).getDocument(), ((DocumentRegion)r.get(0)).getStartOffset(), false);
        }
    }

    public void addRegion(R r) {
        String name = "";
        try {
            name = r.getDocument().getQualifiedClassName();
        }
        catch (ClassNameNotFoundException cnnfe) {
            name = r.getDocument().toString();
        }
        DefaultMutableTreeNode regDocNode = new DefaultMutableTreeNode(name);
        Enumeration<TreeNode> documents = this._regionRootNode.children();
        boolean done = false;
        while (!done && documents.hasMoreElements()) {
            DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
            if (!doc.getUserObject().equals(regDocNode.getUserObject())) continue;
            Enumeration<TreeNode> existingRegions = doc.children();
            while (existingRegions.hasMoreElements()) {
                DefaultMutableTreeNode existing = (DefaultMutableTreeNode)existingRegions.nextElement();
                int ofs = r.getStartOffset();
                if (((RegionTreeUserObj)existing.getUserObject()).region().getStartOffset() == ofs) {
                    this._regTree.scrollPathToVisible(new TreePath(existing));
                    done = true;
                    break;
                }
                if (((RegionTreeUserObj)existing.getUserObject()).region().getStartOffset() <= ofs) continue;
                DefaultMutableTreeNode newRegion = new DefaultMutableTreeNode(this.makeRegionTreeUserObj(r));
                this._regTreeModel.insertNodeInto(newRegion, doc, doc.getIndex(existing));
                this._regTree.scrollPathToVisible(new TreePath(newRegion.getPath()));
                done = true;
                break;
            }
            if (done) break;
            DefaultMutableTreeNode newRegion = new DefaultMutableTreeNode(this.makeRegionTreeUserObj(r));
            this._regTreeModel.insertNodeInto(newRegion, doc, doc.getChildCount());
            this._regTree.scrollPathToVisible(new TreePath(newRegion.getPath()));
            done = true;
            break;
        }
        if (!done) {
            this._regTreeModel.insertNodeInto(regDocNode, this._regionRootNode, this._regionRootNode.getChildCount());
            DefaultMutableTreeNode newRegion = new DefaultMutableTreeNode(this.makeRegionTreeUserObj(r));
            this._regTreeModel.insertNodeInto(newRegion, regDocNode, regDocNode.getChildCount());
            TreePath pathToNewRegion = new TreePath(newRegion.getPath());
            this._regTree.scrollPathToVisible(pathToNewRegion);
        }
        this.updateButtons();
    }

    public void removeRegion(R r) {
        Runnable doCommand = new Runnable((DocumentRegion)r){
            final /* synthetic */ DocumentRegion val$r;
            {
                this.val$r = documentRegion;
            }

            public void run() {
                String name = "";
                try {
                    name = this.val$r.getDocument().getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    name = this.val$r.getDocument().toString();
                }
                DefaultMutableTreeNode regDocNode = new DefaultMutableTreeNode(name);
                Enumeration<TreeNode> documents = RegionsTreePanel.this._regionRootNode.children();
                boolean found = false;
                block2: while (!found && documents.hasMoreElements()) {
                    DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
                    if (!doc.getUserObject().equals(regDocNode.getUserObject())) continue;
                    Enumeration<TreeNode> existingRegions = doc.children();
                    while (existingRegions.hasMoreElements()) {
                        DefaultMutableTreeNode existing = (DefaultMutableTreeNode)existingRegions.nextElement();
                        if (((RegionTreeUserObj)existing.getUserObject()).region().getStartOffset() != this.val$r.getStartOffset()) continue;
                        RegionsTreePanel.this._regTreeModel.removeNodeFromParent(existing);
                        if (doc.getChildCount() == 0) {
                            RegionsTreePanel.this._regTreeModel.removeNodeFromParent(doc);
                        }
                        found = true;
                        continue block2;
                    }
                }
                RegionsTreePanel.this.updateButtons();
            }
        };
        Utilities.invokeLater(doCommand);
    }

    public void removeRegions(final OpenDefinitionsDocument odd) {
        Runnable doCommand = new Runnable(){

            public void run() {
                String name = "";
                try {
                    name = odd.getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    name = odd.toString();
                }
                DefaultMutableTreeNode regDocNode = new DefaultMutableTreeNode(name);
                Enumeration<TreeNode> documents = RegionsTreePanel.this._regionRootNode.children();
                while (documents.hasMoreElements()) {
                    DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
                    if (!doc.getUserObject().equals(regDocNode.getUserObject())) continue;
                    while (doc.getChildCount() > 0) {
                        DefaultMutableTreeNode existing = (DefaultMutableTreeNode)doc.getFirstChild();
                        Object r = ((RegionTreeUserObj)existing.getUserObject()).region();
                        RegionsTreePanel.this._regTreeModel.removeNodeFromParent(existing);
                    }
                    RegionsTreePanel.this._regTreeModel.removeNodeFromParent(doc);
                }
                RegionsTreePanel.this.updateButtons();
            }
        };
        Utilities.invokeLater(doCommand);
    }

    protected RegionTreeUserObj<R> makeRegionTreeUserObj(R r) {
        return new RegionTreeUserObj<R>(r);
    }

    static void access$100(Component x0) {
        RegionsTreePanel._setColors(x0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RegionTreeUserObj<R extends DocumentRegion> {
        protected R _region;

        public int lineNumber() {
            return this._region.getDocument().getLineOfOffset(this._region.getStartOffset()) + 1;
        }

        public R region() {
            return this._region;
        }

        public RegionTreeUserObj(R r) {
            this._region = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer sb = new StringBuffer();
            this._region.getDocument().acquireReadLock();
            try {
                sb.append(this.lineNumber());
                try {
                    sb.append(": ");
                    int length = Math.min(120, this._region.getEndOffset() - this._region.getStartOffset());
                    sb.append(this._region.getDocument().getText(this._region.getStartOffset(), length).trim());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            finally {
                this._region.getDocument().releaseReadLock();
            }
            return sb.toString();
        }

        public boolean equals(Object other) {
            RegionTreeUserObj o = (RegionTreeUserObj)other;
            return o.region().getDocument().equals(this.region().getDocument()) && o.region().getStartOffset() == this.region().getStartOffset() && o.region().getEndOffset() == this.region().getEndOffset();
        }
    }

    protected class RegionTree
    extends JTree {
        public RegionTree(DefaultTreeModel s) {
            super(s);
        }

        public void setForeground(Color c) {
            super.setForeground(c);
            if (RegionsTreePanel.this.dtcr != null) {
                RegionsTreePanel.this.dtcr.setTextNonSelectionColor(c);
            }
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            if (RegionsTreePanel.this != null && RegionsTreePanel.this.dtcr != null) {
                RegionsTreePanel.this.dtcr.setBackgroundNonSelectionColor(c);
            }
        }
    }

    protected class RegionMouseAdapter
    extends RightClickMouseAdapter {
        protected RegionMouseAdapter() {
        }

        protected void _popupAction(MouseEvent e) {
            int y;
            int x = e.getX();
            TreePath path = RegionsTreePanel.this._regTree.getPathForLocation(x, y = e.getY());
            if (path != null && path.getPathCount() == 3) {
                RegionsTreePanel.this._regTree.setSelectionRow(RegionsTreePanel.this._regTree.getRowForLocation(x, y));
                RegionsTreePanel.this._regionPopupMenu.show(e.getComponent(), x, y);
            }
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                RegionsTreePanel.this.performDefaultAction();
            }
        }
    }

    class RegionRenderer
    extends DefaultTreeCellRenderer {
        public void setBackground(Color c) {
            this.setBackgroundNonSelectionColor(c);
        }

        public void setForeground(Color c) {
            this.setTextNonSelectionColor(c);
        }

        private RegionRenderer() {
            this.setTextSelectionColor(Color.black);
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Component renderer = super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, leaf, row, hasFocus);
            if (renderer instanceof JComponent) {
                ((JComponent)renderer).setOpaque(false);
            }
            RegionsTreePanel.access$100(renderer);
            String tooltip = null;
            if (DrJava.getConfig().getSetting(OptionConstants.SHOW_CODE_PREVIEW_POPUPS).booleanValue() && leaf && (node = (DefaultMutableTreeNode)value).getUserObject() instanceof RegionTreeUserObj) {
                Object r = ((RegionTreeUserObj)node.getUserObject()).region();
                OpenDefinitionsDocument doc = r.getDocument();
                doc.acquireReadLock();
                try {
                    int rEnd;
                    int endOffset;
                    int lnr = doc.getLineOfOffset(r.getStartOffset()) + 1;
                    int startOffset = doc.getOffset(lnr - 3);
                    if (startOffset < 0) {
                        startOffset = 0;
                    }
                    if ((endOffset = doc.getOffset(lnr + 3)) < 0) {
                        endOffset = doc.getLength() - 1;
                    }
                    String s = doc.getText(startOffset, endOffset - startOffset);
                    int rStart = r.getStartOffset() - startOffset;
                    if (rStart < 0) {
                        rStart = 0;
                    }
                    if ((rEnd = r.getEndOffset() - startOffset) > s.length()) {
                        rEnd = s.length();
                    }
                    if (rStart <= s.length() && rEnd >= rStart) {
                        String t1 = StringOps.encodeHTML(s.substring(0, rStart));
                        String t2 = StringOps.encodeHTML(s.substring(rStart, rEnd));
                        String t3 = StringOps.encodeHTML(s.substring(rEnd));
                        s = t1 + "<font color=#ff0000>" + t2 + "</font>" + t3;
                    } else {
                        s = StringOps.encodeHTML(s);
                    }
                    tooltip = "<html><pre>" + s + "</pre></html>";
                }
                catch (BadLocationException ble) {
                    tooltip = null;
                }
                finally {
                    doc.releaseReadLock();
                }
                this.setText(node.getUserObject().toString());
                renderer = this;
            }
            this.setToolTipText(tooltip);
            return renderer;
        }

        RegionRenderer(1 x1) {
            this();
        }
    }
}

