/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.util.ClassPathVector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.FileChooser;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class ProjectPropertiesFrame
extends JFrame {
    private static final int FRAME_WIDTH = 503;
    private static final int FRAME_HEIGHT = 318;
    private MainFrame _mainFrame;
    private SingleDisplayModel _model;
    private File _projFile;
    private final JButton _okButton;
    private final JButton _applyButton;
    private final JButton _cancelButton;
    private JPanel _mainPanel;
    private DirectorySelectorComponent _projRootSelector;
    private DirectorySelectorComponent _buildDirSelector;
    private DirectorySelectorComponent _workDirSelector;
    private FileSelectorComponent _mainDocumentSelector;
    private FileSelectorComponent _jarFileSelector;
    private FileSelectorComponent _manifestFileSelector;
    private VectorFileOptionComponent _extraClassPathList;
    private DocumentListener _applyListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            this.setEnabled();
        }

        public void removeUpdate(DocumentEvent e) {
            this.setEnabled();
        }

        public void changedUpdate(DocumentEvent e) {
            this.setEnabled();
        }

        private void setEnabled() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectPropertiesFrame.access$000(ProjectPropertiesFrame.this).setEnabled(true);
                }
            });
        }
    };

    public ProjectPropertiesFrame(MainFrame mf) {
        super("Project Properties");
        this._mainFrame = mf;
        this._model = this._mainFrame.getModel();
        this._projFile = this._model.getProjectFile();
        this._mainPanel = new JPanel();
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                successful = ProjectPropertiesFrame.this.saveSettings();
                if (successful) {
                    ProjectPropertiesFrame.this.setVisible(false);
                }
                ProjectPropertiesFrame.this.reset();
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction applyAction = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesFrame.this.saveSettings();
                ProjectPropertiesFrame.this.reset();
            }
        };
        this._applyButton = new JButton(applyAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        this.init();
    }

    private void init() {
        this._setupPanel(this._mainPanel);
        JScrollPane scrollPane = new JScrollPane(this._mainPanel);
        Container cp = this.getContentPane();
        GridBagLayout cpLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(cpLayout);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        cpLayout.setConstraints(scrollPane, c);
        cp.add(scrollPane);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        c.fill = 0;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 0.0;
        cpLayout.setConstraints(bottom, c);
        cp.add(bottom);
        this.setSize(503, 318);
        MainFrame.setPopupLoc(this, this._mainFrame);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectPropertiesFrame.this.cancel();
            }
        });
        this.reset();
    }

    public void cancel() {
        this.reset();
        this._applyButton.setEnabled(false);
        this.setVisible(false);
    }

    public void reset() {
        this.reset(this._model.getProjectRoot());
    }

    private void reset(File projRoot) {
        this._projRootSelector.setFileField(projRoot);
        File bd = this._model.getBuildDirectory();
        JTextField bdTextField = this._buildDirSelector.getFileField();
        if (bd == null) {
            bdTextField.setText("");
        } else {
            this._buildDirSelector.setFileField(bd);
        }
        File wd = this._model.getWorkingDirectory();
        JTextField wdTextField = this._workDirSelector.getFileField();
        if (wd == null) {
            wdTextField.setText("");
        } else {
            this._workDirSelector.setFileField(wd);
        }
        File mc = this._model.getMainClass();
        JTextField mcTextField = this._mainDocumentSelector.getFileField();
        if (mc == null) {
            mcTextField.setText("");
        } else {
            this._mainDocumentSelector.setFileField(mc);
        }
        ClassPathVector cp = this._model.getExtraClassPath();
        this._extraClassPathList.setValue(cp.asFileVector());
        this._applyButton.setEnabled(false);
    }

    public boolean saveSettings() {
        boolean projRootChanged = false;
        File pr = this._projRootSelector.getFileFromField();
        if (this._projRootSelector.getFileField().getText().equals("")) {
            pr = null;
        }
        if (!pr.equals(this._model.getProjectRoot())) {
            this._model.setProjectRoot(pr);
            projRootChanged = true;
        }
        File bd = this._buildDirSelector.getFileFromField();
        if (this._buildDirSelector.getFileField().getText().equals("")) {
            bd = null;
        }
        this._model.setBuildDirectory(bd);
        File wd = this._workDirSelector.getFileFromField();
        if (this._workDirSelector.getFileField().getText().equals("")) {
            wd = null;
        }
        this._model.setWorkingDirectory(wd);
        File mc = this._mainDocumentSelector.getFileFromField();
        if (this._mainDocumentSelector.getFileField().getText().equals("")) {
            mc = null;
        }
        this._model.setMainClass(mc);
        Vector extras = this._extraClassPathList.getValue();
        ClassPathVector cpv = new ClassPathVector();
        Iterator i$ = extras.iterator();
        while (i$.hasNext()) {
            File cf = (File)i$.next();
            cpv.add(cf);
        }
        this._model.setExtraClassPath(cpv);
        if (projRootChanged) {
            try {
                this._model.reloadProject(this._mainFrame.getCurrentProject(), this._mainFrame.gatherProjectDocInfo());
            }
            catch (IOException e) {
                throw new UnexpectedException(e, "I/O error while reloading project");
            }
        }
        return true;
    }

    private File _getProjRoot() {
        File projRoot = this._mainFrame.getModel().getProjectRoot();
        if (projRoot != null) {
            return projRoot;
        }
        return FileOption.NULL_FILE;
    }

    private File _getBuildDir() {
        File buildDir = this._mainFrame.getModel().getBuildDirectory();
        if (buildDir != null) {
            return buildDir;
        }
        return FileOption.NULL_FILE;
    }

    private File _getWorkDir() {
        File workDir = this._mainFrame.getModel().getWorkingDirectory();
        if (workDir != null) {
            return workDir;
        }
        return FileOption.NULL_FILE;
    }

    private File _getMainFile() {
        File mainFile = this._mainFrame.getModel().getMainClass();
        if (mainFile != null) {
            return mainFile;
        }
        return FileOption.NULL_FILE;
    }

    private void _setupPanel(JPanel panel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel prLabel = new JLabel("Project Root");
        prLabel.setToolTipText("<html>The root directory for the project source files .<br>If not specified, the parent directory of the project file.</html>");
        gridbag.setConstraints(prLabel, c);
        panel.add(prLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel prPanel = this._projRootPanel();
        gridbag.setConstraints(prPanel, c);
        panel.add(prPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel bdLabel = new JLabel("Build Directory");
        bdLabel.setToolTipText("<html>The directory the class files will be compiled into.<br>If not specified, the class files will be compiled into<br>the same directory as their corresponding source files</html>");
        gridbag.setConstraints(bdLabel, c);
        panel.add(bdLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel bdPanel = this._buildDirectoryPanel();
        gridbag.setConstraints(bdPanel, c);
        panel.add(bdPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel wdLabel = new JLabel("Working Directory");
        wdLabel.setToolTipText("<html>The root directory for relative path names.</html>");
        gridbag.setConstraints(wdLabel, c);
        panel.add(wdLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel wdPanel = this._workDirectoryPanel();
        gridbag.setConstraints(wdPanel, c);
        panel.add(wdPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel classLabel = new JLabel("Main Document");
        classLabel.setToolTipText("<html>The project document containing the<br><code>main</code>method for the entire project</html>");
        gridbag.setConstraints(classLabel, c);
        panel.add(classLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel mainClassPanel = this._mainDocumentSelector();
        gridbag.setConstraints(mainClassPanel, c);
        panel.add(mainClassPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel extrasLabel = new JLabel("Extra Classpath");
        extrasLabel.setToolTipText("<html>The list of extra classpaths to load with the project.<br>This may include either JAR files or directories. Any<br>classes defined in these classpath locations will be <br>visible in the interactions pane and also accessible <br>by the compiler when compiling the project.</html>");
        gridbag.setConstraints(extrasLabel, c);
        panel.add(extrasLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        Component extrasComponent = this._extraClassPathComponent();
        gridbag.setConstraints(extrasComponent, c);
        panel.add(extrasComponent);
    }

    public JPanel _projRootPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        dirChooser.setSelectedFile(this._getProjRoot());
        dirChooser.setDialogTitle("Select Project Root Folder");
        dirChooser.setApproveButtonText("Select");
        this._projRootSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f);
        this._projRootSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._projRootSelector;
    }

    public JPanel _buildDirectoryPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        File bd = this._getBuildDir();
        if (bd == null || bd == FileOption.NULL_FILE) {
            bd = this._getProjRoot();
        }
        dirChooser.setSelectedFile(bd);
        dirChooser.setDialogTitle("Select Build Directory");
        dirChooser.setApproveButtonText("Select");
        this._buildDirSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f, false);
        this._buildDirSelector.setFileField(bd);
        this._buildDirSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._buildDirSelector;
    }

    public JPanel _workDirectoryPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        dirChooser.setSelectedFile(this._getWorkDir());
        dirChooser.setDialogTitle("Select Working Directory");
        dirChooser.setApproveButtonText("Select");
        this._workDirSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f);
        this._workDirSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._workDirSelector;
    }

    public Component _extraClassPathComponent() {
        this._extraClassPathList = new VectorFileOptionComponent(null, "Extra Project Classpaths", (Frame)this);
        this._extraClassPathList.addChangeListener(new OptionComponent.ChangeListener(){

            public Object apply(Object oc) {
                ProjectPropertiesFrame.access$000(ProjectPropertiesFrame.this).setEnabled(true);
                return null;
            }
        });
        return this._extraClassPathList.getComponent();
    }

    public JPanel _mainDocumentSelector() {
        final File projRoot = this._getProjRoot();
        FileChooser chooser = new FileChooser(projRoot);
        chooser.setFileSelectionMode(0);
        chooser.setDialogType(2);
        chooser.setDialogTitle("Select Main Document");
        chooser.setCurrentDirectory(projRoot);
        File mainFile = this._getMainFile();
        if (mainFile != FileOption.NULL_FILE) {
            chooser.setSelectedFile(mainFile);
        }
        chooser.setApproveButtonText("Select");
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                String name = f.getName();
                return FileOps.inFileTree(f, projRoot) && (f.isDirectory() || name.endsWith(".java") || name.endsWith(".dj0") || name.endsWith(".dj1") || name.endsWith(".dj2"));
            }

            public String getDescription() {
                return "Java & DrJava Files (*.java, *.dj0, *.dj1, *.dj2) in project";
            }
        };
        chooser.addChoosableFileFilter(filter);
        this._mainDocumentSelector = new FileSelectorComponent(this, chooser, 20, 12.0f);
        this._mainDocumentSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._mainDocumentSelector;
    }

    public JPanel _manifestFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._getProjRoot().getParentFile());
        fileChooser.setDialogTitle("Select Output jar File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        this._manifestFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f);
        this._manifestFileSelector.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._manifestFileSelector;
    }

    public JPanel _jarFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._getProjRoot());
        fileChooser.setDialogTitle("Select Manifest File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        this._jarFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f);
        this._jarFileSelector.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._jarFileSelector;
    }

    static JButton access$000(ProjectPropertiesFrame x0) {
        return x0._applyButton;
    }
}

