/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.ui.AbstractConsoleController;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.util.CompletionMonitor;
import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsController
extends AbstractConsoleController {
    private static final String INPUT_ENTERED_NAME = "Input Entered";
    private static final String INSERT_NEWLINE_NAME = "Insert Newline";
    public static final String INPUT_BOX_STYLE = "input.box.style";
    public static final String INPUT_BOX_SYMBOL = "[component]";
    private InteractionsModel _model;
    private InteractionsDocument _doc;
    private SimpleAttributeSet _errStyle;
    private final SimpleAttributeSet _debugStyle;
    private Lambda<String, String> _insertTextCommand;
    private Runnable _inputCompletionCommand;
    private Object _consoleInputCommandLock = new Object();
    private static final Lambda<String, String> _defaultInsertTextCommand = new Lambda<String, String>(){

        @Override
        public String apply(String input) {
            throw new UnsupportedOperationException("Cannot insert text. There is no console input in progress");
        }

        @Override
        public Object apply(Object x0) {
            return this.apply((String)x0);
        }
    };
    private static final Runnable _defaultInputCompletionCommand = new Runnable(){

        public void run() {
        }
    };
    protected InputListener _inputListener = new InputListener(){

        public String getConsoleInput() {
            final InputBox box = new InputBox();
            final CompletionMonitor completionMonitor = new CompletionMonitor();
            Runnable inputCompletionCommand = new Runnable(){

                public void run() {
                    InteractionsController.access$200(InteractionsController.this, InteractionsController.access$000(), InteractionsController.access$100());
                    box.dissableInputs();
                    completionMonitor.set();
                    InteractionsController.this._pane.setEditable(true);
                    InteractionsController.this._pane.setCaretPosition(InteractionsController.access$300(InteractionsController.this).getLength());
                    InteractionsController.this._pane.requestFocus();
                }
            };
            Lambda<String, String> insertTextCommand = box.makeInsertTextCommand();
            box.setInputCompletionCommand(inputCompletionCommand);
            InteractionsController.access$200(InteractionsController.this, inputCompletionCommand, insertTextCommand);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InteractionsController.this._pane.setEditable(true);
                    int pos = InteractionsController.access$300(InteractionsController.this).getPositionBeforePrompt();
                    InteractionsDocument interactionsDocument = InteractionsController.access$300(InteractionsController.this);
                    InteractionsController.access$300(InteractionsController.this);
                    interactionsDocument.insertBeforeLastPrompt(" ", "default");
                    MutableAttributeSet inputAttributes = InteractionsController.this._pane.getInputAttributes();
                    inputAttributes.removeAttributes(inputAttributes);
                    StyleConstants.setComponent(inputAttributes, box);
                    try {
                        DefaultStyledDocument.ElementSpec[] specs = new DefaultStyledDocument.ElementSpec[]{new DefaultStyledDocument.ElementSpec(inputAttributes, 3, InteractionsController.INPUT_BOX_SYMBOL.toCharArray(), 0, 11)};
                        InteractionsController.this._adapter.setDocStyle(InteractionsController.INPUT_BOX_STYLE, inputAttributes);
                        InteractionsController.access$300(InteractionsController.this).insertBeforeLastPrompt(InteractionsController.INPUT_BOX_SYMBOL, InteractionsController.INPUT_BOX_STYLE);
                    }
                    finally {
                        inputAttributes.removeAttributes(inputAttributes);
                    }
                    InteractionsDocument interactionsDocument2 = InteractionsController.access$300(InteractionsController.this);
                    InteractionsController.access$300(InteractionsController.this);
                    interactionsDocument2.insertBeforeLastPrompt("\n", "default");
                    box.setVisible(true);
                    box.requestFocus();
                    InteractionsController.this._pane.setEditable(false);
                }
            });
            InteractionsController.access$400(InteractionsController.this);
            completionMonitor.waitOne();
            String text = box.getText() + "\n";
            InteractionsController.access$500(InteractionsController.this, text);
            return text;
        }
    };
    private Vector<ConsoleStateListener> _consoleStateListeners;
    private InteractionsListener _viewListener = new InteractionsListener(){

        public void interactionStarted() {
        }

        public void interactionEnded() {
        }

        public void interactionErrorOccurred(int offset, int length) {
        }

        public void interpreterResetting() {
            Runnable command = new Runnable(){

                public void run() {
                    InteractionsController.this._adapter.clearColoring();
                    InteractionsController.this._pane.resetPrompts();
                }
            };
            Utilities.invokeLater(command);
        }

        public void interpreterReady(File wd) {
        }

        public void interpreterResetFailed(Throwable t) {
        }

        public void interpreterExited(int status) {
        }

        public void interpreterChanged(boolean inProgress) {
        }

        public void interactionIncomplete() {
        }

        public void slaveJVMUsed() {
        }
    };
    AbstractAction evalAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._adapter.inCommentBlock()) {
                Thread command = new Thread("Evaluating Interaction"){

                    public void run() {
                        InteractionsController.access$800(InteractionsController.this).interpretCurrentInteraction();
                    }
                };
                command.start();
            } else {
                InteractionsController.access$800(InteractionsController.this).addNewLine();
                InteractionsController.access$800(InteractionsController.this).interactionContinues();
            }
        }
    };
    AbstractAction historyPrevAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.access$300(InteractionsController.this).recallPreviousInteractionInHistory()) {
                    InteractionsController.this.moveToEnd();
                }
                if (!InteractionsController.access$900(InteractionsController.this)) {
                    InteractionsController.this.moveToPrompt();
                }
            }
        }
    };
    AbstractAction historyNextAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!(InteractionsController.this._busy() || !InteractionsController.access$300(InteractionsController.this).recallNextInteractionInHistory() && InteractionsController.access$900(InteractionsController.this))) {
                InteractionsController.this.moveToPrompt();
            }
        }
    };
    AbstractAction moveUpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.access$1000(InteractionsController.this, InteractionsController.access$300(InteractionsController.this).getPromptPos(), InteractionsController.this._pane.getCaretPosition())) {
                    InteractionsController.this.historyPrevAction.actionPerformed(e);
                } else {
                    InteractionsController.this.defaultUpAction.actionPerformed(e);
                    if (!InteractionsController.access$900(InteractionsController.this)) {
                        InteractionsController.this.moveToPrompt();
                    }
                }
            }
        }
    };
    AbstractAction moveDownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.access$1000(InteractionsController.this, InteractionsController.this._pane.getCaretPosition(), InteractionsController.this._adapter.getLength())) {
                    InteractionsController.this.historyNextAction.actionPerformed(e);
                } else {
                    InteractionsController.this.defaultDownAction.actionPerformed(e);
                }
            }
        }
    };
    Action defaultUpAction;
    Action defaultDownAction;
    AbstractAction historyReverseSearchAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                InteractionsController.access$300(InteractionsController.this).reverseSearchInteractionsInHistory();
                InteractionsController.this.moveToEnd();
            }
        }
    };
    AbstractAction historyForwardSearchAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                InteractionsController.access$300(InteractionsController.this).forwardSearchInteractionsInHistory();
                InteractionsController.this.moveToEnd();
            }
        }
    };
    AbstractAction moveLeftAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                int position = InteractionsController.this._pane.getCaretPosition();
                if (position < InteractionsController.access$300(InteractionsController.this).getPromptPos()) {
                    InteractionsController.this.moveToPrompt();
                } else if (position == InteractionsController.access$300(InteractionsController.this).getPromptPos()) {
                    InteractionsController.this.moveToEnd();
                } else {
                    InteractionsController.this._pane.setCaretPosition(position - 1);
                }
            }
        }
    };
    AbstractAction moveRightAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < InteractionsController.access$300(InteractionsController.this).getPromptPos()) {
                InteractionsController.this.moveToEnd();
            } else if (position >= InteractionsController.access$300(InteractionsController.this).getLength()) {
                InteractionsController.this.moveToPrompt();
            } else {
                InteractionsController.this._pane.setCaretPosition(position + 1);
            }
        }
    };
    AbstractAction prevWordAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int promptPos;
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < (promptPos = InteractionsController.access$300(InteractionsController.this).getPromptPos())) {
                InteractionsController.this.moveToPrompt();
            } else if (position == promptPos) {
                InteractionsController.this.moveToEnd();
            } else {
                InteractionsController.this._pane.getActionMap().get("caret-previous-word").actionPerformed(e);
            }
        }
    };
    AbstractAction nextWordAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int promptPos;
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < (promptPos = InteractionsController.access$300(InteractionsController.this).getPromptPos())) {
                InteractionsController.this.moveToEnd();
            } else if (position >= InteractionsController.access$300(InteractionsController.this).getLength()) {
                InteractionsController.this.moveToPrompt();
            } else {
                InteractionsController.this._pane.getActionMap().get("caret-next-word").actionPerformed(e);
            }
        }
    };

    public InteractionsController(final InteractionsModel model, InteractionsDJDocument adapter) {
        this(model, adapter, new InteractionsPane(adapter){

            public int getPromptPos() {
                return model.getDocument().getPromptPos();
            }
        });
    }

    public InteractionsController(InteractionsModel model, InteractionsDJDocument adapter, InteractionsPane pane) {
        super(adapter, pane);
        StyledEditorKit d = InteractionsPane.EDITOR_KIT;
        for (Action a : ((DefaultEditorKit)d).getActions()) {
            if (a.getValue("Name").equals("caret-up")) {
                this.defaultUpAction = a;
            }
            if (!a.getValue("Name").equals("caret-down")) continue;
            this.defaultDownAction = a;
        }
        this._model = model;
        this._doc = model.getDocument();
        this._errStyle = new SimpleAttributeSet();
        this._debugStyle = new SimpleAttributeSet();
        this._model.setInputListener(this._inputListener);
        this._model.addListener(this._viewListener);
        this._inputCompletionCommand = _defaultInputCompletionCommand;
        this._insertTextCommand = _defaultInsertTextCommand;
        this._consoleStateListeners = new Vector();
        this._init();
    }

    public void addConsoleStateListener(ConsoleStateListener listener) {
        this._consoleStateListeners.add(listener);
    }

    public void removeConsoleStateListener(ConsoleStateListener listener) {
        this._consoleStateListeners.remove(listener);
    }

    private void fireConsoleInputStarted() {
        for (ConsoleStateListener listener : this._consoleStateListeners) {
            listener.consoleInputStarted(this);
        }
    }

    private void fireConsoleInputCompleted(String text) {
        for (ConsoleStateListener listener : this._consoleStateListeners) {
            listener.consoleInputCompleted(text, this);
        }
    }

    public InputListener getInputListener() {
        return this._inputListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptConsoleInput() {
        Object object = this._consoleInputCommandLock;
        synchronized (object) {
            SwingUtilities.invokeLater(this._inputCompletionCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertConsoleText(String input) {
        Object object = this._consoleInputCommandLock;
        synchronized (object) {
            this._insertTextCommand.apply(input);
        }
    }

    public InteractionsModel getInteractionsModel() {
        return this._model;
    }

    @Override
    public ConsoleDocument getConsoleDoc() {
        return this._doc;
    }

    public InteractionsDocument getDocument() {
        return this._doc;
    }

    @Override
    protected void _addDocumentStyles() {
        super._addDocumentStyles();
        this._errStyle.addAttributes(this._defaultStyle);
        this._errStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_ERROR_COLOR));
        this._errStyle.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this._adapter.setDocStyle("error", this._errStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.INTERACTIONS_ERROR_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                InteractionsController.access$600(InteractionsController.this).addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
        this._debugStyle.addAttributes(this._defaultStyle);
        this._debugStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.DEBUG_MESSAGE_COLOR));
        this._debugStyle.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this._adapter.setDocStyle("debugger", this._debugStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_MESSAGE_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                InteractionsController.access$700(InteractionsController.this).addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
    }

    @Override
    protected void _updateStyles(AttributeSet newSet) {
        super._updateStyles(newSet);
        this._errStyle.addAttributes(newSet);
        StyleConstants.setBold(this._errStyle, true);
        this._debugStyle.addAttributes(newSet);
        StyleConstants.setBold(this._debugStyle, true);
    }

    @Override
    protected void _setupModel() {
        this._adapter.addDocumentListener(new AbstractConsoleController.CaretUpdateListener());
        this._doc.setBeep(this._pane.getBeep());
    }

    @Override
    protected void _setupView() {
        super._setupView();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this.evalAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), this.newLineAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(66, mask), this.clearCurrentAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(224, 0), this.moveUpAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), this.moveUpAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, mask), this.historyPrevAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(225, 0), this.moveDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), this.moveDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, mask), this.historyNextAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), this.historyReverseSearchAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), this.historyForwardSearchAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(226, 0), this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(227, 0), this.moveRightAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), this.moveRightAction);
        this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_WORD), this.prevWordAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_PREVIOUS_WORD, new OptionListener<KeyStroke>(){

            @Override
            public void optionChanged(OptionEvent<KeyStroke> oe) {
                InteractionsController.this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_WORD), InteractionsController.this.prevWordAction);
            }
        });
        this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_WORD), this.nextWordAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_NEXT_WORD, new OptionListener<KeyStroke>(){

            @Override
            public void optionChanged(OptionEvent<KeyStroke> oe) {
                InteractionsController.this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_WORD), InteractionsController.this.nextWordAction);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setConsoleInputCommands(Runnable inputCompletionCommand, Lambda<String, String> insertTextCommand) {
        Object object = this._consoleInputCommandLock;
        synchronized (object) {
            this._insertTextCommand = insertTextCommand;
            this._inputCompletionCommand = inputCompletionCommand;
        }
    }

    private boolean _shouldGoIntoHistory(int start, int end) {
        if (this._isCursorAfterPrompt() && end >= start) {
            String text = "";
            try {
                text = this._adapter.getText(start, end - start);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            if (text.indexOf("\n") != -1) {
                return false;
            }
        }
        return true;
    }

    private boolean _isCursorAfterPrompt() {
        return this._pane.getCaretPosition() >= this._doc.getPromptPos();
    }

    static Runnable access$000() {
        return _defaultInputCompletionCommand;
    }

    static Lambda access$100() {
        return _defaultInsertTextCommand;
    }

    static void access$200(InteractionsController x0, Runnable x1, Lambda x2) {
        x0._setConsoleInputCommands(x1, x2);
    }

    static InteractionsDocument access$300(InteractionsController x0) {
        return x0._doc;
    }

    static void access$400(InteractionsController x0) {
        x0.fireConsoleInputStarted();
    }

    static void access$500(InteractionsController x0, String x1) {
        x0.fireConsoleInputCompleted(x1);
    }

    static SimpleAttributeSet access$600(InteractionsController x0) {
        return x0._errStyle;
    }

    static SimpleAttributeSet access$700(InteractionsController x0) {
        return x0._debugStyle;
    }

    static InteractionsModel access$800(InteractionsController x0) {
        return x0._model;
    }

    static boolean access$900(InteractionsController x0) {
        return x0._isCursorAfterPrompt();
    }

    static boolean access$1000(InteractionsController x0, int x1, int x2) {
        return x0._shouldGoIntoHistory(x1, x2);
    }

    public static interface ConsoleStateListener
    extends EventListener {
        public void consoleInputStarted(InteractionsController var1);

        public void consoleInputCompleted(String var1, InteractionsController var2);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputBox
    extends JTextArea {
        private static final int BORDER_WIDTH = 1;
        private static final int INNER_BUFFER_WIDTH = 3;
        private static final int OUTER_BUFFER_WIDTH = 2;
        private Color _bgColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR);
        private Color _fgColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR);
        private Color _sysInColor = DrJava.getConfig().getSetting(OptionConstants.SYSTEM_IN_COLOR);
        private boolean _antiAliasText = DrJava.getConfig().getSetting(OptionConstants.TEXT_ANTIALIAS);

        public InputBox() {
            this.setForeground(this._sysInColor);
            this.setBackground(this._bgColor);
            this.setCaretColor(this._fgColor);
            this.setBorder(this._createBorder());
            this.setLineWrap(true);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.access$1102(InputBox.this, (Color)oe.value);
                    InputBox.this.setBorder(InputBox.access$1200(InputBox.this));
                    InputBox.this.setCaretColor((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.access$1302(InputBox.this, (Color)oe.value);
                    InputBox.this.setBorder(InputBox.access$1200(InputBox.this));
                    InputBox.this.setBackground((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_IN_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.access$1402(InputBox.this, (Color)oe.value);
                    InputBox.this.setForeground((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, new OptionListener<Boolean>(){

                @Override
                public void optionChanged(OptionEvent<Boolean> oce) {
                    InputBox.access$1502(InputBox.this, (Boolean)oce.value);
                    InputBox.this.repaint();
                }
            });
            AbstractAction newLineAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    InputBox.this.insert("\n", InputBox.this.getCaretPosition());
                }
            };
            InputMap im = this.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(10, 1), InteractionsController.INSERT_NEWLINE_NAME);
            ActionMap am = this.getActionMap();
            am.put(InteractionsController.INSERT_NEWLINE_NAME, newLineAction);
        }

        private Border _createBorder() {
            Border outerouter = BorderFactory.createLineBorder(this._bgColor, 2);
            Border outer = BorderFactory.createLineBorder(this._fgColor, 1);
            Border inner = BorderFactory.createLineBorder(this._bgColor, 3);
            CompoundBorder temp = BorderFactory.createCompoundBorder(outer, inner);
            return BorderFactory.createCompoundBorder(outerouter, temp);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this._antiAliasText && g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            super.paintComponent(g);
        }

        public void setInputCompletionCommand(final Runnable command) {
            InputMap im = this.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(10, 0), InteractionsController.INPUT_ENTERED_NAME);
            ActionMap am = this.getActionMap();
            am.put(InteractionsController.INPUT_ENTERED_NAME, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    command.run();
                }
            });
        }

        public Lambda<String, String> makeInsertTextCommand() {
            return new Lambda<String, String>(){

                @Override
                public String apply(String input) {
                    InputBox.this.insert(input, InputBox.this.getCaretPosition());
                    return input;
                }

                @Override
                public Object apply(Object x0) {
                    return this.apply((String)x0);
                }
            };
        }

        public void dissableInputs() {
            this.setEditable(false);
            ActionMap am = this.getActionMap();
            Action action = am.get(InteractionsController.INPUT_ENTERED_NAME);
            if (action != null) {
                action.setEnabled(false);
            }
            if ((action = am.get(InteractionsController.INSERT_NEWLINE_NAME)) != null) {
                action.setEnabled(false);
            }
            this.getCaret().setVisible(false);
        }

        static Color access$1102(InputBox x0, Color x1) {
            x0._fgColor = x1;
            return x0._fgColor;
        }

        static Border access$1200(InputBox x0) {
            return x0._createBorder();
        }

        static Color access$1302(InputBox x0, Color x1) {
            x0._bgColor = x1;
            return x0._bgColor;
        }

        static Color access$1402(InputBox x0, Color x1) {
            x0._sysInColor = x1;
            return x0._sysInColor;
        }

        static boolean access$1502(InputBox x0, boolean x1) {
            x0._antiAliasText = x1;
            return x0._antiAliasText;
        }
    }
}

