/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.DrJavaErrorPopup;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.UnexpectedException;
import java.util.ArrayList;
import javax.swing.JButton;

public class DrJavaErrorHandler {
    private static ArrayList<Throwable> _errors = new ArrayList();
    private static JButton _errorsButton;

    public static void setButton(JButton b) {
        _errorsButton = b;
    }

    public static JButton getButton() {
        return _errorsButton;
    }

    public static int getErrorCount() {
        return _errors.size();
    }

    public static Throwable getError(int index) {
        if (index >= 0 && index < _errors.size()) {
            return _errors.get(index);
        }
        return new UnexpectedException("Error in DrJavaErrorHandler");
    }

    public static void clearErrors() {
        _errors.clear();
    }

    public void handle(Throwable thrown) {
        System.out.println("Unhandled exception: " + thrown);
        DrJavaErrorHandler.record(thrown);
    }

    public static void record(Throwable thrown) {
        _errors.add(thrown);
        if (_errorsButton != null) {
            _errorsButton.setVisible(true);
        }
        if (_errors.size() == 1 && DrJava.getConfig().getSetting(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED).booleanValue()) {
            DrJavaErrorPopup popup = new DrJavaErrorPopup(DrJavaErrorWindow.getFrame(), thrown);
            MainFrame.setPopupLoc(popup, popup.getOwner());
            popup.setVisible(true);
        }
    }

    public static void log(String message) {
        DrJavaErrorHandler.record(new LoggedCondition(message));
    }

    public static class LoggedCondition
    extends Throwable {
        public LoggedCondition(String s) {
            super(s);
        }
    }
}

