/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.util.Pair;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DocFile
extends File {
    private Pair<Integer, Integer> _sel;
    private Pair<Integer, Integer> _scroll;
    private boolean _active;
    private String _package;
    private long _mod;

    public DocFile(File f) {
        this(f, null, null, false, null);
    }

    public DocFile(String pathname) {
        this(pathname, null, null, false, null);
    }

    public DocFile(String parent, String child) {
        this(parent, child, null, null, false, null);
    }

    public DocFile(String pathname, Pair<Integer, Integer> selection, Pair<Integer, Integer> scroll, boolean active, String srcRoot) {
        super(pathname);
        this.init(selection, scroll, active, srcRoot);
    }

    public DocFile(File f, Pair<Integer, Integer> selection, Pair<Integer, Integer> scroll, boolean active, String srcRoot) {
        super(f, "");
        this.init(selection, scroll, active, srcRoot);
    }

    public DocFile(String parent, String child, Pair<Integer, Integer> selection, Pair<Integer, Integer> scroll, boolean active, String srcRoot) {
        super(parent, child);
        this.init(selection, scroll, active, srcRoot);
    }

    private void init(Pair<Integer, Integer> selection, Pair<Integer, Integer> scroll, boolean active, String pack) {
        this._sel = selection;
        this._scroll = scroll;
        this._active = active;
        this._package = pack;
    }

    @Override
    public DocFile getAbsoluteFile() {
        if (this.isAbsolute()) {
            return this;
        }
        return new DocFile(super.getAbsoluteFile(), this._sel, this._scroll, this._active, this._package);
    }

    @Override
    public DocFile getCanonicalFile() throws IOException {
        return new DocFile(super.getCanonicalFile(), this._sel, this._scroll, this._active, this._package);
    }

    public Pair<Integer, Integer> getSelection() {
        return this._sel;
    }

    public void setSelection(Pair<Integer, Integer> sel) {
        this._sel = sel;
    }

    public void setSelection(int start, int end) {
        this._sel = new Pair<Integer, Integer>(new Integer(start), new Integer(end));
    }

    public Pair<Integer, Integer> getScroll() {
        return this._scroll;
    }

    public void setScroll(Pair<Integer, Integer> scroll) {
        this._scroll = scroll;
    }

    public void setScroll(int vert, int horiz) {
        this._scroll = new Pair<Integer, Integer>(new Integer(vert), new Integer(horiz));
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String pkg) {
        this._package = pkg;
    }

    public void setSavedModDate(long mod) {
        this._mod = mod;
    }

    public long getSavedModDate() {
        return this._mod;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this.getCanonicalFile();
    }

    @Override
    public File getAbsoluteFile() {
        return this.getAbsoluteFile();
    }
}

