/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.model.BrainClassLoader;
import edu.rice.cs.drjava.model.ClassPathEntry;
import edu.rice.cs.drjava.model.DeadClassLoader;
import edu.rice.cs.util.ClassPathVector;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathManager {
    private LinkedList<ClassPathEntry> projectCP = new LinkedList();
    private LinkedList<ClassPathEntry> buildCP = new LinkedList();
    private LinkedList<ClassPathEntry> projectFilesCP = new LinkedList();
    private LinkedList<ClassPathEntry> externalFilesCP = new LinkedList();
    private LinkedList<ClassPathEntry> extraCP = new LinkedList();

    public synchronized void addProjectCP(URL f) {
        this.projectCP.add(0, new ClassPathEntry(f));
    }

    public synchronized ClassPathEntry[] getProjectCP() {
        return this.projectCP.toArray(new ClassPathEntry[this.projectCP.size()]);
    }

    public synchronized void addBuildDirectoryCP(URL f) {
        this.buildCP.addFirst(new ClassPathEntry(f));
    }

    public synchronized ClassPathEntry[] getBuildDirectoryCP() {
        return this.buildCP.toArray(new ClassPathEntry[this.buildCP.size()]);
    }

    public synchronized void addProjectFilesCP(URL f) {
        this.projectFilesCP.addFirst(new ClassPathEntry(f));
    }

    public synchronized ClassPathEntry[] getProjectFilesCP() {
        return this.projectFilesCP.toArray(new ClassPathEntry[this.projectFilesCP.size()]);
    }

    public void addExternalFilesCP(URL f) {
        this.externalFilesCP.add(0, new ClassPathEntry(f));
    }

    public ClassPathEntry[] getExternalFilesCP() {
        return this.externalFilesCP.toArray(new ClassPathEntry[this.externalFilesCP.size()]);
    }

    public synchronized void addExtraCP(URL f) {
        this.extraCP.addFirst(new ClassPathEntry(f));
    }

    public ClassPathEntry[] getExtraCP() {
        return this.extraCP.toArray(new ClassPathEntry[this.extraCP.size()]);
    }

    public synchronized ClassLoader getClassLoader() {
        return new BrainClassLoader(this.buildClassLoader(this.projectCP), this.buildClassLoader(this.buildCP), this.buildClassLoader(this.projectFilesCP), this.buildClassLoader(this.externalFilesCP), this.buildClassLoader(this.extraCP));
    }

    private ClassLoader buildClassLoader(List<ClassPathEntry> locpe) {
        ClassLoader c = new DeadClassLoader();
        for (ClassPathEntry cpe : locpe) {
            c = cpe.getClassLoader(c);
        }
        return c;
    }

    public synchronized ClassPathVector getAugmentedClassPath() {
        ClassPathVector ret = new ClassPathVector();
        for (ClassPathEntry e : this.getProjectCP()) {
            ret.add(e.getEntry());
        }
        for (ClassPathEntry e : this.getBuildDirectoryCP()) {
            ret.add(e.getEntry());
        }
        for (ClassPathEntry e : this.getProjectFilesCP()) {
            ret.add(e.getEntry());
        }
        for (ClassPathEntry e : this.getExternalFilesCP()) {
            ret.add(e.getEntry());
        }
        for (ClassPathEntry e : this.getExtraCP()) {
            ret.add(e.getEntry());
        }
        return ret;
    }
}

