/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.ColoringView;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.EditDocumentException;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.AbstractDocument;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsDJDocument
extends AbstractDJDocument {
    private boolean _toClear = false;
    private List<Pair<Pair<Integer, Integer>, String>> _stylesList = new LinkedList<Pair<Pair<Integer, Integer>, String>>();

    @Override
    protected int startCompoundEdit() {
        return 0;
    }

    @Override
    protected void endCompoundEdit(int key) {
    }

    @Override
    protected void endLastCompoundEdit() {
    }

    @Override
    protected void addUndoRedo(AbstractDocument.DefaultDocumentEvent chng, Runnable undoCommand, Runnable doCommand) {
    }

    @Override
    protected void _styleChanged() {
    }

    @Override
    protected Indenter makeNewIndenter(int indentLevel) {
        return new Indenter(indentLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColoring(int start, int end, String style) {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            if (this._toClear) {
                this._stylesList.clear();
                this._toClear = false;
            }
            if (style != null) {
                this._stylesList.add(0, new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(new Integer(start), new Integer(end)), style));
            }
        }
    }

    List<Pair<Pair<Integer, Integer>, String>> getStylesList() {
        return this._stylesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setColoring(int point, Graphics g) {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            for (Pair<Pair<Integer, Integer>, String> p : this._stylesList) {
                Pair<Integer, Integer> loc = p.getFirst();
                if (loc.getFirst() > point || loc.getSecond() < point) continue;
                if (p.getSecond().equals("error")) {
                    g.setColor(ColoringView.ERROR_COLOR);
                    g.setFont(g.getFont().deriveFont(1));
                } else if (p.getSecond().equals("debugger")) {
                    g.setColor(ColoringView.DEBUGGER_COLOR);
                    g.setFont(g.getFont().deriveFont(1));
                } else if (p.getSecond().equals("System.out")) {
                    g.setColor(ColoringView.INTERACTIONS_SYSTEM_OUT_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.getSecond().equals("System.in")) {
                    g.setColor(ColoringView.INTERACTIONS_SYSTEM_IN_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.getSecond().equals("System.err")) {
                    g.setColor(ColoringView.INTERACTIONS_SYSTEM_ERR_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.getSecond().equals("object.return.style")) {
                    g.setColor(ColoringView.NORMAL_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.getSecond().equals("string.return.style")) {
                    g.setColor(ColoringView.DOUBLE_QUOTED_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.getSecond().equals("number.return.style")) {
                    g.setColor(ColoringView.NUMBER_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.getSecond().equals("character.return.style")) {
                    g.setColor(ColoringView.SINGLE_QUOTED_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoldFonts(int point, Graphics g) {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            for (Pair<Pair<Integer, Integer>, String> p : this._stylesList) {
                Pair<Integer, Integer> loc = p.getFirst();
                if (loc.getFirst() > point || loc.getSecond() < point) continue;
                if (p.getSecond().equals("error")) {
                    g.setFont(g.getFont().deriveFont(1));
                } else if (p.getSecond().equals("debugger")) {
                    g.setFont(g.getFont().deriveFont(1));
                } else {
                    g.setFont(ColoringView.MAIN_FONT);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearColoring() {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            this._toClear = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inCommentBlock() {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                boolean toReturn;
                this.resetReducedModelLocation();
                ReducedModelState state = this.stateAtRelLocation(this.getLength() - this._currentLocation);
                boolean bl = toReturn = state.equals(ReducedModelStates.INSIDE_BLOCK_COMMENT);
                return bl;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void appendExceptionResult(String exceptionClass, String message, String stackTrace, String styleName) {
        block11: {
            String c = exceptionClass;
            if (c.indexOf(46) != -1) {
                c = c.substring(c.lastIndexOf(46) + 1, c.length());
            }
            this.acquireWriteLock();
            try {
                String line;
                this.insertText(this.getLength(), new StringBuffer().append(c).append(": ").append(message).append("\n").toString(), styleName);
                if (stackTrace.trim().equals("")) break block11;
                BufferedReader reader = new BufferedReader(new StringReader(stackTrace));
                while ((line = reader.readLine()) != null) {
                    int colonLoc;
                    int closeLoc;
                    int openLoc = line.indexOf(40);
                    if (openLoc != -1 && (closeLoc = line.indexOf(41, openLoc + 1)) != -1 && (colonLoc = line.indexOf(58, openLoc + 1)) > openLoc && colonLoc < closeLoc) {
                        String lineNumStr = line.substring(colonLoc + 1, closeLoc);
                        try {
                            int lineNumber = Integer.parseInt(lineNumStr);
                            String fileName = line.substring(openLoc + 1, colonLoc);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    this.insertText(this.getLength(), line, styleName);
                    this.insertText(this.getLength(), "\n", styleName);
                }
            }
            catch (IOException ioe) {
                throw new UnexpectedException(ioe);
            }
            catch (EditDocumentException ble) {
                throw new UnexpectedException(ble);
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }
}

