/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.DummyCompilerListener;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitErrorModel;
import edu.rice.cs.drjava.model.junit.JUnitEventNotifier;
import edu.rice.cs.drjava.model.junit.JUnitListener;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.ClassPathVector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.text.SwingDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJUnitModel
implements JUnitModel,
JUnitModelCallback {
    private final JUnitEventNotifier _notifier = new JUnitEventNotifier();
    private final MainJVM _jvm;
    private final CompilerModel _compilerModel;
    private final GlobalModel _model;
    private JUnitErrorModel _junitErrorModel;
    private volatile boolean _testInProgress = false;
    private boolean _forceTestSuffix = false;
    private final Object _testLock = new Object();
    private final SwingDocument _junitDoc = new SwingDocument();

    public DefaultJUnitModel(MainJVM jvm, CompilerModel compilerModel, GlobalModel model) {
        this._jvm = jvm;
        this._compilerModel = compilerModel;
        this._model = model;
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], this._model, false);
    }

    @Override
    public void setForceTestSuffix(boolean b) {
        this._forceTestSuffix = b;
    }

    public boolean isTestInProgress() {
        return this._testInProgress;
    }

    @Override
    public void addListener(JUnitListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(JUnitListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public SwingDocument getJUnitDocument() {
        return this._junitDoc;
    }

    @Override
    public void junitAll() {
        this.junitDocs(this._model.getOpenDefinitionsDocuments());
    }

    @Override
    public void junitProject() {
        LinkedList<OpenDefinitionsDocument> lod = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument doc : this._model.getOpenDefinitionsDocuments()) {
            if (!doc.inProjectPath()) continue;
            lod.add(doc);
        }
        this.junitDocs(lod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void junitClasses(List<String> qualifiedClassnames, List<File> files) {
        Object object = this._compilerModel.getSlaveJVMLock();
        synchronized (object) {
            List<String> testClasses;
            Object object2 = this._testLock;
            synchronized (object2) {
                if (this._testInProgress) {
                    return;
                }
                this._testInProgress = true;
            }
            try {
                testClasses = this._jvm.findTestClasses(qualifiedClassnames, files);
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
            if (testClasses.isEmpty()) {
                this.nonTestCase(true);
                return;
            }
            this._notifier.junitClassesStarted();
            try {
                this._jvm.runTestSuite();
            }
            catch (Throwable t) {
                this._notifier.junitEnded();
                this._testInProgress = false;
                throw new UnexpectedException(t);
            }
        }
    }

    @Override
    public void junitDocs(List<OpenDefinitionsDocument> lod) {
        this.junitOpenDefDocs(lod, true);
    }

    @Override
    public void junit(OpenDefinitionsDocument doc) throws ClassNotFoundException, IOException {
        try {
            File testFile = doc.getFile();
            if (testFile == null) {
                this.nonTestCase(false);
                return;
            }
        }
        catch (FileMovedException fme) {
            // empty catch block
        }
        LinkedList<OpenDefinitionsDocument> lod = new LinkedList<OpenDefinitionsDocument>();
        lod.add(doc);
        this.junitOpenDefDocs(lod, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void junitOpenDefDocs(final List<OpenDefinitionsDocument> lod, final boolean allTests) {
        Object object = this._testLock;
        synchronized (object) {
            if (this._testInProgress) {
                return;
            }
            this._testInProgress = true;
        }
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], null, false);
        if (this._model.hasOutOfSyncDocuments() || this._model.hasModifiedDocuments()) {
            DummyCompilerListener testAfterCompile = new DummyCompilerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void compileEnded(File workDir, File[] excludedFiles) {
                    1 listenerThis;
                    block3: {
                        listenerThis = this;
                        try {
                            if (!DefaultJUnitModel.access$000(DefaultJUnitModel.this).hasOutOfSyncDocuments()) break block3;
                            JOptionPane.showMessageDialog(null, "All open source files must be compiled before running a unit test", "Must Compile All Before Testing", 0);
                            DefaultJUnitModel.this.nonTestCase(allTests);
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(listenerThis){
                                final /* synthetic */ CompilerListener val$listenerThis;
                                {
                                    this.val$listenerThis = compilerListener;
                                }

                                public void run() {
                                    DefaultJUnitModel.access$200(DefaultJUnitModel.this).removeListener(this.val$listenerThis);
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    DefaultJUnitModel.access$100(DefaultJUnitModel.this, lod, allTests);
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            this._notifier.compileBeforeJUnit(testAfterCompile);
        } else {
            this._rawJUnitOpenDefDocs(lod, allTests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _rawJUnitOpenDefDocs(List<OpenDefinitionsDocument> lod, boolean allTests) {
        File buildDir = this._model.getBuildDirectory();
        HashSet<String> openDocFiles = new HashSet<String>();
        HashMap<File, File> classDirsAndRoots = new HashMap<File, File>();
        for (OpenDefinitionsDocument doc : lod) {
            File sourceDir;
            if (!doc.isSourceFile()) continue;
            openDocFiles.add(doc.getCanonicalPath());
            String packagePath = doc.getPackageName().replace('.', File.separatorChar);
            File sourceRoot = doc.getSourceRoot();
            File buildRoot = buildDir == null ? sourceRoot : buildDir;
            File classFileDir = new File(new StringBuffer().append(FileOps.getCanonicalPath(buildRoot)).append(File.separator).append(packagePath).toString());
            File file = sourceDir = buildDir == null ? classFileDir : new File(new StringBuffer().append(FileOps.getCanonicalPath(sourceRoot)).append(File.separator).append(packagePath).toString());
            if (classDirsAndRoots.containsKey(classFileDir)) continue;
            classDirsAndRoots.put(classFileDir, sourceDir);
        }
        Set classDirs = classDirsAndRoots.keySet();
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<File> files = new ArrayList<File>();
        boolean isProject = this._model.isProjectActive();
        try {
            for (File dir : classDirs) {
                File[] listing = dir.listFiles();
                if (listing == null) continue;
                for (File entry : listing) {
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    if (this._forceTestSuffix) {
                        String noExtName = name.substring(0, name.length() - 6);
                        int indexOfLastDot = noExtName.lastIndexOf(46);
                        String simpleClassName = noExtName.substring(indexOfLastDot + 1);
                        if (isProject && !simpleClassName.endsWith("Test")) continue;
                    }
                    if (!entry.isFile()) continue;
                    try {
                        String sourceFileName;
                        JavaClass clazz = new ClassParser(entry.getCanonicalPath()).parse();
                        String className = clazz.getClassName();
                        int indexOfDot = className.lastIndexOf(46);
                        File rootDir = (File)classDirsAndRoots.get(dir);
                        String javaSourceFileName = new StringBuffer().append(rootDir.getCanonicalPath()).append(File.separator).append(clazz.getSourceFileName()).toString();
                        int indexOfExtDot = javaSourceFileName.lastIndexOf(46);
                        if (indexOfExtDot == -1) continue;
                        String strippedName = javaSourceFileName.substring(0, indexOfExtDot);
                        if (openDocFiles.contains(javaSourceFileName)) {
                            sourceFileName = javaSourceFileName;
                        } else if (openDocFiles.contains(new StringBuffer().append(strippedName).append(".dj0").toString())) {
                            sourceFileName = new StringBuffer().append(strippedName).append(".dj0").toString();
                        } else if (openDocFiles.contains(new StringBuffer().append(strippedName).append(".dj1").toString())) {
                            sourceFileName = new StringBuffer().append(strippedName).append(".dj1").toString();
                        } else {
                            if (!openDocFiles.contains(new StringBuffer().append(strippedName).append(".dj2").toString())) continue;
                            sourceFileName = new StringBuffer().append(strippedName).append(".dj2").toString();
                        }
                        File sourceFile = new File(sourceFileName);
                        classNames.add(className);
                        files.add(sourceFile);
                    }
                    catch (IOException e) {
                    }
                    catch (ClassFormatException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        Object object = this._compilerModel.getSlaveJVMLock();
        synchronized (object) {
            List<String> tests;
            try {
                tests = this._jvm.findTestClasses(classNames, files);
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
            if (tests == null || tests.isEmpty()) {
                this.nonTestCase(allTests);
                return;
            }
            try {
                this._notifier.junitStarted();
                this._jvm.runTestSuite();
            }
            catch (Throwable t) {
                this._notifier.junitEnded();
                this._testInProgress = false;
                throw new UnexpectedException(t);
            }
        }
    }

    @Override
    public JUnitErrorModel getJUnitErrorModel() {
        return this._junitErrorModel;
    }

    @Override
    public void resetJUnitErrors() {
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], this._model, false);
    }

    @Override
    public void nonTestCase(boolean isTestAll) {
        this._notifier.nonTestCase(isTestAll);
        this._testInProgress = false;
    }

    @Override
    public void classFileError(ClassFileError e) {
        this._notifier.classFileError(e);
    }

    @Override
    public void testSuiteStarted(int numTests) {
        this._notifier.junitSuiteStarted(numTests);
    }

    @Override
    public void testStarted(String testName) {
        this._notifier.junitTestStarted(testName);
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        this._notifier.junitTestEnded(testName, wasSuccessful, causedError);
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        this._junitErrorModel = new JUnitErrorModel(errors, this._model, true);
        this._notifier.junitEnded();
        this._testInProgress = false;
    }

    @Override
    public File getFileForClassName(String className) {
        return this._model.getSourceFile(new StringBuffer().append(className).append(".java").toString());
    }

    @Override
    public ClassPathVector getClassPath() {
        return this._jvm.getClassPath();
    }

    @Override
    public void junitJVMReady() {
        if (!this._testInProgress) {
            return;
        }
        JUnitError[] errors = new JUnitError[]{new JUnitError("Previous test suite was interrupted", true, "")};
        this._junitErrorModel = new JUnitErrorModel(errors, this._model, true);
        this._notifier.junitEnded();
        this._testInProgress = false;
    }

    static GlobalModel access$000(DefaultJUnitModel x0) {
        return x0._model;
    }

    static void access$100(DefaultJUnitModel x0, List x1, boolean x2) {
        x0._rawJUnitOpenDefDocs(x1, x2);
    }

    static CompilerModel access$200(DefaultJUnitModel x0) {
        return x0._compilerModel;
    }
}

