/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Gap;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelBrace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelComment;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import edu.rice.cs.util.UnexpectedException;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReducedModelControl
implements BraceReduction {
    ReducedModelBrace rmb = new ReducedModelBrace(this);
    ReducedModelComment rmc = new ReducedModelComment();
    int _offset;

    @Override
    public void insertChar(char ch) {
        this.rmb.insertChar(ch);
        this.rmc.insertChar(ch);
    }

    @Override
    public void move(int count) {
        try {
            this.rmb.move(count);
            this.rmc.move(count);
        }
        catch (IllegalArgumentException e) {
            this.resetLocation();
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void delete(int count) {
        this.rmb.delete(count);
        this.rmc.delete(count);
    }

    @Override
    public int balanceForward() {
        return this.rmb.balanceForward();
    }

    @Override
    public int balanceBackward() {
        return this.rmb.balanceBackward();
    }

    @Override
    public ReducedModelState moveWalkerGetState(int relDistance) {
        return this.rmc.moveWalkerGetState(relDistance);
    }

    @Override
    public void resetLocation() {
        this.rmc.resetWalkerLocationToCursor();
    }

    @Override
    public ReducedToken currentToken() {
        ReducedToken rmcToken = this.rmc.current();
        if (!rmcToken.isGap()) {
            return rmcToken;
        }
        ReducedToken rmbToken = this.rmb.current();
        if (!rmbToken.isGap()) {
            rmbToken.setState(this.rmc.getStateAtCurrent());
            return rmbToken;
        }
        int size = this.getSize(rmbToken, rmcToken);
        return new Gap(size, this.rmc.getStateAtCurrent());
    }

    @Override
    public ReducedModelState getStateAtCurrent() {
        return this.rmc.getStateAtCurrent();
    }

    String getType() {
        ReducedToken rmcToken = this.rmc.current();
        if (!rmcToken.isGap()) {
            return rmcToken.getType();
        }
        ReducedToken rmbToken = this.rmb.current();
        if (!rmbToken.isGap()) {
            return rmbToken.getType();
        }
        return "";
    }

    int getSize() {
        return this.getSize(this.rmb.current(), this.rmc.current());
    }

    int getSize(ReducedToken rmbToken, ReducedToken rmcToken) {
        int size;
        int rmb_offset = this.rmb.getBlockOffset();
        int rmc_offset = this.rmc.getBlockOffset();
        int rmb_size = rmbToken.getSize();
        int rmc_size = rmcToken.getSize();
        this._offset = rmb_offset < rmc_offset ? (size = rmb_offset) : (size = rmc_offset);
        size = rmb_size - rmb_offset < rmc_size - rmc_offset ? (size += rmb_size - rmb_offset) : (size += rmc_size - rmc_offset);
        return size;
    }

    void next() {
        if (this.rmc._cursor.atStart()) {
            this.rmc.next();
            this.rmb.next();
            return;
        }
        int size = this.getSize(this.rmb.current(), this.rmc.current());
        this.rmc.move(size - this._offset);
        this.rmb.move(size - this._offset);
    }

    void prev() {
        if (this.rmc._cursor.atEnd()) {
            this.rmc.prev();
            this.rmb.prev();
            if (this.rmc._cursor.atStart()) {
                return;
            }
            int size = this.rmc.current().getSize() < this.rmb.current().getSize() ? -this.rmc.current().getSize() : -this.rmb.current().getSize();
            this.rmc.next();
            this.rmb.next();
            this.move(size);
        } else if (this.rmb.getBlockOffset() < this.rmc.getBlockOffset()) {
            this.rmb.prev();
            int size = this.rmb.current().getSize() + this.rmb.getBlockOffset();
            this.rmb.next();
            if (size < this.rmc.getBlockOffset()) {
                this.move(-size);
            } else {
                this.move(-this.rmc.getBlockOffset());
            }
        } else if (this.rmb.getBlockOffset() == this.rmc.getBlockOffset()) {
            this.rmb.prev();
            this.rmc.prev();
            this.rmb.setBlockOffset(0);
            this.rmc.setBlockOffset(0);
        } else {
            this.rmc.prev();
            int size = this.rmc.current().getSize() + this.rmc.getBlockOffset();
            this.rmc.next();
            if (size < this.rmb.getBlockOffset()) {
                this.move(-size);
            } else {
                this.move(-this.rmb.getBlockOffset());
            }
        }
    }

    public ReducedToken prevItem() {
        int rmbOffset = this.rmb.getBlockOffset();
        int rmcOffset = this.rmc.getBlockOffset();
        this.prev();
        ReducedToken temp = this.currentToken();
        this.next();
        this.rmb.setBlockOffset(rmbOffset);
        this.rmc.setBlockOffset(rmcOffset);
        return temp;
    }

    public ReducedToken nextItem() {
        int rmbOffset = this.rmb.getBlockOffset();
        int rmcOffset = this.rmc.getBlockOffset();
        this.next();
        ReducedToken temp = this.currentToken();
        this.prev();
        this.rmb.setBlockOffset(rmbOffset);
        this.rmc.setBlockOffset(rmcOffset);
        return temp;
    }

    boolean atEnd() {
        return this.rmb._cursor.atEnd() || this.rmc._cursor.atEnd();
    }

    boolean atStart() {
        return this.rmb._cursor.atStart() || this.rmc._cursor.atStart();
    }

    int getBlockOffset() {
        if (this.rmb.getBlockOffset() < this.rmc.getBlockOffset()) {
            return this.rmb.getBlockOffset();
        }
        return this.rmc.getBlockOffset();
    }

    @Override
    public int absOffset() {
        return this.rmc.absOffset();
    }

    @Override
    public String simpleString() {
        return new StringBuffer().append("\n********\n").append(this.rmb.simpleString()).append("\n________\n").append(this.rmc.simpleString()).toString();
    }

    @Override
    public IndentInfo getIndentInformation() {
        IndentInfo braceInfo = new IndentInfo();
        this.rmc.getDistToPreviousNewline(braceInfo);
        this.rmb.getDistToEnclosingBrace(braceInfo);
        this.rmc.getDistToIndentNewline(braceInfo);
        this.rmb.getDistToEnclosingBraceCurrent(braceInfo);
        this.rmc.getDistToCurrentBraceNewline(braceInfo);
        return braceInfo;
    }

    @Override
    public int getDistToPreviousNewline(int relLoc) {
        return this.rmc.getDistToPreviousNewline(relLoc);
    }

    @Override
    public int getDistToNextNewline() {
        return this.rmc.getDistToNextNewline();
    }

    @Override
    public Vector<HighlightStatus> getHighlightStatus(int start, int length) {
        int requestEnd;
        int curState;
        int curLength;
        Vector<HighlightStatus> vec = new Vector<HighlightStatus>();
        TokenList.Iterator cursor = this.rmc._cursor._copy();
        int curLocation = start;
        if (cursor.atEnd() || cursor.atStart()) {
            curLength = length;
            curState = 0;
        } else {
            curLength = ((ReducedToken)cursor.current()).getSize() - this.rmc.getBlockOffset();
            curState = ((ReducedToken)cursor.current()).getHighlightState();
        }
        while (curLocation + curLength < start + length) {
            cursor.next();
            if (cursor.atEnd()) break;
            int nextState = ((ReducedToken)cursor.current()).getHighlightState();
            if (nextState == curState) {
                curLength += ((ReducedToken)cursor.current()).getSize();
                continue;
            }
            vec.add(new HighlightStatus(curLocation, curLength, curState));
            curLocation += curLength;
            curLength = ((ReducedToken)cursor.current()).getSize();
            curState = nextState;
        }
        if (curLocation + curLength > (requestEnd = start + length)) {
            curLength = requestEnd - curLocation;
        }
        vec.add(new HighlightStatus(curLocation, curLength, curState));
        cursor.dispose();
        return vec;
    }
}

