/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.Finalizable;
import edu.rice.cs.drjava.model.FinalizationEvent;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DocumentClosedListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsDocument
extends AbstractDJDocument
implements Finalizable<DefinitionsDocument> {
    public static Log _log = new Log("GlobalModel.txt", false);
    private static final int NO_COMMENT_OFFSET = 0;
    private static final int WING_COMMENT_OFFSET = 2;
    List<DocumentClosedListener> _closedListeners = new LinkedList<DocumentClosedListener>();
    private static final int UNDO_LIMIT = 1000;
    private static boolean _tabsRemoved = true;
    private volatile boolean _isModifiedSinceSave = false;
    private volatile boolean _classFileInSync = false;
    private volatile int _cachedLocation;
    private volatile int _cachedLineNum;
    private volatile int _cachedPrevLineLoc;
    private volatile int _cachedNextLineLoc;
    private volatile String _packageName;
    private volatile File _classFile;
    private volatile OpenDefinitionsDocument _odd;
    private CompoundUndoManager _undoManager;
    private final GlobalEventNotifier _notifier;
    private LinkedList<WeakReference<WrappedPosition>> _wrappedPosList;
    private List<FinalizationListener<DefinitionsDocument>> _finalizationListeners = new LinkedList<FinalizationListener<DefinitionsDocument>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentClosedListener(DocumentClosedListener l) {
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            this._closedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentClosedListener(DocumentClosedListener l) {
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            this._closedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this._removeIndenter();
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            for (DocumentClosedListener l : this._closedListeners) {
                l.close();
            }
            this._closedListeners = new LinkedList<DocumentClosedListener>();
        }
    }

    public DefinitionsDocument(Indenter indenter, GlobalEventNotifier notifier) {
        super(indenter);
        this._notifier = notifier;
        this._init();
        this.resetUndoManager();
    }

    public DefinitionsDocument(GlobalEventNotifier notifier) {
        this._notifier = notifier;
        this._init();
        this.resetUndoManager();
    }

    public DefinitionsDocument(GlobalEventNotifier notifier, CompoundUndoManager undoManager) {
        this._notifier = notifier;
        this._init();
        this._undoManager = undoManager;
    }

    @Override
    protected Indenter makeNewIndenter(int indentLevel) {
        return new Indenter(indentLevel);
    }

    private void _init() {
        this._odd = null;
        this._cachedLocation = 0;
        this._cachedLineNum = 1;
        this._cachedPrevLineLoc = -1;
        this._cachedNextLineLoc = -1;
        this._classFile = null;
        this._cacheInUse = false;
    }

    public void setOpenDefDoc(OpenDefinitionsDocument odd) {
        if (this._odd == null) {
            this._odd = odd;
        }
    }

    public OpenDefinitionsDocument getOpenDefDoc() {
        if (this._odd == null) {
            throw new IllegalStateException("The OpenDefinitionsDocument for this DefinitionsDocument has never been set");
        }
        return this._odd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _styleChanged() {
        this.acquireWriteLock();
        try {
            int length = this.getLength() - this._currentLocation;
            AbstractDocument.DefaultDocumentEvent evt = new AbstractDocument.DefaultDocumentEvent(this, this._currentLocation, length, DocumentEvent.EventType.CHANGE);
            this.fireChangedUpdate(evt);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public String getQualifiedClassName() throws ClassNameNotFoundException {
        return new StringBuffer().append(this._getPackageQualifier()).append(this.getMainClassName()).toString();
    }

    public String getQualifiedClassName(int pos) throws ClassNameNotFoundException {
        return new StringBuffer().append(this._getPackageQualifier()).append(this.getEnclosingTopLevelClassName(pos)).toString();
    }

    protected String _getPackageQualifier() {
        String packageName = "";
        try {
            packageName = this.getPackageName();
        }
        catch (InvalidPackageException invalidPackageException) {
            // empty catch block
        }
        if (packageName != null && !packageName.equals("")) {
            packageName = new StringBuffer().append(packageName).append(".").toString();
        }
        return packageName;
    }

    public void setClassFileInSync(boolean inSync) {
        this._classFileInSync = inSync;
    }

    public boolean getClassFileInSync() {
        return this._classFileInSync;
    }

    public void setCachedClassFile(File classFile) {
        this._classFile = classFile;
    }

    public File getCachedClassFile() {
        return this._classFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.acquireWriteLock();
        try {
            if (_tabsRemoved) {
                str = DefinitionsDocument._removeTabs(str);
            }
            this.setModifiedSinceSave();
            super.insertString(offset, str, a);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offset, int len) throws BadLocationException {
        if (len == 0) {
            return;
        }
        this.acquireWriteLock();
        try {
            this.setModifiedSinceSave();
            super.remove(offset, len);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    static String _removeTabs(String source) {
        return source.replace('\t', ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModifiedSinceSave() {
        this.acquireWriteLock();
        try {
            this._isModifiedSinceSave = this._undoManager.isModified();
        }
        finally {
            if (!this._isModifiedSinceSave && this._odd != null) {
                this._odd.documentReset();
            }
            this.releaseWriteLock();
        }
    }

    private void setModifiedSinceSave() {
        if (!this._isModifiedSinceSave) {
            this._isModifiedSinceSave = true;
            this._classFileInSync = false;
            if (this._odd != null) {
                this._odd.documentModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModification() {
        this.acquireWriteLock();
        try {
            this._isModifiedSinceSave = false;
            this._undoManager.documentSaved();
        }
        finally {
            if (this._odd != null) {
                this._odd.documentReset();
            }
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModifiedSinceSave() {
        this.acquireReadLock();
        try {
            boolean bl = this._isModifiedSinceSave;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public int getCurrentCol() {
        int here = this._currentLocation;
        int startOfLine = this.getLineStartPos(here);
        return here - startOfLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentLine() {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int here = this._currentLocation;
                if (this._cachedLocation > this.getLength()) {
                    this._cachedLocation = 0;
                    this._cachedLineNum = 1;
                }
                if (this._cachedNextLineLoc > this.getLength()) {
                    this._cachedNextLineLoc = -1;
                }
                if (this._cachedPrevLineLoc >= here || here >= this._cachedNextLineLoc) {
                    if (this._cachedLocation - here > here) {
                        this._cachedLocation = 0;
                        this._cachedLineNum = 1;
                    }
                    int lineOffset = this._getRelativeLine();
                    this._cachedLineNum += lineOffset;
                }
                this._cachedLocation = here;
                this._cachedPrevLineLoc = this.getLineStartPos(here);
                this._cachedNextLineLoc = this.getLineEndPos(here);
                int n = this._cachedLineNum;
                return n;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    private int _getRelativeLine() {
        int count = 0;
        int currLoc = this._currentLocation;
        this.setCurrentLocation(this._cachedLocation);
        if (this._cachedLocation > currLoc) {
            int prevLineLoc = this.getLineStartPos(this._cachedLocation);
            while (prevLineLoc > currLoc) {
                --count;
                prevLineLoc = this.getLineStartPos(prevLineLoc - 1);
            }
        } else {
            int nextLineLoc = this.getLineEndPos(this._cachedLocation);
            while (nextLineLoc < currLoc) {
                ++count;
                nextLineLoc = this.getLineEndPos(nextLineLoc + 1);
            }
        }
        this.setCurrentLocation(currLoc);
        return count;
    }

    public int getOffset(int lineNum) {
        if (lineNum < 0) {
            return -1;
        }
        String defsText = this.getText();
        int curLine = 1;
        int offset = 0;
        while (offset < defsText.length()) {
            if (curLine == lineNum) {
                return offset;
            }
            int nextNewline = defsText.indexOf(10, offset);
            if (nextNewline == -1) {
                return -1;
            }
            ++curLine;
            offset = nextNewline + 1;
        }
        return -1;
    }

    public boolean tabsRemoved() {
        return _tabsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commentLines(int selStart, int selEnd) {
        int toReturn;
        block9: {
            toReturn = selEnd;
            if (selStart == selEnd) {
                this.acquireWriteLock();
                try {
                    BraceReduction braceReduction = this._reduced;
                    synchronized (braceReduction) {
                        this.setCurrentLocation(selStart);
                        Position oldCurrentPosition = this.createPosition(this._currentLocation);
                        this._commentLine();
                        toReturn += 2;
                        break block9;
                    }
                }
                catch (BadLocationException e) {
                    throw new UnexpectedException(e);
                }
                finally {
                    this.releaseWriteLock();
                }
            }
            toReturn = this._commentBlock(selStart, selEnd);
        }
        this._undoManager.endLastCompoundEdit();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _commentBlock(int start, int end) {
        int afterCommentEnd = end;
        this.acquireWriteLock();
        try {
            Position endPos = this.createPosition(end);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
                    this.setCurrentLocation(walker);
                    Position walkerPos = this.createPosition(walker);
                    this._commentLine();
                    afterCommentEnd += 2;
                    this.setCurrentLocation(walkerPos.getOffset());
                    walker = walkerPos.getOffset();
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
        return afterCommentEnd;
    }

    private void _commentLine() {
        try {
            this.insertString(this._currentLocation - this.getCurrentCol(), "//", null);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uncommentLines(int selStart, int selEnd) {
        int toReturn;
        block9: {
            toReturn = selEnd;
            if (selStart == selEnd) {
                this.acquireWriteLock();
                try {
                    BraceReduction braceReduction = this._reduced;
                    synchronized (braceReduction) {
                        this.setCurrentLocation(selStart);
                        Position oldCurrentPosition = this.createPosition(this._currentLocation);
                        this._uncommentLine();
                        toReturn -= 2;
                        break block9;
                    }
                }
                catch (BadLocationException e) {
                    throw new UnexpectedException(e);
                }
                finally {
                    this.releaseWriteLock();
                }
            }
            toReturn = this._uncommentBlock(selStart, selEnd);
        }
        this._undoManager.endLastCompoundEdit();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _uncommentBlock(int start, int end) {
        int afterUncommentEnd = end;
        this.acquireWriteLock();
        try {
            Position endPos = this.createPosition(end);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
                    this.setCurrentLocation(walker);
                    Position walkerPos = this.createPosition(walker);
                    afterUncommentEnd -= this._uncommentLine();
                    this.setCurrentLocation(walkerPos.getOffset());
                    walker = walkerPos.getOffset();
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
        return afterUncommentEnd;
    }

    private int _uncommentLine() throws BadLocationException {
        int curCol = this.getCurrentCol();
        int lineStart = this._currentLocation - curCol;
        String text = this.getText(lineStart, curCol + this._reduced.getDistToNextNewline());
        int pos = text.indexOf("//");
        boolean goodWing = true;
        for (int i = pos - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == ' ') continue;
            goodWing = false;
            return 0;
        }
        if (pos >= 0 && goodWing) {
            this.remove(lineStart + pos, 2);
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoLine(int line) {
        if (line < 0) {
            return;
        }
        int actualLine = 1;
        this.acquireReadLock();
        int len = this.getLength();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.setCurrentLocation(0);
                for (int i = 1; i < line && this._currentLocation < len; ++i) {
                    int dist = this._reduced.getDistToNextNewline();
                    if (this._currentLocation + dist < len) {
                        ++dist;
                    }
                    ++actualLine;
                    this.move(dist);
                }
                this._cachedLineNum = actualLine;
                this._cachedLocation = this._currentLocation;
                this._cachedPrevLineLoc = this.getLineStartPos(this._currentLocation);
                this._cachedNextLineLoc = this.getLineEndPos(this._currentLocation);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _findNextOpenSquiggly(String text, int pos) throws BadLocationException {
        int i;
        int reducedPos = pos;
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int origLocation = this._currentLocation;
            this._reduced.move(pos - origLocation);
            i = text.indexOf(123, reducedPos);
            while (i > -1) {
                this._reduced.move(i - reducedPos);
                reducedPos = i;
                ReducedModelState state = this._reduced.getStateAtCurrent();
                if (state.equals(ReducedModelState.FREE) && !DefinitionsDocument._isStartOfComment(text, i) && (i <= 0 || !DefinitionsDocument._isStartOfComment(text, i - 1))) break;
                i = text.indexOf(123, reducedPos + 1);
            }
            this._reduced.move(origLocation - reducedPos);
        }
        if (i == -1) {
            reducedPos = -1;
        }
        return reducedPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _findPrevKeyword(String text, String kw, int pos) throws BadLocationException {
        int i;
        int reducedPos = pos;
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int origLocation = this._currentLocation;
            this._reduced.move(pos - origLocation);
            i = text.lastIndexOf(kw, reducedPos);
            while (i > -1) {
                if (i > 0 && Character.isJavaIdentifierPart(text.charAt(i - 1))) {
                    i = text.lastIndexOf(kw, i - 1);
                    continue;
                }
                if (i + kw.length() < text.length() && Character.isJavaIdentifierPart(text.charAt(i + kw.length()))) {
                    i = text.lastIndexOf(kw, i - 1);
                    continue;
                }
                this._reduced.move(i - reducedPos);
                reducedPos = i;
                ReducedModelState state = this._reduced.getStateAtCurrent();
                if (state.equals(ReducedModelState.FREE) && !DefinitionsDocument._isStartOfComment(text, i) && (i <= 0 || !DefinitionsDocument._isStartOfComment(text, i - 1))) break;
                i = text.lastIndexOf(kw, reducedPos - 1);
            }
            this._reduced.move(origLocation - reducedPos);
        }
        if (i == -1) {
            reducedPos = -1;
        }
        return reducedPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnclosingClassName(int pos, boolean qual) throws BadLocationException, ClassNameNotFoundException {
        String pn;
        StringBuffer keyBuf = new StringBuffer("getEnclosingClassName:").append(pos);
        keyBuf.append(":").append(qual);
        String key = keyBuf.toString();
        String cached = (String)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        char[] delims = new char[]{'{', '}', '(', ')', '[', ']', '+', '-', '/', '*', ';', ':', '=', '!', '@', '#', '$', '%', '^', '~', '\\', '\"', '`', '|'};
        String name = "";
        this.acquireReadLock();
        try {
            String text = this.getText(0, pos + 1);
            int curPos = pos;
            do {
                int openParenPos;
                if (text.charAt(curPos) != '{' || text.charAt(curPos) != '}') {
                    ++curPos;
                }
                if ((curPos = this.findPrevEnclosingBrace(curPos, '{', '}')) == -1) {
                    break;
                }
                int classPos = this._findPrevKeyword(text, "class", curPos);
                int interPos = this._findPrevKeyword(text, "interface", curPos);
                int otherPos = this.findPrevDelimiter(curPos, delims);
                int newPos = -1;
                int closeParenPos = this.findPrevNonWSCharPos(curPos);
                if (closeParenPos != -1 && text.charAt(closeParenPos) == ')' && (openParenPos = this.findPrevEnclosingBrace(closeParenPos, '(', ')')) != -1 && text.charAt(openParenPos) == '(' && !this._isAnonymousInnerClass(newPos = this._findPrevKeyword(text, "new", openParenPos), curPos)) {
                    newPos = -1;
                }
                while (classPos != -1 || interPos != -1 || newPos != -1) {
                    if (newPos != -1) {
                        classPos = -1;
                        interPos = -1;
                        break;
                    }
                    if (otherPos > classPos && otherPos > interPos) {
                        if (text.charAt(otherPos) != '{' || text.charAt(otherPos) != '}') {
                            ++otherPos;
                        }
                        curPos = this.findPrevEnclosingBrace(otherPos, '{', '}');
                        classPos = this._findPrevKeyword(text, "class", curPos);
                        interPos = this._findPrevKeyword(text, "interface", curPos);
                        otherPos = this.findPrevDelimiter(curPos, delims);
                        newPos = -1;
                        closeParenPos = this.findPrevNonWSCharPos(curPos);
                        if (closeParenPos == -1 || text.charAt(closeParenPos) != ')' || (openParenPos = this.findPrevEnclosingBrace(closeParenPos, '(', ')')) == -1 || text.charAt(openParenPos) != '(' || this._isAnonymousInnerClass(newPos = this._findPrevKeyword(text, "new", openParenPos), curPos)) continue;
                        newPos = -1;
                        continue;
                    }
                    curPos = Math.max(classPos, Math.max(interPos, newPos));
                    break;
                }
                if (classPos != -1 || interPos != -1) {
                    int nameEnd;
                    curPos = classPos > interPos ? (curPos += "class".length()) : (curPos += "interface".length());
                    int nameStart = this.getFirstNonWSCharPos(curPos);
                    if (nameStart == -1) {
                        throw new ClassNameNotFoundException("Cannot determine enclosing class name");
                    }
                    for (nameEnd = nameStart + 1; nameEnd < text.length() && (Character.isJavaIdentifierPart(text.charAt(nameEnd)) || text.charAt(nameEnd) == '.'); ++nameEnd) {
                    }
                    name = new StringBuffer().append(text.substring(nameStart, nameEnd)).append('$').append(name).toString();
                    continue;
                }
                if (newPos == -1) break;
                name = new StringBuffer().append(String.valueOf(this._getAnonymousInnerClassIndex(curPos))).append("$").append(name).toString();
                curPos = newPos;
            } while (qual);
        }
        finally {
            this.releaseReadLock();
        }
        if (name.length() > 0) {
            name = name.substring(0, name.length() - 1);
        }
        if (qual && (pn = this.getPackageName()).length() > 0 && name.length() > 0) {
            name = new StringBuffer().append(this.getPackageName()).append(".").append(name).toString();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isAnonymousInnerClass(int newPos, int openSquigglyPos) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("_getAnonymousInnerClassIndex:").append(newPos).append(':').append(openSquigglyPos);
        String key = keyBuf.toString();
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        cached = Autobox.valueOf(false);
        String text = this.getText(0, openSquigglyPos + 1);
        int origNewPos = newPos;
        int classStart = this.getFirstNonWSCharPos(newPos += "new".length());
        if (classStart != -1) {
            int origParenStart;
            int classEnd;
            for (classEnd = classStart + 1; classEnd < text.length() && (Character.isJavaIdentifierPart(text.charAt(classEnd)) || text.charAt(classEnd) == '.'); ++classEnd) {
            }
            int parenStart = this.getFirstNonWSCharPos(classEnd);
            if (parenStart != -1 && text.charAt(origParenStart = parenStart) == '<') {
                parenStart = -1;
                int closePointyBracket = this.findNextEnclosingBrace(origParenStart, '<', '>');
                if (closePointyBracket != -1 && text.charAt(closePointyBracket) == '>') {
                    parenStart = this.getFirstNonWSCharPos(closePointyBracket + 1);
                }
            }
            if (parenStart != -1 && text.charAt(parenStart) == '(') {
                BraceReduction braceReduction = this._reduced;
                synchronized (braceReduction) {
                    int origLocation = this._currentLocation;
                    this._reduced.move(parenStart + 1 - origLocation);
                    int parenEnd = this.balanceForward();
                    this._reduced.move(origLocation - (parenStart + 1));
                    if (parenEnd > -1) {
                        int afterParen = this.getFirstNonWSCharPos(parenEnd = parenEnd + parenStart + 1);
                        cached = Autobox.valueOf(afterParen == openSquigglyPos);
                    }
                }
            }
        }
        this._storeInCache(key, cached);
        return cached;
    }

    public String getPackageName() {
        try {
            return this.getStrictPackageName();
        }
        catch (InvalidPackageException e) {
            return "";
        }
    }

    int _getAnonymousInnerClassIndex(int pos) throws BadLocationException, ClassNameNotFoundException {
        StringBuffer keyBuf = new StringBuffer("_getAnonymousInnerClassIndex:").append(pos);
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        char[] delims = new char[]{'{', '}', '(', ')', '[', ']', '+', '-', '/', '*', ';', ':', '=', '!', '@', '#', '$', '%', '^', '~', '\\', '\"', '`', '|'};
        String className = this.getEnclosingClassName(--pos, true);
        String text = this.getText(0, pos);
        int index = 1;
        int newPos = pos;
        while ((newPos = this._findPrevKeyword(text, "new", newPos - 1)) != -1) {
            int parenEnd;
            int nextOpenSquiggly;
            int classEnd;
            int afterNewPos = newPos + "new".length();
            int classStart = this.getFirstNonWSCharPos(afterNewPos);
            if (classStart == -1) continue;
            for (classEnd = classStart + 1; classEnd < text.length() && (Character.isJavaIdentifierPart(text.charAt(classEnd)) || text.charAt(classEnd) == '.'); ++classEnd) {
            }
            int parenStart = this.getFirstNonWSCharPos(classEnd);
            if (parenStart == -1) continue;
            int origParenStart = parenStart;
            if (text.charAt(origParenStart) == '<') {
                parenStart = -1;
                int closePointyBracket = this.findNextEnclosingBrace(origParenStart, '<', '>');
                if (closePointyBracket != -1 && text.charAt(closePointyBracket) == '>') {
                    parenStart = this.getFirstNonWSCharPos(closePointyBracket + 1);
                }
            }
            if (parenStart == -1 || text.charAt(parenStart) != '(' || (nextOpenSquiggly = this._findNextOpenSquiggly(text, parenEnd = this.findNextEnclosingBrace(parenStart, '(', ')'))) == -1 || !this._isAnonymousInnerClass(newPos, nextOpenSquiggly)) continue;
            String cn = this.getEnclosingClassName(newPos, true);
            if (!cn.startsWith(className)) break;
            if (!cn.equals(className)) {
                newPos = this.findPrevEnclosingBrace(newPos, '{', '}');
                continue;
            }
            ++index;
        }
        this._storeInCache(key, new Integer(index));
        return index;
    }

    /*
     * Exception decompiling
     */
    protected String getStrictPackageName() throws InvalidPackageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getEnclosingTopLevelClassName(int pos) throws ClassNameNotFoundException {
        this.acquireReadLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int oldLocation = this._currentLocation;
            try {
                this.setCurrentLocation(pos);
                IndentInfo info = this.getIndentInformation();
                int topLevelBracePos = -1;
                String braceType = info.braceTypeCurrent;
                while (!braceType.equals("")) {
                    if (braceType.equals("{")) {
                        topLevelBracePos = this._currentLocation - info.distToBraceCurrent;
                    }
                    this.move(-info.distToBraceCurrent);
                    info = this.getIndentInformation();
                    braceType = info.braceTypeCurrent;
                }
                if (topLevelBracePos == -1) {
                    this.setCurrentLocation(oldLocation);
                    throw new ClassNameNotFoundException("no top level brace found");
                }
                char[] delims = new char[]{'{', '}', ';'};
                int prevDelimPos = this.findPrevDelimiter(topLevelBracePos, delims);
                prevDelimPos = prevDelimPos == -1 ? 0 : ++prevDelimPos;
                this.setCurrentLocation(oldLocation);
                String string = this.getNextTopLevelClassName(prevDelimPos, topLevelBracePos);
                return string;
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            finally {
                this.setCurrentLocation(oldLocation);
                this.releaseReadLock();
            }
        }
    }

    private String getFirstClassName(int indexOfClass, int indexOfInterface) throws ClassNameNotFoundException {
        if (indexOfClass == -1 && indexOfInterface == -1) {
            throw ClassNameNotFoundException.DEFAULT;
        }
        if (indexOfInterface == -1 || indexOfClass != -1 && indexOfClass < indexOfInterface) {
            return this.getNextIdentifier(indexOfClass + "class".length());
        }
        return this.getNextIdentifier(indexOfInterface + "interface".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMainClassName() throws ClassNameNotFoundException {
        this.acquireReadLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int oldLocation = this._currentLocation;
            try {
                int indexOfPublicInterface;
                this.setCurrentLocation(0);
                String text = this.getText();
                int indexOfClass = this._findKeywordAtToplevel("class", text, 0);
                int indexOfInterface = this._findKeywordAtToplevel("interface", text, 0);
                int indexOfPublic = this._findKeywordAtToplevel("public", text, 0);
                if (indexOfPublic == -1) {
                    String string = this.getFirstClassName(indexOfClass, indexOfInterface);
                    return string;
                }
                int afterPublic = indexOfPublic + "public".length();
                String subText = text.substring(afterPublic);
                this.setCurrentLocation(afterPublic);
                int indexOfPublicClass = this._findKeywordAtToplevel("class", subText, afterPublic);
                if (indexOfPublicClass != -1) {
                    indexOfPublicClass += afterPublic;
                }
                if ((indexOfPublicInterface = this._findKeywordAtToplevel("interface", subText, afterPublic)) != -1) {
                    indexOfPublicInterface += afterPublic;
                }
                String string = this.getFirstClassName(indexOfPublicClass, indexOfPublicInterface);
                return string;
            }
            finally {
                this.setCurrentLocation(oldLocation);
                this.releaseReadLock();
            }
        }
    }

    public String getFirstTopLevelClassName() throws ClassNameNotFoundException {
        return this.getNextTopLevelClassName(0, this.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNextTopLevelClassName(int startPos, int endPos) throws ClassNameNotFoundException {
        this.acquireReadLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int oldLocation = this._currentLocation;
            try {
                int index;
                this.setCurrentLocation(startPos);
                int textLength = endPos - startPos;
                String text = this.getText(startPos, textLength);
                int indexOfClass = this._findKeywordAtToplevel("class", text, startPos);
                int indexOfInterface = this._findKeywordAtToplevel("interface", text, startPos);
                int indexOfEnum = this._findKeywordAtToplevel("enum", text, startPos);
                if (!(indexOfClass <= -1 || indexOfInterface > -1 && indexOfClass >= indexOfInterface || indexOfEnum > -1 && indexOfClass >= indexOfEnum)) {
                    index = indexOfClass + "class".length();
                } else if (!(indexOfInterface <= -1 || indexOfClass > -1 && indexOfInterface >= indexOfClass || indexOfEnum > -1 && indexOfInterface >= indexOfEnum)) {
                    index = indexOfInterface + "interface".length();
                } else if (!(indexOfEnum <= -1 || indexOfClass > -1 && indexOfEnum >= indexOfClass || indexOfInterface > -1 && indexOfEnum >= indexOfInterface)) {
                    index = indexOfEnum + "enum".length();
                } else {
                    throw ClassNameNotFoundException.DEFAULT;
                }
                String string = this.getNextIdentifier(startPos + index);
                return string;
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            catch (IllegalStateException e) {
                throw new ClassNameNotFoundException("No top level class name found");
            }
            finally {
                this.setCurrentLocation(oldLocation);
                this.releaseReadLock();
            }
        }
    }

    private String getNextIdentifier(int startPos) throws ClassNameNotFoundException {
        try {
            int length;
            int index = this.getFirstNonWSCharPos(startPos);
            if (index == -1) {
                throw new IllegalStateException("No identifier found");
            }
            String text = this.getText();
            int endIndex = length = text.length();
            for (int i = index; i < length; ++i) {
                char c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                endIndex = i;
                break;
            }
            return text.substring(index, endIndex);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _findKeywordAtToplevel(String keyword, String text, int textOffset) {
        this.acquireReadLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int n;
            int oldLocation = this._currentLocation;
            int index = 0;
            try {
                while ((index = text.indexOf(keyword, index)) != -1) {
                    this.setCurrentLocation(textOffset + index);
                    ReducedToken rt = this._reduced.currentToken();
                    int indexPastKeyword = index + keyword.length();
                    if (indexPastKeyword < text.length()) {
                        if (rt.getState() == ReducedModelStates.FREE && Character.isWhitespace(text.charAt(indexPastKeyword))) {
                            if (this.posNotInBlock(index)) break;
                            index = -1;
                            break;
                        }
                        ++index;
                        continue;
                    }
                    index = -1;
                    break;
                }
                this.setCurrentLocation(oldLocation);
                n = index;
            }
            catch (Throwable throwable) {
                this.releaseReadLock();
                throw throwable;
            }
            this.releaseReadLock();
            return n;
        }
    }

    @Override
    public synchronized Position createPosition(int offs) throws BadLocationException {
        WrappedPosition wp = new WrappedPosition(super.createPosition(offs));
        if (this._wrappedPosList == null) {
            this._wrappedPosList = new LinkedList();
        }
        this._wrappedPosList.add(new WeakReference<WrappedPosition>(wp));
        return wp;
    }

    public synchronized WeakHashMap<WrappedPosition, Integer> getWrappedPositionOffsets() {
        LinkedList<WeakReference> newList = new LinkedList<WeakReference>();
        if (this._wrappedPosList == null) {
            this._wrappedPosList = new LinkedList();
        }
        WeakHashMap<WrappedPosition, Integer> ret = new WeakHashMap<WrappedPosition, Integer>(this._wrappedPosList.size());
        for (WeakReference weakReference : this._wrappedPosList) {
            if (weakReference.get() == null) continue;
            newList.add(weakReference);
            ret.put((WrappedPosition)weakReference.get(), Autobox.valueOf(((WrappedPosition)weakReference.get()).getOffset()));
        }
        this._wrappedPosList.clear();
        this._wrappedPosList = newList;
        return ret;
    }

    public synchronized void setWrappedPositionOffsets(WeakHashMap<WrappedPosition, Integer> whm) throws BadLocationException {
        if (this._wrappedPosList == null) {
            this._wrappedPosList = new LinkedList();
        }
        this._wrappedPosList.clear();
        for (Map.Entry<WrappedPosition, Integer> entry : whm.entrySet()) {
            if (entry.getKey() == null) continue;
            WrappedPosition wp = entry.getKey();
            wp.setWrapped(super.createPosition(entry.getValue()));
            this._wrappedPosList.add(new WeakReference<WrappedPosition>(wp));
        }
    }

    public CompoundUndoManager getUndoManager() {
        return this._undoManager;
    }

    public void resetUndoManager() {
        this._undoManager = new CompoundUndoManager(this._notifier);
        this._undoManager.setLimit(1000);
    }

    public UndoableEdit getNextUndo() {
        return this._undoManager.getNextUndo();
    }

    public UndoableEdit getNextRedo() {
        return this._undoManager.getNextRedo();
    }

    public void documentSaved() {
        this._undoManager.documentSaved();
    }

    @Override
    protected int startCompoundEdit() {
        return this._undoManager.startCompoundEdit();
    }

    @Override
    protected void endCompoundEdit(int key) {
        this._undoManager.endCompoundEdit(key);
    }

    @Override
    protected void endLastCompoundEdit() {
        this._undoManager.endLastCompoundEdit();
    }

    @Override
    protected void addUndoRedo(AbstractDocument.DefaultDocumentEvent chng, Runnable undoCommand, Runnable doCommand) {
        chng.addEdit(new CommandUndoableEdit(undoCommand, doCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFinalizationListener(FinalizationListener<DefinitionsDocument> fl) {
        List<FinalizationListener<DefinitionsDocument>> list = this._finalizationListeners;
        synchronized (list) {
            this._finalizationListeners.add(fl);
        }
    }

    @Override
    public List<FinalizationListener<DefinitionsDocument>> getFinalizationListeners() {
        return this._finalizationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        FinalizationEvent<DefinitionsDocument> fe = new FinalizationEvent<DefinitionsDocument>(this);
        List<FinalizationListener<DefinitionsDocument>> list = this._finalizationListeners;
        synchronized (list) {
            for (FinalizationListener<DefinitionsDocument> fl : this._finalizationListeners) {
                fl.finalized(fe);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("ddoc for ").append(this._odd).toString();
    }

    private static class CommandUndoableEdit
    extends AbstractUndoableEdit {
        private final Runnable _undoCommand;
        private final Runnable _redoCommand;

        public CommandUndoableEdit(Runnable undoCommand, Runnable redoCommand) {
            this._undoCommand = undoCommand;
            this._redoCommand = redoCommand;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this._undoCommand.run();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this._redoCommand.run();
        }

        public boolean isSignificant() {
            return false;
        }
    }

    public static class WrappedPosition
    implements Position {
        private Position _wrapped;

        public WrappedPosition(Position w) {
            this.setWrapped(w);
        }

        public void setWrapped(Position w) {
            this._wrapped = w;
        }

        public int getOffset() {
            return this._wrapped.getOffset();
        }
    }
}

