/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.model.GlobalEventNotifier;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager {
    private static int counter = 0;
    private final int id = ++counter;
    private final LinkedList<CompoundEdit> _compoundEdits = new LinkedList();
    private final LinkedList<Integer> _keys = new LinkedList();
    private int _nextKey = 0;
    private UndoableEdit _savePoint = null;
    private final GlobalEventNotifier _notifier;

    public CompoundUndoManager(GlobalEventNotifier notifier) {
        this._notifier = notifier;
    }

    public synchronized int startCompoundEdit() {
        this._compoundEdits.add(0, new CompoundEdit());
        this._keys.add(0, new Integer(this._nextKey));
        this._nextKey = this._nextKey < Integer.MAX_VALUE ? ++this._nextKey : Integer.MIN_VALUE;
        return this._keys.get(0);
    }

    public synchronized void endLastCompoundEdit() {
        if (this._keys.size() == 0) {
            return;
        }
        this.endCompoundEdit(this._keys.get(0));
    }

    public synchronized void endCompoundEdit(int key) {
        if (this._keys.size() == 0) {
            return;
        }
        if (this._keys.get(0) == key) {
            this._keys.remove(0);
            CompoundEdit ce = this._compoundEdits.remove(0);
            ce.end();
            if (ce.canUndo()) {
                if (!this._compoundEditInProgress()) {
                    super.addEdit(ce);
                    this._notifyUndoHappened();
                } else {
                    this._compoundEdits.get(0).addEdit(ce);
                }
            }
        } else {
            throw new IllegalStateException("Improperly nested compound edits.");
        }
    }

    public synchronized CompoundEdit getLastCompoundEdit() {
        return this._compoundEdits.get(0);
    }

    public UndoableEdit getNextUndo() {
        return this.editToBeUndone();
    }

    public UndoableEdit getNextRedo() {
        return this.editToBeRedone();
    }

    public synchronized boolean addEdit(UndoableEdit e) {
        if (this._compoundEditInProgress()) {
            return this._compoundEdits.get(0).addEdit(e);
        }
        boolean result = super.addEdit(e);
        this._notifyUndoHappened();
        return result;
    }

    public synchronized boolean _compoundEditInProgress() {
        return !this._compoundEdits.isEmpty();
    }

    public synchronized boolean canUndo() {
        return this._compoundEditInProgress() || super.canUndo();
    }

    public synchronized String getUndoPresentationName() {
        if (this._compoundEditInProgress()) {
            return "Undo Previous Command";
        }
        return super.getUndoPresentationName();
    }

    public synchronized void undo() {
        this.endCompoundEdit();
        super.undo();
    }

    public synchronized void undo(int key) {
        if (this._keys.get(0) != key) {
            throw new IllegalArgumentException("Bad undo key " + key + "!");
        }
        final CompoundEdit ce = this._compoundEdits.get(0);
        this._compoundEdits.remove(0);
        this._keys.remove(0);
        ce.end();
        ce.undo();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ce.die();
            }
        });
    }

    public synchronized void redo() {
        this.endCompoundEdit();
        super.redo();
    }

    private void _notifyUndoHappened() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CompoundUndoManager.access$000(CompoundUndoManager.this).undoableEditHappened();
            }
        });
    }

    private synchronized void endCompoundEdit() {
        Integer[] keys = this._keys.toArray(new Integer[this._keys.size()]);
        if (this._compoundEditInProgress()) {
            Integer[] arr$ = keys;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int key = arr$[i$];
                this.endCompoundEdit(key);
            }
        }
    }

    public synchronized void documentSaved() {
        this.endCompoundEdit();
        this._savePoint = this.editToBeUndone();
    }

    public synchronized boolean isModified() {
        return this.editToBeUndone() != this._savePoint;
    }

    public String toString() {
        return "(CompoundUndoManager: " + this.id + ")";
    }

    static GlobalEventNotifier access$000(CompoundUndoManager x0) {
        return x0._notifier;
    }
}

