/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;

public class DebugThreadData {
    private final ThreadReference _thread;
    private final String _name;
    private final String _status;
    private final long _uniqueID;

    public DebugThreadData(ThreadReference thread) {
        String name;
        this._thread = thread;
        try {
            name = this._thread.name();
        }
        catch (VMDisconnectedException e) {
            name = "";
        }
        this._name = name;
        String status = "(unknown)";
        try {
            switch (this._thread.status()) {
                case 3: {
                    status = "MONITOR";
                    break;
                }
                case 5: {
                    status = "NOT STARTED";
                    break;
                }
                case 1: {
                    status = "RUNNING";
                    break;
                }
                case 2: {
                    status = "SLEEPING";
                    break;
                }
                case -1: {
                    status = "UNKNOWN";
                    break;
                }
                case 4: {
                    status = "WAIT";
                    break;
                }
                case 0: {
                    status = "ZOMBIE";
                }
            }
        }
        catch (VMDisconnectedException e) {
            // empty catch block
        }
        this._status = this.isSuspended() && status.equals("RUNNING") ? "SUSPENDED" : status;
        this._uniqueID = this._thread.uniqueID();
    }

    public String getName() {
        return this._name;
    }

    public String getStatus() {
        return this._status;
    }

    public long getUniqueID() {
        return this._uniqueID;
    }

    public boolean isSuspended() {
        try {
            return this._thread.isSuspended();
        }
        catch (ObjectCollectedException oce) {
            return false;
        }
        catch (VMDisconnectedException vmde) {
            return false;
        }
    }
}

