/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR14v20Compiler
implements CompilerInterface {
    private String _extraClassPath = "";
    protected boolean _allowAssertions = false;
    protected boolean _warningsEnabled = true;
    private boolean _isJSR14v2_4;
    private boolean _isJSR14v2_5 = false;
    public static final CompilerInterface ONLY = new JSR14v20Compiler();
    public static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.main.JavaCompiler";
    protected Context context = null;
    private String _builtPath = "";
    private static final Writer NULL_WRITER = new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    };
    private static final PrintWriter NULL_PRINT_WRITER = new PrintWriter(NULL_WRITER);
    protected JavaCompiler compiler;
    protected OurLog compilerLog;
    static /* synthetic */ Class class$com$sun$tools$javac$util$Log;
    static /* synthetic */ Class class$com$sun$tools$javac$util$Context;
    static /* synthetic */ Class class$com$sun$tools$javac$main$JavaCompiler;
    static /* synthetic */ Class class$com$sun$tools$javac$util$List;

    protected JSR14v20Compiler() {
        if (!this._isValidVersion()) {
            throw new RuntimeException("Invalid version of Java compiler.");
        }
        this._isJSR14v2_4 = this._isJSR14v2_4();
    }

    protected boolean _isValidVersion() {
        Class log = class$com$sun$tools$javac$util$Log == null ? (class$com$sun$tools$javac$util$Log = JSR14v20Compiler.class$("com.sun.tools.javac.util.Log")) : class$com$sun$tools$javac$util$Log;
        Class[] validArgs1 = new Class[]{class$com$sun$tools$javac$util$Context == null ? (class$com$sun$tools$javac$util$Context = JSR14v20Compiler.class$("com.sun.tools.javac.util.Context")) : class$com$sun$tools$javac$util$Context};
        try {
            log.getMethod("instance", validArgs1);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public CompilerError[] compile(File sourceRoot, File[] files) {
        File[] sourceRoots = new File[]{sourceRoot};
        return this.compile(sourceRoots, files);
    }

    @Override
    public CompilerError[] compile(File[] sourceRoots, File[] files) {
        this.initCompiler(sourceRoots);
        List<String> filesToCompile = this._emptyStringList();
        for (int i = 0; i < files.length; ++i) {
            filesToCompile = filesToCompile.prepend(files[i].getAbsolutePath());
        }
        try {
            this.compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            CompilerError[] errorArray = new CompilerError[this.compilerLog.getErrors().length + 1];
            for (int i = 0; i < this.compilerLog.getErrors().length; ++i) {
                errorArray[i + 1] = this.compilerLog.getErrors()[i];
            }
            errorArray[0] = new CompilerError(new StringBuffer().append("Compile exception: ").append(t).toString(), false);
            return errorArray;
        }
        CompilerError[] errors = this.compilerLog.getErrors();
        this.compiler = null;
        this.compilerLog = null;
        return errors;
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName(COMPILER_CLASS_NAME);
            try {
                Class.forName("java.lang.Enum");
            }
            catch (Exception e) {
                Class.forName("com.sun.tools.javac.main.Main$14");
                this._isJSR14v2_5 = true;
            }
            return this._isValidVersion();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getName() {
        if (this._isJSR14v2_5) {
            return "JSR-14 v2.5";
        }
        if (this._isJSR14v2_4) {
            return "JSR-14 v2.4";
        }
        return "JSR-14 v2.0/2.2";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setExtraClassPath(String extraClassPath) {
        this._extraClassPath = extraClassPath;
    }

    public void setExtraClassPath(ClasspathVector extraClassPath) {
        this.setExtraClassPath(extraClassPath.toString());
    }

    @Override
    public void addToBootClassPath(File cp) {
        throw new UnexpectedException(new Exception("Method only implemented in JSR14Compiler"));
    }

    @Override
    public void setAllowAssertions(boolean allow) {
        this._allowAssertions = allow;
    }

    @Override
    public void setWarningsEnabled(boolean warningsEnabled) {
        this._warningsEnabled = warningsEnabled;
    }

    protected Context createContext(File[] sourceRoots) {
        Context context = new Context();
        Options options = Options.instance(context);
        options.putAll(CompilerOptions.getOptions(this._warningsEnabled));
        options.put("-g", "");
        this._addSourceAndTargetOptions(options);
        String sourceRootString = this.getSourceRootString(sourceRoots);
        options.put("-sourcepath", sourceRootString);
        String cp = System.getProperty("java.class.path");
        cp = new StringBuffer().append(cp).append(this._extraClassPath).toString();
        cp = new StringBuffer().append(cp).append(File.pathSeparator).append(sourceRootString).toString();
        options.put("-classpath", cp);
        return context;
    }

    protected void _addSourceAndTargetOptions(Options options) {
        options.put("-source", "1.5");
        if (System.getProperty("java.specification.version").equals("1.5")) {
            options.put("-target", "1.5");
        } else if (this._isJSR14v2_4) {
            options.put("-target", "jsr14");
        }
        options.put("-fork", "on");
        if (!this._builtPath.equals("")) {
            options.put("-d", this._builtPath);
        }
    }

    protected String getSourceRootString(File[] sourceRoots) {
        StringBuffer roots = new StringBuffer();
        for (int i = 0; i < sourceRoots.length; ++i) {
            roots.append(sourceRoots[i].getAbsolutePath());
            if (i >= sourceRoots.length - 1) continue;
            roots.append(File.pathSeparator);
        }
        return roots.toString();
    }

    protected void initCompiler(File[] sourceRoots) {
        this.context = this.createContext(sourceRoots);
        this.compilerLog = new OurLog(this.context);
        Class javaCompilerClass = class$com$sun$tools$javac$main$JavaCompiler == null ? (class$com$sun$tools$javac$main$JavaCompiler = JSR14v20Compiler.class$(COMPILER_CLASS_NAME)) : class$com$sun$tools$javac$main$JavaCompiler;
        Class[] validArgs1 = new Class[]{class$com$sun$tools$javac$util$Context == null ? (class$com$sun$tools$javac$util$Context = JSR14v20Compiler.class$("com.sun.tools.javac.util.Context")) : class$com$sun$tools$javac$util$Context};
        if (this._isJSR14v2_4) {
            try {
                Method m = javaCompilerClass.getMethod("instance", validArgs1);
                this.compiler = (JavaCompiler)m.invoke(null, this.context);
            }
            catch (NoSuchMethodException e) {
                throw new UnexpectedException(e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException(e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new UnexpectedException(e);
            }
        }
        try {
            Method m = javaCompilerClass.getMethod("make", validArgs1);
            this.compiler = (JavaCompiler)m.invoke(null, this.context);
        }
        catch (NoSuchMethodException e) {
            throw new UnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void setBuildDirectory(File dir) {
        this._builtPath = dir == null ? "" : dir.getAbsolutePath();
    }

    private boolean _isJSR14v2_4() {
        try {
            Class.forName("com.sun.tools.javac.main.Main$14");
            return true;
        }
        catch (Exception e) {
            try {
                Class.forName("com.sun.tools.javac.main.Main+1");
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    private List<String> _emptyStringList() {
        try {
            Method nil = (class$com$sun$tools$javac$util$List == null ? (class$com$sun$tools$javac$util$List = JSR14v20Compiler.class$("com.sun.tools.javac.util.List")) : class$com$sun$tools$javac$util$List).getMethod("nil", new Class[0]);
            return (List)nil.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception occured when invoking com.sun.tools.javac.util.List.nil()", e);
        }
        catch (Exception e) {
            try {
                return (List)(class$com$sun$tools$javac$util$List == null ? (class$com$sun$tools$javac$util$List = JSR14v20Compiler.class$("com.sun.tools.javac.util.List")) : class$com$sun$tools$javac$util$List).newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException("Unable to create an instance of com.sun.tools.javac.util.List", e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private class OurLog
    extends Log {
        private LinkedList<CompilerError> _errors;
        private String _sourceName;

        public OurLog(Context context) {
            super(context, NULL_PRINT_WRITER, NULL_PRINT_WRITER, NULL_PRINT_WRITER);
            this._errors = new LinkedList();
            this._sourceName = "";
        }

        public void warning(int pos, String key, Object[] args) {
            super.warning(pos, key, args);
            String msg = OurLog.getText((String)("compiler.warn." + key), (Object[])args);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void error(int pos, String key, Object[] args) {
            super.error(pos, key, args);
            String msg = OurLog.getText((String)("compiler.err." + key), (Object[])args);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public CompilerError[] getErrors() {
            return this._errors.toArray(new CompilerError[0]);
        }
    }
}

