/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerProxy;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import java.lang.reflect.Field;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerRegistry {
    public static final String[] JAVA_16_COMPILERS = new String[]{"edu.rice.cs.drjava.model.compiler.Javac160FromSetLocation", "edu.rice.cs.drjava.model.compiler.Javac160FromClasspath", "edu.rice.cs.drjava.model.compiler.Javac160FromToolsJar"};
    public static final String[] JAVA_15_COMPILERS = new String[]{"edu.rice.cs.drjava.model.compiler.Javac150FromSetLocation", "edu.rice.cs.drjava.model.compiler.Javac150FromClasspath", "edu.rice.cs.drjava.model.compiler.Javac150FromToolsJar"};
    public static final String[] JAVA_14_COMPILERS = new String[]{"edu.rice.cs.drjava.model.compiler.Javac141FromSetLocation", "edu.rice.cs.drjava.model.compiler.Javac141FromClasspath", "edu.rice.cs.drjava.model.compiler.Javac141FromToolsJar"};
    static final String[][] DEFAULT_COMPILERS = new String[][]{JAVA_16_COMPILERS, JAVA_15_COMPILERS, JAVA_14_COMPILERS};
    public static final CompilerRegistry ONLY = new CompilerRegistry();
    private static final Log _log = new Log("CompilerTest.txt", false);
    private volatile ClassLoader _baseClassLoader;
    private final String[] _candidateCompilers;
    private CompilerInterface _activeCompiler = NoCompilerAvailable.ONLY;

    private CompilerRegistry() {
        this._baseClassLoader = this.getClass().getClassLoader();
        String version = CompilerProxy.VERSION;
        this._candidateCompilers = version.equals("1.4") ? JAVA_14_COMPILERS : (version.equals("1.5") ? JAVA_15_COMPILERS : (version.equals("1.6") ? JAVA_16_COMPILERS : null));
    }

    public void setBaseClassLoader(ClassLoader l) {
        this._baseClassLoader = l;
    }

    public ClassLoader getBaseClassLoader() {
        return this._baseClassLoader;
    }

    public CompilerInterface[] getAvailableCompilers() {
        LinkedList<CompilerInterface> availableCompilers = new LinkedList<CompilerInterface>();
        if (this._candidateCompilers == null) {
            throw new UnexpectedException(new StringBuffer().append("Java specification version ").append(CompilerProxy.VERSION).append("is not supported.  Must be 1.4, 1.5, or 1.6").toString());
        }
        for (String name : this._candidateCompilers) {
            _log.log(new StringBuffer().append("CompilerRegistry.getAvailableCompilers is checking compiler: ").append(name).toString());
            try {
                if (!this._createCompiler(name, availableCompilers)) continue;
            }
            catch (Throwable t) {
                _log.log(new StringBuffer().append("Compiler ").append(name).append(" failed to load:").toString());
            }
        }
        if (availableCompilers.size() == 0) {
            availableCompilers.add(NoCompilerAvailable.ONLY);
        }
        _log.log(new StringBuffer().append("CompilerRegistry.getAvailableCompilers() returning ").append(availableCompilers).toString());
        return availableCompilers.toArray(new CompilerInterface[availableCompilers.size()]);
    }

    private boolean _createCompiler(String name, LinkedList<CompilerInterface> availableCompilers) throws Throwable {
        _log.log(new StringBuffer().append("CompilerRegistry._createCompiler(").append(name).append(", ").append(availableCompilers).append(") called").toString());
        CompilerInterface compiler = this._instantiateCompiler(name);
        if (compiler.isAvailable()) {
            _log.log(new StringBuffer().append("Compiler ").append(this).append(" is available: added to compile list").toString());
            if (this._activeCompiler == NoCompilerAvailable.ONLY) {
                this._activeCompiler = compiler;
            }
            availableCompilers.add(compiler);
            return true;
        }
        _log.log(new StringBuffer().append("Compiler ").append(this).append(" is NOT available.").toString());
        return false;
    }

    public boolean isNoCompilerAvailable() {
        return this.getActiveCompiler() == NoCompilerAvailable.ONLY;
    }

    public void setActiveCompiler(CompilerInterface compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("Cannot set active compiler to null.");
        }
        this._activeCompiler = compiler;
    }

    public CompilerInterface getActiveCompiler() {
        if (this._activeCompiler == NoCompilerAvailable.ONLY) {
            this.getAvailableCompilers();
        }
        if (this._activeCompiler.isAvailable()) {
            return this._activeCompiler;
        }
        return NoCompilerAvailable.ONLY;
    }

    private CompilerInterface _instantiateCompiler(String name) throws Throwable {
        _log.log(new StringBuffer().append("CompilerRegistry._instantiateCompiler using class loader ").append(this._baseClassLoader).append(" to load ").append(name).toString());
        Class<?> clazz = this._baseClassLoader.loadClass(name);
        _log.log(new StringBuffer().append("Loaded compiler named ").append(name).append(" with class name ").append(clazz).toString());
        return CompilerRegistry.createCompiler(clazz);
    }

    public static CompilerInterface createCompiler(Class clazz) throws Throwable {
        try {
            _log.log(new StringBuffer().append("CompilerRegistry.createCompiler(").append(clazz).append(") called").toString());
            Field field = clazz.getField("ONLY");
            _log.log(new StringBuffer().append(clazz).append(".ONLY = ").append(field).toString());
            Object val = field.get(null);
            _log.log(new StringBuffer().append("createCompiler(").append(clazz).append(") returning ").append(val).toString());
            return (CompilerInterface)val;
        }
        catch (Throwable t) {
            _log.log(new StringBuffer().append("createCompiler threw exception ").append(t).toString());
            return (CompilerInterface)clazz.newInstance();
        }
    }
}

