/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerRegistry;
import edu.rice.cs.util.ClassPathVector;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.classloader.StickyClassLoader;
import java.io.File;

public class CompilerProxy
implements CompilerInterface {
    public static final String VERSION = System.getProperty("java.specification.version");
    private static final Log _log = new Log("CompilerTest.txt", false);
    private CompilerInterface _realCompiler = null;
    private final String _className;
    private final ClassLoader _newLoader;
    private boolean _warningsEnabled = true;
    private File _buildDir;
    private ClassPathVector _extraClassPath = new ClassPathVector();
    private static final String[] _useOldLoader = new String[]{"edu.rice.cs.drjava.model.Configuration", "edu.rice.cs.drjava.model.compiler.CompilerInterface", "edu.rice.cs.drjava.model.compiler.CompilerError"};

    public CompilerProxy(String className, ClassLoader newLoader) {
        this._className = className;
        this._newLoader = newLoader;
        this._recreateCompiler();
    }

    private void _recreateCompiler() {
        _log.log(this + "._recreateCompiler() called");
        StickyClassLoader loader = new StickyClassLoader(this._newLoader, this.getClass().getClassLoader(), _useOldLoader);
        try {
            Class<?> c = loader.loadClass(this._className);
            _log.log("Class " + c + " loaded");
            this._realCompiler = CompilerRegistry.createCompiler(c);
            _log.log("_realCompiler set to " + this._realCompiler);
            this._realCompiler.setBuildDirectory(this._buildDir);
            this._realCompiler.setExtraClassPath(File.pathSeparator + this._extraClassPath.toString());
            this._realCompiler.setWarningsEnabled(this._warningsEnabled);
            boolean allowAssertions = DrJava.getConfig().getSetting(OptionConstants.RUN_WITH_ASSERT);
            this._realCompiler.setAllowAssertions(allowAssertions);
            String compilerClass = this._realCompiler.getClass().getName();
            _log.log("Compiler created with name " + compilerClass);
        }
        catch (Throwable t) {
            _log.log(this + "._recreateCompiler() threw exception " + t);
        }
    }

    public CompilerError[] compile(File sourceRoot, File[] files) {
        this._recreateCompiler();
        _log.log("realCompiler is " + this._realCompiler.getClass());
        CompilerError[] ret = this._realCompiler.compile(sourceRoot, files);
        return ret;
    }

    public CompilerError[] compile(File[] sourceRoots, File[] files) {
        _log.log("proxy to compile: " + files[0]);
        this._recreateCompiler();
        _log.log("realCompiler is " + this._realCompiler.getClass());
        CompilerError[] ret = this._realCompiler.compile(sourceRoots, files);
        return ret;
    }

    public boolean isAvailable() {
        _log.log("CompilerProxy.isAvailable() called for " + this.getClass() + " _realCompiler = " + this._realCompiler);
        if (this._realCompiler == null) {
            return false;
        }
        return this._realCompiler.isAvailable();
    }

    public String getName() {
        if (!this.isAvailable()) {
            return "(unavailable)";
        }
        return this._realCompiler.getName();
    }

    public String toString() {
        return this.getName();
    }

    public void setExtraClassPath(String extraClassPath) {
        this._realCompiler.setExtraClassPath(extraClassPath);
    }

    public void setExtraClassPath(ClassPathVector extraClassPath) {
        this._extraClassPath = extraClassPath;
    }

    public void setAllowAssertions(boolean allow) {
        this._realCompiler.setAllowAssertions(allow);
    }

    public void setWarningsEnabled(boolean warningsEnabled) {
        this._realCompiler.setWarningsEnabled(warningsEnabled);
        this._warningsEnabled = warningsEnabled;
    }

    public void addToBootClassPath(File cp) {
        this._realCompiler.addToBootClassPath(cp);
    }

    public void setBuildDirectory(File buildDir) {
        this._realCompiler.setBuildDirectory(buildDir);
        this._buildDir = buildDir;
    }
}

