/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import java.io.File;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class SimpleDocumentRegion
implements DocumentRegion {
    protected final OpenDefinitionsDocument _doc;
    protected final File _file;
    protected volatile int _startOffset;
    protected volatile int _endOffset;
    protected volatile Position _startPos = null;
    protected volatile Position _endPos = null;

    public SimpleDocumentRegion(OpenDefinitionsDocument doc, File file, int so, int eo) {
        this._doc = doc;
        this._file = file;
        this._startOffset = so;
        this._endOffset = eo;
        if (this._doc != null) {
            try {
                this._startPos = this._doc.createPosition(so);
                this._endPos = this._doc.createPosition(eo);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    public File getFile() {
        return this._file;
    }

    public int getStartOffset() {
        if (this._startPos != null) {
            this._startOffset = this._startPos.getOffset();
        }
        return this._startOffset;
    }

    public int getEndOffset() {
        if (this._endPos != null) {
            this._endOffset = this._endPos.getOffset();
        }
        return this._endOffset;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SimpleDocumentRegion) || other == null) {
            return false;
        }
        SimpleDocumentRegion o = (SimpleDocumentRegion)other;
        return (this._doc == null && o._doc == null || this._doc.equals(o._doc)) && (this._file == null && o._file == null || this._file.equals(o._file)) && this._startPos.getOffset() == o._startPos.getOffset() && this._endPos.getOffset() == o._endPos.getOffset();
    }

    public String toString() {
        return (this._doc != null ? this._doc.toString() : "null") + " " + this._startOffset + " .. " + this._endOffset;
    }
}

