/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.DocumentIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindReplaceMachine {
    private OpenDefinitionsDocument _doc;
    private OpenDefinitionsDocument _firstDoc;
    private Position _current;
    private String _findWord;
    private String _replaceWord;
    private boolean _matchCase;
    private boolean _matchWholeWord;
    private boolean _searchAllDocuments;
    private boolean _isForward;
    private boolean _ignoreCommentsAndStrings;
    private String _lastFindWord;
    private boolean _skipText = false;
    private DocumentIterator _docIterator;
    private SingleDisplayModel _model;

    public FindReplaceMachine(SingleDisplayModel model, DocumentIterator docIterator) {
        this._model = model;
        this._docIterator = docIterator;
        this.setFindAnyOccurrence();
        this.setFindWord("");
        this.setReplaceWord("");
        this.setSearchBackwards(false);
        this.setMatchCase(true);
        this.setSearchAllDocuments(false);
        this.setIgnoreCommentsAndStrings(false);
    }

    public void cleanUp() {
        this._docIterator = null;
        this.setFindWord("");
        this._doc = null;
    }

    public void positionChanged() {
        this._lastFindWord = null;
        this._skipText = false;
    }

    public void setLastFindWord() {
        this._lastFindWord = this._findWord;
    }

    public boolean getSearchBackwards() {
        return !this._isForward;
    }

    public void setSearchBackwards(boolean searchBackwards) {
        if (this._isForward == searchBackwards) {
            this._skipText = this.onMatch() && this._findWord.equals(this._lastFindWord);
        }
        this._isForward = !searchBackwards;
    }

    public void setMatchCase(boolean matchCase) {
        this._matchCase = matchCase;
    }

    public void setMatchWholeWord() {
        this._matchWholeWord = true;
    }

    public void setFindAnyOccurrence() {
        this._matchWholeWord = false;
    }

    public void setSearchAllDocuments(boolean searchAllDocuments) {
        this._searchAllDocuments = searchAllDocuments;
    }

    public void setIgnoreCommentsAndStrings(boolean ignoreCommentsAndStrings) {
        this._ignoreCommentsAndStrings = ignoreCommentsAndStrings;
    }

    public void setDocument(OpenDefinitionsDocument doc) {
        this._doc = doc;
    }

    public void setFirstDoc(OpenDefinitionsDocument firstDoc) {
        this._firstDoc = firstDoc;
    }

    public void setPosition(int pos) {
        try {
            this._current = this._doc.createPosition(pos);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public int getCurrentOffset() {
        return this._current.getOffset();
    }

    public String getFindWord() {
        return this._findWord;
    }

    public String getReplaceWord() {
        return this._replaceWord;
    }

    public boolean getSearchAllDocuments() {
        return this._searchAllDocuments;
    }

    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    public OpenDefinitionsDocument getFirstDoc() {
        return this._firstDoc;
    }

    public void setFindWord(String word) {
        this._findWord = StringOps.replace(word, System.getProperty("line.separator"), "\n");
    }

    public void setReplaceWord(String word) {
        this._replaceWord = StringOps.replace(word, System.getProperty("line.separator"), "\n");
    }

    public boolean onMatch() {
        String matchSpace;
        String findWord = this._findWord;
        if (this._current == null) {
            return false;
        }
        int wordLen = findWord.length();
        int off = this._isForward ? this.getCurrentOffset() - wordLen : this.getCurrentOffset();
        if (off < 0) {
            return false;
        }
        this._doc.acquireReadLock();
        try {
            if (off + wordLen > this._doc.getLength()) {
                boolean bl = false;
                return bl;
            }
            matchSpace = this._doc.getText(off, wordLen);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this._doc.releaseReadLock();
        }
        if (!this._matchCase) {
            matchSpace = matchSpace.toLowerCase();
            findWord = findWord.toLowerCase();
        }
        return matchSpace.equals(findWord);
    }

    public boolean replaceCurrent() {
        if (!this.onMatch()) {
            return false;
        }
        this._doc.acquireWriteLock();
        try {
            int offset = this.getCurrentOffset();
            if (this._isForward) {
                offset -= this._findWord.length();
            }
            this._doc.remove(offset, this._findWord.length());
            this._doc.insertString(this.getCurrentOffset(), this._replaceWord, null);
            if (this._isForward) {
                this.setPosition(offset + this._replaceWord.length());
            } else {
                this.setPosition(offset);
            }
            boolean bl = true;
            return bl;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this._doc.releaseWriteLock();
        }
    }

    public int replaceAll() {
        return this.replaceAll(this._searchAllDocuments);
    }

    private int replaceAll(boolean searchAll) {
        if (searchAll) {
            OpenDefinitionsDocument startDoc = this._doc;
            int count = 0;
            int n = this._docIterator.getDocumentCount();
            for (int i = 0; i < n; ++i) {
                count += this._replaceAllInCurrentDoc();
                this._doc = this._docIterator.getNextDocument(this._doc);
            }
            this._model.getDocumentNavigator().repaint();
            return count;
        }
        return this._replaceAllInCurrentDoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _replaceAllInCurrentDoc() {
        this._doc.acquireWriteLock();
        try {
            if (this._isForward) {
                this.setPosition(0);
            } else {
                this.setPosition(this._doc.getLength());
            }
            int count = 0;
            FindResult fr = this.findNext(false);
            while (!fr.getWrapped()) {
                this.replaceCurrent();
                ++count;
                fr = this.findNext(false);
            }
            int n = count;
            return n;
        }
        finally {
            this._doc.releaseWriteLock();
        }
    }

    public int processAll(Lambda<Void, FindResult> findAction) {
        return this.processAll(findAction, this._searchAllDocuments);
    }

    private int processAll(Lambda<Void, FindResult> findAction, boolean searchAll) {
        if (searchAll) {
            OpenDefinitionsDocument startDoc = this._doc;
            int count = 0;
            int n = this._docIterator.getDocumentCount();
            for (int i = 0; i < n; ++i) {
                count += this._processAllInCurrentDoc(findAction);
                this._doc = this._docIterator.getNextDocument(this._doc);
            }
            this._model.getDocumentNavigator().repaint();
            return count;
        }
        return this._processAllInCurrentDoc(findAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _processAllInCurrentDoc(Lambda<Void, FindResult> findAction) {
        this._doc.acquireWriteLock();
        try {
            if (this._isForward) {
                this.setPosition(0);
            } else {
                this.setPosition(this._doc.getLength());
            }
            int count = 0;
            FindResult fr = this.findNext(false);
            while (!fr.getWrapped()) {
                findAction.apply(fr);
                ++count;
                fr = this.findNext(false);
            }
            int n = count;
            return n;
        }
        finally {
            this._doc.releaseWriteLock();
        }
    }

    public FindResult findNext() {
        return this.findNext(this._searchAllDocuments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindResult findNext(boolean searchAll) {
        FindResult fr;
        int len;
        int start;
        this._doc.acquireReadLock();
        try {
            if (this._skipText) {
                int wordLen = this._lastFindWord.length();
                if (this._isForward) {
                    this.setPosition(this.getCurrentOffset() + wordLen);
                } else {
                    this.setPosition(this.getCurrentOffset() - wordLen);
                }
                this.positionChanged();
            }
            int offset = this.getCurrentOffset();
            if (this._isForward) {
                start = offset;
                len = this._doc.getLength() - offset;
            } else {
                start = 0;
                len = offset;
            }
            fr = this._findNextInDoc(this._doc, start, len, searchAll);
        }
        finally {
            this._doc.releaseReadLock();
        }
        if (fr.getFoundOffset() >= 0 || !searchAll) {
            return fr;
        }
        return this._findNextInOtherDocs(this._doc, start, len);
    }

    private FindResult _findNextInDoc(OpenDefinitionsDocument doc, int start, int len, boolean searchAll) {
        FindResult fr = this._findNextInDocSegment(doc, start, len);
        if (fr.getFoundOffset() >= 0 || searchAll) {
            return fr;
        }
        return this._findWrapped(doc, start, len, false);
    }

    private FindResult _findWrapped(OpenDefinitionsDocument doc, int start, int len, boolean allWrapped) {
        int newLen;
        int newStart;
        if (doc.getLength() == 0) {
            return new FindResult(doc, -1, true, allWrapped);
        }
        if (this._isForward) {
            newStart = 0;
            newLen = start;
        } else {
            newStart = len;
            newLen = doc.getLength() - len;
        }
        return this._findNextInDocSegment(doc, newStart, newLen, true, allWrapped);
    }

    private FindResult _findNextInDocSegment(OpenDefinitionsDocument doc, int start, int len) {
        return this._findNextInDocSegment(doc, start, len, false, false);
    }

    private FindResult _findNextInDocSegment(OpenDefinitionsDocument doc, int start, int len, boolean wrapped, boolean allWrapped) {
        int docLen = doc.getLength();
        if (len == 0 || docLen == 0) {
            return new FindResult(doc, -1, wrapped, allWrapped);
        }
        int wordLen = this._findWord.length();
        try {
            String findWord;
            String text = doc.getText(start, len);
            if (!this._matchCase) {
                text = text.toLowerCase();
                findWord = this._findWord.toLowerCase();
            } else {
                findWord = this._findWord;
            }
            while (len >= wordLen) {
                int matchLocation;
                int foundOffset;
                int n = foundOffset = this._isForward ? text.indexOf(findWord) : text.lastIndexOf(findWord);
                if (foundOffset < 0) break;
                int foundLocation = start + foundOffset;
                if (this._isForward) {
                    int adjustedOffset = foundOffset + wordLen;
                    text = text.substring(adjustedOffset, len);
                    len -= adjustedOffset;
                    matchLocation = start += adjustedOffset;
                } else {
                    len = foundOffset;
                    matchLocation = start + foundOffset;
                    text = text.substring(0, len);
                }
                doc.setCurrentLocation(foundLocation);
                if (this._shouldIgnore(foundLocation, doc)) continue;
                this._current = doc.createPosition(matchLocation);
                return new FindResult(doc, matchLocation, wrapped, allWrapped);
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        return new FindResult(doc, -1, wrapped, allWrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindResult _findNextInOtherDocs(OpenDefinitionsDocument startDoc, int start, int len) {
        boolean allWrapped = false;
        OpenDefinitionsDocument openDefinitionsDocument = this._doc = this._isForward ? this._docIterator.getNextDocument(startDoc) : this._docIterator.getPrevDocument(startDoc);
        while (this._doc != startDoc) {
            FindResult fr;
            if (this._doc == this._firstDoc) {
                allWrapped = true;
            }
            this._doc.acquireReadLock();
            try {
                fr = this._findNextInDocSegment(this._doc, 0, this._doc.getLength(), false, allWrapped);
            }
            finally {
                this._doc.releaseReadLock();
            }
            if (fr.getFoundOffset() >= 0) {
                return fr;
            }
            this._doc = this._isForward ? this._docIterator.getNextDocument(this._doc) : this._docIterator.getPrevDocument(this._doc);
        }
        startDoc.acquireReadLock();
        try {
            FindResult findResult = this._findWrapped(startDoc, start, len, true);
            return findResult;
        }
        finally {
            startDoc.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wholeWordFoundAtCurrent(OpenDefinitionsDocument doc, int foundOffset) {
        char leftOfMatch = '\u0000';
        char rightOfMatch = '\u0000';
        int leftLoc = foundOffset - 1;
        int rightLoc = foundOffset + this._findWord.length();
        boolean leftOutOfBounds = false;
        boolean rightOutOfBounds = false;
        doc.acquireReadLock();
        try {
            try {
                leftOfMatch = doc.getText(leftLoc, 1).charAt(0);
            }
            catch (BadLocationException e) {
                leftOutOfBounds = true;
            }
            try {
                rightOfMatch = doc.getText(rightLoc, 1).charAt(0);
            }
            catch (BadLocationException e) {
                rightOutOfBounds = true;
            }
        }
        finally {
            doc.releaseReadLock();
        }
        if (!leftOutOfBounds && !rightOutOfBounds) {
            return this.isDelimiter(rightOfMatch) && this.isDelimiter(leftOfMatch);
        }
        if (!leftOutOfBounds) {
            return this.isDelimiter(leftOfMatch);
        }
        if (!rightOutOfBounds) {
            return this.isDelimiter(rightOfMatch);
        }
        return true;
    }

    private boolean isDelimiter(char ch) {
        return !Character.isLetterOrDigit(ch);
    }

    private boolean _shouldIgnore(int foundOffset, OpenDefinitionsDocument odd) {
        return this._matchWholeWord && !this.wholeWordFoundAtCurrent(odd, foundOffset) || this._ignoreCommentsAndStrings && odd.getStateAtCurrent() != ReducedModelStates.FREE;
    }
}

