/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipboardHistoryModel {
    private int _maxSize;
    private LinkedList<String> _history = new LinkedList();
    private static ClipboardHistoryModel ONLY = null;

    public static synchronized ClipboardHistoryModel singleton() {
        if (ONLY == null) {
            ONLY = new ClipboardHistoryModel(10);
        }
        return ONLY;
    }

    private ClipboardHistoryModel(int maxSize) {
        this._maxSize = maxSize;
    }

    public void resize(int maxSize) {
        this._maxSize = maxSize;
        while (this._history.size() > this._maxSize) {
            this._history.removeFirst();
        }
    }

    public synchronized void put(String s) {
        this._history.remove(s);
        this._history.add(s);
        while (this._history.size() > this._maxSize) {
            this._history.removeFirst();
        }
    }

    public synchronized List<String> getStrings() {
        return new LinkedList<String>(this._history);
    }

    public synchronized String getMostRecent() {
        if (this._history.size() == 0) {
            return null;
        }
        return this._history.getLast();
    }
}

