/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.SplashScreen;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.classloader.ToolsJarClassLoader;
import edu.rice.cs.util.newjvm.ExecJVM;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DrJava {
    private static Log _log = new Log("DrJava.txt", false);
    public static final String TEST_DEBUGGER_CLASS = "com.sun.jdi.Bootstrap";
    public static final String TEST_14_COMPILER_CLASS = "com.sun.tools.javac.v8.JavaCompiler";
    public static final String TEST_15_16_COMPILER_CLASS = "com.sun.tools.javac.main.JavaCompiler";
    public static final String TEST_COMPILER_CLASS = System.getProperty("java.version").startsWith("1.4") ? "com.sun.tools.javac.v8.JavaCompiler" : "com.sun.tools.javac.main.JavaCompiler";
    private static final int PAUSE_TIME = 2000;
    private static final String DEFAULT_MAX_HEAP_SIZE_ARG = "-Xmx128M";
    private static final ArrayList<String> _filesToOpen = new ArrayList();
    private static final ArrayList<String> _jvmArgs = new ArrayList();
    static volatile boolean _showDebugConsole = false;
    public static final File DEFAULT_PROPERTIES_FILE;
    private static volatile File _propertiesFile;
    private static volatile FileConfiguration _config;
    private static ToolsJarClassLoader _toolsLoader;
    private static final ClassLoader _thisLoader;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$DrJava;

    public static File getPropertiesFile() {
        return _propertiesFile;
    }

    public static FileConfiguration getConfig() {
        return _config;
    }

    public static String[] getFilesToOpen() {
        return _filesToOpen.toArray(new String[0]);
    }

    public static boolean getShowDebugConsole() {
        return _showDebugConsole;
    }

    public static void main(String[] args) {
        final SplashScreen splash = new SplashScreen();
        splash.setVisible(true);
        splash.repaint();
        DrJava.configureAndLoadDrJavaRoot(args);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                splash.dispose();
            }
        });
    }

    public static void configureAndLoadDrJavaRoot(String[] args) {
        try {
            if (DrJava.handleCommandLineArgs(args)) {
                DrJava.checkForCompilersAndDebugger(args);
                String pathSep = System.getProperty("path.separator");
                String classPath = FileOps.convertToAbsolutePathEntries(System.getProperty("java.class.path"));
                File toolsFromConfig = DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION);
                classPath = classPath + pathSep + ToolsJarClassLoader.getToolsJarClassPath(toolsFromConfig);
                File workDir = new File(System.getProperty("user.home"));
                LinkedList<String> classArgsList = new LinkedList<String>();
                Iterator<String> i$ = _filesToOpen.iterator();
                while (i$.hasNext()) {
                    String fn = i$.next();
                    classArgsList.add(new File(fn).getAbsolutePath());
                }
                if (_showDebugConsole) {
                    classArgsList.add(0, "-debugConsole");
                }
                String[] jvmArgs = _jvmArgs.toArray(new String[0]);
                if (!_propertiesFile.equals(DEFAULT_PROPERTIES_FILE)) {
                    classArgsList.add(0, "-config");
                    classArgsList.add(1, _propertiesFile.getAbsolutePath());
                }
                String[] classArgs = classArgsList.toArray(new String[0]);
                try {
                    ExecJVM.runJVM("edu.rice.cs.drjava.DrJavaRoot", classArgs, classPath, jvmArgs, workDir);
                }
                catch (IOException ioe) {
                    String[] text = new String[]{"DrJava was unable to load its compiler and debugger.  Would you ", "like to start DrJava without a compiler and debugger?", "\nReason: " + ioe.toString()};
                    int result = JOptionPane.showConfirmDialog(null, text, "Could Not Load Compiler and Debugger", 0);
                    if (result != 0) {
                        System.exit(0);
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println(t.getClass().getName() + ": " + t.getMessage());
            t.printStackTrace(System.err);
            System.out.println("error thrown");
            new DrJavaErrorHandler().handle(t);
        }
    }

    static boolean handleCommandLineArgs(String[] args) {
        String jvmArgString;
        List<String> jvmArgs;
        boolean heapSizeGiven = false;
        int argIndex = 0;
        int len = args.length;
        _filesToOpen.clear();
        while (argIndex < len) {
            String arg;
            if ((arg = args[argIndex++]).equals("-config")) {
                if (len == argIndex) {
                    return true;
                }
                DrJava.setPropertiesFile(args[argIndex++]);
                _config = DrJava._initConfig();
                _toolsLoader = new ToolsJarClassLoader(DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION));
                continue;
            }
            if (arg.length() > 1 && arg.substring(0, 2).equals("-X")) {
                if (arg.substring(0, 4).equals("-Xmx")) {
                    heapSizeGiven = true;
                }
                _jvmArgs.add(arg);
                continue;
            }
            if (arg.length() > 1 && arg.substring(0, 2).equals("-D")) {
                _jvmArgs.add(arg);
                continue;
            }
            if (arg.equals("-debugConsole")) {
                _showDebugConsole = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                DrJava.displayUsage();
                return false;
            }
            --argIndex;
            break;
        }
        if ((jvmArgs = ArgumentTokenizer.tokenize(jvmArgString = DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_ARGS))) != null && jvmArgs.size() != 0) {
            _jvmArgs.addAll(jvmArgs);
        }
        if (PlatformFactory.ONLY.isMacPlatform()) {
            _jvmArgs.add("-Dcom.apple.macos.useScreenMenuBar=true");
            _jvmArgs.add("-Xdock:name=DrJava");
            _jvmArgs.add("-Xdock:icon=/Applications/DrJava.app/Contents/Resources/DrJava.icns");
        }
        if (!heapSizeGiven && jvmArgString.indexOf("-Xmx") < 0) {
            _jvmArgs.add(DEFAULT_MAX_HEAP_SIZE_ARG);
        }
        _log.log("_jvmArgs = " + _jvmArgs);
        for (int i = argIndex; i < len; ++i) {
            _filesToOpen.add(args[i]);
        }
        return true;
    }

    static void displayUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append("Usage: java -jar drjava.jar [OPTIONS] [FILES]\n\n");
        buf.append("where options include:\n");
        buf.append("  -config [FILE]        use a custom config file\n");
        buf.append("  -help | -?            print this help message\n");
        buf.append("  -X<jvmOption>         specify a JVM configuration option for the master DrJava JVM\n");
        buf.append("  -D<name>[=<value>]    set a Java property for the master DrJava JVM\n");
        System.out.print(buf.toString());
    }

    static void checkForCompilersAndDebugger(String[] args) {
        boolean needDebugger;
        boolean needCompiler = !DrJava.hasAvailableCompiler();
        boolean bl = needDebugger = !DrJava.hasAvailableDebugger();
        if (needCompiler || needDebugger) {
            DrJava.promptForToolsJar(needCompiler, needDebugger);
        }
    }

    public static boolean hasAvailableDebugger() {
        return DrJava.canLoad(_thisLoader, TEST_DEBUGGER_CLASS) || DrJava.canLoad(_toolsLoader, TEST_DEBUGGER_CLASS);
    }

    public static boolean hasAvailableCompiler() {
        return DrJava.canLoad(_thisLoader, TEST_COMPILER_CLASS) || DrJava.canLoad(_toolsLoader, TEST_COMPILER_CLASS);
    }

    public static boolean canLoad(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (UnsupportedClassVersionError e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static void promptForToolsJar(boolean needCompiler, boolean needDebugger) {
        File selectedFile = DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION);
        String selectedVersion = DrJava._getToolsJarVersion(selectedFile);
        String[] text = selectedVersion == null ? new String[]{"DrJava cannot find a 'tools.jar' file for the version of Java ", "that is being used to run DrJava (Java version " + System.getProperty("java.version") + ").", "Would you like to specify the location of the requisite 'tools.jar' file?", "If you say 'No', DrJava might be unable to compile or debug Java programs."} : new String[]{"DrJava cannot find a 'tools.jar' file for the version of Java ", "that is being used to run DrJava (Java version " + System.getProperty("java.version") + ").", "The file you have selected appears to be for version " + selectedVersion + ".", "Would you like to specify the ocation of the requisite 'tools.jar' file?", "If you say 'No', DrJava might be unable to compile or debug Java programs.)"};
        int result = JOptionPane.showConfirmDialog(null, text, "Locate 'tools.jar'?", 0);
        if (result == 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new ClassPathFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String ext = 2.getExtension(f);
                    return ext != null && ext.equals("jar");
                }

                public String getDescription() {
                    return "Jar Files";
                }
            });
            do {
                File jar;
                if (chooser.showOpenDialog(null) != 0 || (jar = chooser.getSelectedFile()) == null) continue;
                DrJava.getConfig().setSetting(OptionConstants.JAVAC_LOCATION, jar);
                if (needCompiler && DrJava.classLoadersCanFind(TEST_COMPILER_CLASS)) {
                    needCompiler = false;
                }
                if (!needDebugger || !DrJava.classLoadersCanFind(TEST_DEBUGGER_CLASS)) continue;
                needDebugger = false;
            } while ((needCompiler || needDebugger) && DrJava._userWantsToPickAgain());
            if (!needCompiler && !needDebugger) {
                DrJava._saveConfig();
            }
        }
    }

    public static boolean classLoadersCanFind(String className) {
        File jar = DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION);
        if (jar != FileOption.NULL_FILE) {
            try {
                URL[] urls = new URL[]{FileOps.toURL(jar)};
                URLClassLoader loader = new URLClassLoader(urls);
                if (DrJava.canLoad(loader, className)) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return DrJava.canLoad(_toolsLoader, className);
    }

    static void setPropertiesFile(String fileName) {
        if (!fileName.endsWith(".java")) {
            _propertiesFile = new File(fileName);
        }
    }

    static FileConfiguration _initConfig() throws IllegalStateException {
        try {
            _propertiesFile.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        FileConfiguration config = new FileConfiguration(_propertiesFile);
        try {
            config.loadConfiguration();
        }
        catch (Exception e) {
            config.resetToDefaults();
            config.storeStartupException(e);
        }
        _config = config;
        return config;
    }

    protected static void _saveConfig() {
        try {
            DrJava.getConfig().saveConfiguration();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not save the location of tools.jar in \nthe '.drjava' file in your home directory. \nAnother process may be using the file.\n\n" + e, "Could Not Save Changes", 0);
        }
    }

    private static boolean _userWantsToPickAgain() {
        File selectedFile = DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION);
        String selectedVersion = DrJava._getToolsJarVersion(selectedFile);
        String[] text = selectedVersion == null ? new String[]{"The file you chose did not appear to be the correct 'tools.jar'", "that is compatible with the version of Java that is used to", "run DrJava (Java version " + System.getProperty("java.version") + ").", "Your choice might be an incompatible version of the file.", "Would you like to pick again?  The 'tools.jar' file is ", "generally located in the 'lib' subdirectory under your ", "JDK installation directory.", "(If you say 'No', DrJava might be unable to compile or ", "debug programs.)"} : new String[]{"The file you chose did not appear to be the correct 'tools.jar'", "that is compatible with the version of Java that is used to", "run DrJava (Java version " + System.getProperty("java.version") + ").", "The file you have selected appears to be for", "Java version " + selectedVersion + ".", "Your choice might be an incompatible version of the file.", "Would you like to pick again?  The 'tools.jar' file is ", "generally located in the 'lib' subdirectory under your ", "JDK installation directory.", "If you say 'No', DrJava might be unable to compile or ", "debug programs."};
        int result = JOptionPane.showConfirmDialog(null, text, "Locate 'tools.jar'?", 0);
        return result == 0;
    }

    private static String _getToolsJarVersion(File toolsJarFile) {
        try {
            JarFile jf = new JarFile(toolsJarFile);
            Manifest mf = jf.getManifest();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mf.write(baos);
            String str = baos.toString();
            String CB = "Created-By: ";
            int beginPos = str.indexOf("Created-By: ");
            if (beginPos >= 0) {
                int endPos = str.indexOf(System.getProperty("line.separator"), beginPos += "Created-By: ".length());
                if (endPos >= 0) {
                    return str.substring(beginPos, endPos);
                }
                endPos = str.indexOf(32, beginPos);
                if (endPos >= 0) {
                    return str.substring(beginPos, endPos);
                }
                endPos = str.indexOf(9, beginPos);
                if (endPos >= 0) {
                    return str.substring(beginPos, endPos);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        _propertiesFile = DEFAULT_PROPERTIES_FILE = new File(System.getProperty("user.home"), ".drjava");
        _config = DrJava._initConfig();
        _toolsLoader = new ToolsJarClassLoader(DrJava.getConfig().getSetting(OptionConstants.JAVAC_LOCATION));
        _thisLoader = (class$edu$rice$cs$drjava$DrJava == null ? (class$edu$rice$cs$drjava$DrJava = DrJava.class$("edu.rice.cs.drjava.DrJava")) : class$edu$rice$cs$drjava$DrJava).getClassLoader();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

