import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import javax.imageio.*;
import java.io.*;

/** An instance is a JPanel that contains one image. Since it is
    a JPanel, it can be placed in a JFrame. The system calls method
    paint whenever it is necessary to redraw the image.<br><br>
   */
public class ImagePanel extends JPanel {
    
    private Image image;        // the image on the canvas
    private ImageJFrame jframe; // The JFrame in which this JPanel appears
 
    /** Constructor: a panel for image im in window jf */
    public ImagePanel(Image im, ImageJFrame jf) {
        jframe= jf;
        image= im;// store the dimensions of the image map
        if (im == null)
            return;
        int rows= image.getHeight(this);
        int cols= image.getWidth(this);
        setPreferredSize(new Dimension(cols, rows));
    }
    
    /** = the image on this panel */
    public Image getImage() {
      return image;
    }
    
    /** = the frame in which this panel appears */
    public ImageJFrame getFrame() {
      return jframe;
    }
    /** Display the image on this JPanel. This method is
        called by the system whenever it has to redraw
        the JPanel */
    public void paint(Graphics g) {
        g.drawImage(image, 0, 0, this);
    }
    
    /** Change the image in the image panel to im.
        This requires manipulating the JFrame in which
        the panel appears. */
    public void changeImage(Image im) {
        image= im;
        if (im == null) {
            jframe.setVisible(false);
            return;
        }
        int rows= image.getHeight(this);
        int cols= image.getWidth(this);
        setPreferredSize(new Dimension(cols,rows));
        jframe.resizeImage(im);
    }
    
     /** Store the current image in file filename in the specified format */
    public void write(String filename, String format) throws java.io.IOException {
      BufferedImage bimage= 
          new BufferedImage(image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB);
      Graphics g= bimage.createGraphics();

      g.drawImage(image, 0, 0, null);
      g.dispose();
      File f= new File(filename);
      ImageIO.write(bimage, format, f);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
}



