import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.net.*;
import java.io.*;

/** An instance contains 
 (1) an image,
 (2) the name (path) of the file from which it was read,
 (3) the image in a JPanel, for putting in a JFrame,
 (4) an ImageMap that allows the displayed image
 (but not the file from which it came) to be changed,
 (5) a copy of the original ImageMap (for possible restoration),  
 */
public class ImageMaintainer extends ImagePanel {
    
    private String fileName;   // The name (the whole path) of the file for this image
    private ImageMap imageMap; // A map of image, which allows us to change it
    
    private ImageMap originalMap; // The original image map, for restoration purposes
    
    /** Constructor: an instance for image im (none if im = null) with title fileName
     in JPanel jf*/
    public ImageMaintainer(Image im, String fileName, ImageJFrame jf) {
        super(im, jf);
        this.fileName= fileName;
        imageMap= new ImageMap(im, im.getHeight(this), im.getWidth(this));
        originalMap= imageMap.copy();
    }
    
    /** = the filename for this image */
    public String getFileName() {
        return fileName;
    }
    
    /** = the ImageMap, which allows us to change the image */
    public ImageMap getImageMap() {
        return imageMap;
    }
    
    /** Change the image map to map and change image accordingly */
    public void formImage(ImageMap map) {
        int c= map.getCols();
        int r= map.getRows();
        changeImage(createImage(
                                new MemoryImageSource(c,r,map.getMap(),0,c)));
    }
    
    /** Invert the image, replacing each element with its color complement
     When done, call formImage(imageMap). */
    public void invert() {
        DirectColorModel dm = (DirectColorModel) ColorModel.getRGBdefault();
        
        int rows= imageMap.getRows();
        int cols= imageMap.getCols();
        // invert all pixels (leave alpha/transparency value alone)
        for (int i=0; i<rows; i++) {
            for (int j=0; j<cols; j++) {
                int rgb= imageMap.getPixel(i,j);
                int red= 255 - dm.getRed(rgb);
                int blue= 255 - dm.getBlue(rgb);
                int green= 255 - dm.getGreen(rgb);
                int alpha= dm.getAlpha(rgb);
                imageMap.setPixel(i,j,
                                  (alpha << 24) | (red << 16) | (green << 8) | blue);
            } 
        }
        formImage(imageMap);
    }
    
    /** Transpose this image --which is in variable imageMap.
     This required constructing a new variable b (say) of class
     imageMap, storing the transpose of imageMap in b, and then
     assigning b to imageMap. When done, call formImage(imageMap).
     */
    public void transpose() {
        /** FILL THIS IN */
        
        formImage(imageMap);
    }
    
    /** Reflect this image (in variable imageMap) around the
     horizontal middle. When done, call formImage(imageMap).
     */
    public void hreflect() {
        int rows= imageMap.getRows();
        int cols= imageMap.getCols();
        int h= 0;
        int k= rows-1;
        //invariant: rows 0..h-1 and k+1.. have been inverted
        while (h < k) {
            // Swap row h with row k
            for (int c= 0; c != cols; c= c+1) {
                imageMap.swapPixels(h,c,k,c);
            }
            
            h= h+1; k= k-1;
        }
        formImage(imageMap);
    }
    
    /** Reflect this image (in variable imageMap) around
     the vertical middle. When done, call formImage(imageMap).
     */
    public void vreflect() {
        int rows= imageMap.getRows();
        int cols= imageMap.getCols();
        int h= 0;
        int k= cols-1;
        //invariant: cols 0..h-1 and k+1.. have been inverted
        while (h < k) {
            // Swap column h with column k
            for (int r= 0; r != rows; r= r+1) {
                imageMap.swapPixels(r, h, r, k);
            }
            
            h= h+1; k= k-1;
        }
        formImage(imageMap);
    }
    
    /* Filter the image to be only a single color. If color == 0, use grey;
       1, red; 2, green; 3, blue. When done, call formImage(imageMap); .
       If color is not in 0..3, print an error message and return without
       changing the image.
       Grey is achieved by making all three color components equal to the
       average of the red, green, and blue components. For the other three
       colors, make the non-used components 0. The alpha component should
       not be changed.
     */
    public void filter(int color) {
      DirectColorModel dm = (DirectColorModel) ColorModel.getRGBdefault();
      
      /** FILL THIS IN */
      
      formImage(imageMap);
    }
    
    
    /* assuming the image is broken up into blocks, with nr rows
     and nc columns of blocks, set all pixels of the
     block at position (row, col) to pixel value pixel.
     When done, call formImage(imageMap).
     Precondition: 0  row < nr  and  0  col < nc */
    public void setBlock(int row, int col, int nr, int nc, int pixel) {
        
        /** FILL THIS IN */
        
        formImage(imageMap);
    }
    
    /* assuming the image is broken up into blocks, with nr rows
     of blocks and nc columns of blocks, swap all pixels of
     the blocks at positions (row0, col0) and (row1, col1).
     When done, call formImage(imageMap).*/
    public void swapBlocks(int row0, int col0, int row1, int col1, int nr, int nc) {
        
        /** FILL THIS IN */
        
        formImage(imageMap);
    }
    
    /** Restore the original image */
    public void restore() {
        imageMap= originalMap.copy();
        formImage(imageMap);
    }
    
}