import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.image.*;

/** An instance is a JFrame that contains an image with a title.
    When no image is in the JFrame, it is hidden.
    When an image is placed in it, it becomes visible. */
public class ImageJFrame extends JFrame implements ActionListener {
    
    // The panel on which the image and the title is placed
    private ImageMaintainer panel; 
    
    // Buttons
    JButton buttonrestore= new JButton("restore");
    JButton buttoninvert= new JButton("invert");
    JButton buttontranspose= new JButton("transpose");
    JButton buttonhreflect= new JButton("horiz reflect");
    JButton buttonvreflect= new JButton("vert reflect");
    JButton buttonfilter= new JButton("filter");
    JButton buttonmoveup= new JButton("space up");
    JButton buttonmovedown= new JButton("space down");
    JButton buttonmoveleft= new JButton("space left");
    JButton buttonmoveright= new JButton("space right");
    Box buttonBox= new Box(BoxLayout.Y_AXIS);
    
    // Three radio buttons
    JRadioButton greyButton= new JRadioButton("grey", true);
    JRadioButton redButton= new JRadioButton("red", false);
    JRadioButton greenButton= new JRadioButton("green", false);
    JRadioButton blueButton= new JRadioButton("blue", false);
    Box checkboxBox= new Box(BoxLayout.X_AXIS);
    
    ButtonGroup group= new ButtonGroup();
    
    Box inputBox= new Box(BoxLayout.Y_AXIS);
    
    // The JPanel for the histogram
    JPanel histogramPanel= new JPanel();
    
    
     
    /** A jframe with a picture in it. If pars is null, the title
     is "picture". Otherwise pars[0] is used as the title. */
    public static void main(String[] pars) {
        ImageJFrame ij;
        ij= new ImageJFrame("picture");
        /*if (pars == null)
            ij= new ImageJFrame("picture");
        else
            ij= new ImageJFrame(pars[0]);*/
    }
    
    /** Constructor: an instance for Image im with title t.
        If im is null, the window is not shown. */
    public ImageJFrame(Image im, String t) {
        setUp(im, t);
    }
    
    /** Constructor: an instance for an Image that is found using a file dialog
        window and with title t. If no Image is produced using the file dialog,
        use null as the Image*/
    public ImageJFrame(String t) {
        String f= getImageName();
        Image im= getImage(f, this);
        setUp(im, t); 
    }

    /** Set up JFrame with im and t */
    private void setUp(Image im, String t) {
        panel= new ImageMaintainer(im, t, this);
        getContentPane().add(BorderLayout.CENTER, panel);
        
        buttonBox.add(buttonrestore);
        buttonBox.add(buttoninvert);
        buttonBox.add(buttontranspose);
        buttonBox.add(buttonhreflect);
        buttonBox.add(buttonvreflect);
        buttonBox.add(buttonfilter);
        buttonBox.add(buttonmoveup);
        buttonBox.add(buttonmoveleft);
        buttonBox.add(buttonmoveright);
        buttonBox.add(buttonmovedown);
        getContentPane().add(BorderLayout.WEST, buttonBox);
        
        buttonrestore.addActionListener(this);
        buttoninvert.addActionListener(this);
        buttontranspose.addActionListener(this);
        buttonhreflect.addActionListener(this);
        buttonvreflect.addActionListener(this);
        buttonfilter.addActionListener(this);
        buttonmoveup.addActionListener(this);
        buttonmovedown.addActionListener(this);
        buttonmoveleft.addActionListener(this);
        buttonmoveright.addActionListener(this);
        
        checkboxBox.add(greyButton);
        checkboxBox.add(redButton);
        checkboxBox.add(greenButton);
        checkboxBox.add(blueButton);
        inputBox.add(checkboxBox);
        
        group.add(greyButton);
        group.add(redButton);
        group.add(blueButton);
        group.add(greenButton);
        
        getContentPane().add(BorderLayout.NORTH, inputBox);
   
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        setLocation(200,100);
        
        placeImage(im,t);  //place im with title t in the JFrame
    }
    
    /** Pause the program for d microseconds */
    public void pause(int d) {
        try { Thread.currentThread().sleep(d); }
        catch (InterruptedException e) { }
    }
     
    /** = the grey check box in the GUI is selected */
    public boolean greyIsChecked() {
        return greyButton.isSelected();
    }
    /** = the red check box in the GUI is selected */
    public boolean redIsChecked() {
        return redButton.isSelected();
    }
    
    /** = the green check box in the GUI is selected */
    public boolean greenIsChecked() {
        return greenButton.isSelected();
    }
    
    /** = the red check box in the GUI is selected */
    public boolean blueIsChecked() {
        return blueButton.isSelected();
    }
    
    /** = the panel on which the image is placed */
    public ImagePanel getImagePanel() {
        return panel;
    }
    
    /** set the image in the JFrame to im; leave the title unchanged.
        If im is null, any image is removed and the JFrame is hidden */
    public void setImage(Image im) {
        placeImage(im, getTitle());
    }
    
    /** Remove the image in this JFrame (if any), put image
        im there, with title t. If im is null, make the window 
        invisible; otherwise, make it visible */
    public void placeImage(Image im, String t) {
        setTitle(t);
        panel.changeImage(im);
        if (im == null) {
            setVisible(false);
            return;
        }
        
        //  {image is not null and should be visible } 
        ImageMap map= panel.getImageMap();
        int rows= im.getHeight(this);
        int cols= im.getWidth(this);
        panel.setPreferredSize(new Dimension(cols, rows));
        panel.setSize(new Dimension(cols, rows));
        //setSize(new Dimension(cols, rows));
        pack();
        setVisible(true);
        repaint();
    }
    
    /** set the size as in non-null image im and repack */
    public void resizeImage(Image im) {
        int rows= im.getHeight(this);
        int cols= im.getWidth(this);
        //setSize(new Dimension(cols, rows));
        panel.setPreferredSize(new Dimension(cols, rows));
        panel.setSize(new Dimension(cols, rows));
        pack();
        setVisible(true);
        repaint();
    }
    
    /** = the file name of an image loaded by the user using a dialog window */
    public static String getImageName() {
        FileDialog fd = new FileDialog(new Frame(), "Open File", FileDialog.LOAD);
        fd.setVisible(true);
        if (fd.getFile() == null) 
            return null;
        return fd.getDirectory() + fd.getFile();
    }
    
    /** = the image for file name f, using the toolkit for jframe */
    public static Image getImage(String f, JFrame jframe) {
        Image image= null;
        try {
            image= jframe.getToolkit().getImage(new URL("file:" + f));
        } 
        catch (MalformedURLException e) {
            System.err.println("Bad URL!");
            return null;
        }
        // set media tracker to wait for image to load
        MediaTracker tracker= new MediaTracker(jframe);
        tracker.addImage(image,0);    
        
        // wait for image to load
        try { tracker.waitForID(0); 
        }
        catch (InterruptedException e) {
            // handler.flashMessage(ImageHandler.LOAD_INTERRUPTED);
            return null;
        }
        return image;
    }
    
    /** Process a click of one of the buttons */
    public void actionPerformed(ActionEvent e) {
        // The only button presses that have effect if
        // this is a BlockGame is the filter button
        if (this instanceof BlockGame) {
            if (e.getSource() == buttonmoveup) {
                move(0);
                return;
            }
            if (e.getSource() == buttonmovedown) {
                move(1);
                return;
            }
            if (e.getSource() == buttonmoveleft) {
                move(2);
                return;
            }
            if (e.getSource() == buttonmoveright) {
                move(3);
                return;
            }
            System.out.println("This is a BlockGame. Can only move the space around");
            return;
        }
        
        // Space can be moved only in a BlockGame
        if (e.getSource() == buttonmoveup || e.getSource() == buttonmovedown ||
            e.getSource() == buttonmoveleft || e.getSource() == buttonmoveright) {
            System.out.println("Can move the space only in a BlockGame");
            return;
        }
        
        // this is not a BlockGame
        if (e.getSource() == buttonrestore) {
            panel.restore();
            return;
        }
        if (e.getSource() == buttoninvert) {
            panel.invert();
            return;
        }
        if (e.getSource() == buttontranspose) {
            panel.transpose();
            return;
        }
        if (e.getSource() == buttonhreflect) {
            panel.hreflect();
            return;
        }
        if (e.getSource() == buttonvreflect) {
            panel.vreflect();
            return;
        }
        
        if (e.getSource() == buttonfilter) {
            if (greyIsChecked()) {
                panel.filter(0);
                return;
            }
            if (redIsChecked()) {
                panel.filter(1);
                return;
            }
            if (greenIsChecked()) {
                panel.filter(2);
                return;
            }
            if (blueIsChecked()) {
                panel.filter(3);
                return;
            }
        }
        
        
         
    }
    
    
    /** Invert the image */
    public void invert() {
        panel.invert();
    }
    
    /** Transpose the image */
    public void transpose() {
        panel.transpose();
    }
     
    /** Reflect the image around the horizontal middle */
    public void hreflect() {
        panel.hreflect();
    }
    
    /** Reflect the image around the vertical middle */
    public void vreflect() {
        panel.vreflect();
    }
    
    /** Restore the original image */
    public void restore() {
        panel.restore();
    }
    
    /** Filter the image according to the grey-red-blue-green buttons */
    public void filter() {
        if (greyIsChecked()) {
            panel.filter(0);
            return;
        }
    }
    
    /** Move a block in direction gives by d:
       0 means up.
       1 means down.
       2 means left.
       3 means right. */
    public void move(int d) {
        if (this instanceof BlockGame) {
            BlockGame bg= (BlockGame)(this);
            bg.move(d);
        }
    }
    
    /* Assume the image is broken up into blocks, with nr rows
       and nc columns of blocks. Set all pixels of
       the block at position (row, col) to pixel value pixel
       Precondition: 0  row < nr  and 0  col < nc */
    public void setBlock(int row, int col, int nr, int nc, int pixel) {
        panel.setBlock(row, col, nr, nc, pixel);
    }

    /* Assume the image is broken up into blocks, with nr rows
       of blocks and nc columns of blocks. Swap all pixels of the blocks
       at positions (r0, c0) and (r1, c1)
       */
    public void swapBlocks(int r0, int c0, int r1, int c1, int nr, int nc) {
        panel.swapBlocks(r0, c0, r1, c1, nr, nc);
    }
    
    
    
            
 
}