/** An instance contains an image in a window with which one
    can play the fifteen shuffle game (with any rectangular
    number of blocks). */
public class BlockGame extends ImageJFrame {
    private int width; // the image will be this many blocks wide
    private int height; // the image will be this many blocks high
    private int spaceRow; // the row of where the space is
    private int spaceCol; // the column of where the space is
    
    /* Constructor: a new block game with an image chosen by user.
       The image has r rows blocks and c columns of blocks.
       The space starts at block (0,0). 
       The window in which the game appears in titled t
       Precondition: r and c are > 0.*/
    public BlockGame(String t, int r, int c) {
        this(t, r, c, 0,0);
    }
    
    /* Constructor: a new block game with an image chosen by user.
       The image has r rows blocks and c columns of blocks.
       The space starts at block (spaceRow, spaceCol), e.g.(0,0)
       is the top left.
       The window in which the game appears in titled t
       Precondition: 0 < r, 0 < c are > 0, 0  spaceRow < r,
       and 0  spaceCol < c. */
    public BlockGame(String t, int r, int c, int spaceRow, int spaceCol) {
        super(t);
        this.height= r;
        this.width= c;
        this.spaceRow= spaceRow;
        this.spaceCol= spaceCol;
        setBlock(spaceRow, spaceCol, r, c, 0);
    }
    /* Move the empty space, swapping it with the block in the
     appropriate direction.
     0 means up.
     1 means down.
     2 means left.
     3 means right.
     If any other number is given, or if the move would go
     off the edge of the image, print an error message.
     When done, execute these two statements so that the
     image will be painted properly.
        ImageMaintainer im= (ImageMaintainer)getImagePanel();
        im.formImage(im.getImageMap());
     */
    public void move(int dir) {
        int destRow= spaceRow;
        int destCol= spaceCol;
        if (dir == 0 && spaceRow > 0) destRow= spaceRow-1;
        else if (dir == 1 && spaceRow < height - 1) destRow= spaceRow+1;
        else if (dir == 2 && spaceCol > 0) destCol= spaceCol-1;
        else if (dir == 3 && spaceCol < width - 1) destCol= spaceCol+1;
        else {
            System.out.println("illegal move!");
            return;
        }
        swapBlocks(spaceRow, spaceCol, destRow, destCol, height, width);
        spaceCol= destCol;
        spaceRow= destRow;
        ImageMaintainer im= (ImageMaintainer)getImagePanel();
        im.formImage(im.getImageMap());
    }
    
}