/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.LeftHandSide;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedName
extends PrimaryExpression
implements LeftHandSide {
    public static final String IDENTIFIERS = "identifiers";
    public static final String REPRESENTATION = "representation";
    private List<IdentifierToken> identifiers;
    private String representation;

    public QualifiedName(List<IdentifierToken> ids) {
        this(ids, null, 0, 0, 0, 0);
    }

    public QualifiedName(List<IdentifierToken> ids, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (ids == null) {
            throw new IllegalArgumentException("ids == null");
        }
        this.identifiers = ids;
        this.representation = TreeUtilities.listToName(ids);
    }

    public String getRepresentation() {
        return this.representation;
    }

    public List<IdentifierToken> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifier(List<IdentifierToken> l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.identifiers = l;
        this.firePropertyChange(IDENTIFIERS, this.identifiers, this.identifiers);
        this.representation = TreeUtilities.listToName(l);
        this.firePropertyChange(REPRESENTATION, this.representation, this.representation);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.getRepresentation()).append(")").toString();
    }
}

