/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalExpression
extends Expression {
    public static final String CONDITION_EXPRESSION = "conditionExpression";
    public static final String IF_TRUE_EXPRESSION = "ifTrueExpression";
    public static final String IF_FALSE_EXPRESSION = "ifFalseExpression";
    private Expression conditionExpression;
    private Expression ifTrueExpression;
    private Expression ifFalseExpression;

    public ConditionalExpression(Expression cexp, Expression texp, Expression fexp) {
        this(cexp, texp, fexp, null, 0, 0, 0, 0);
    }

    public ConditionalExpression(Expression cexp, Expression texp, Expression fexp, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (cexp == null) {
            throw new IllegalArgumentException("cexp == null");
        }
        if (texp == null) {
            throw new IllegalArgumentException("texp == null");
        }
        if (fexp == null) {
            throw new IllegalArgumentException("fexp == null");
        }
        this.conditionExpression = cexp;
        this.ifTrueExpression = texp;
        this.ifFalseExpression = fexp;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.conditionExpression = e;
        this.firePropertyChange(CONDITION_EXPRESSION, this.conditionExpression, this.conditionExpression);
    }

    public Expression getIfTrueExpression() {
        return this.ifTrueExpression;
    }

    public void setIfTrueExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.ifTrueExpression = e;
        this.firePropertyChange(IF_TRUE_EXPRESSION, this.ifTrueExpression, this.ifTrueExpression);
    }

    public Expression getIfFalseExpression() {
        return this.ifFalseExpression;
    }

    public void setIfFalseExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.ifFalseExpression = e;
        this.firePropertyChange(IF_FALSE_EXPRESSION, this.ifFalseExpression, this.ifFalseExpression);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.getConditionExpression()).append(" ").append(this.getIfTrueExpression()).append(" ").append(this.getIfFalseExpression()).append(")").toString();
    }
}

