/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.modifier;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayModifier
extends LeftHandSideModifier {
    protected ArrayAccess node;
    protected Object array;
    protected Number cell;
    protected List<Object> arrays = new LinkedList<Object>();
    protected List<Number> cells = new LinkedList<Number>();

    public ArrayModifier(ArrayAccess aa) {
        this.node = aa;
    }

    @Override
    public Object prepare(Visitor<Object> v, Context ctx) {
        this.arrays.add(0, this.array);
        this.cells.add(0, this.cell);
        this.array = this.node.getExpression().acceptVisitor(v);
        Object o = this.node.getCellNumber().acceptVisitor(v);
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        this.cell = (Number)o;
        return Array.get(this.array, this.cell.intValue());
    }

    @Override
    public void modify(Context ctx, Object value) {
        try {
            Array.set(this.array, this.cell.intValue(), value);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("array element type mismatch")) {
                throw new ArrayStoreException();
            }
            throw e;
        }
        finally {
            this.array = this.arrays.remove(0);
            this.cell = this.cells.remove(0);
        }
    }
}

